/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.ExecProcess;
import com.sun.management.services.authentication.LoginConstants;
import com.sun.management.services.authentication.PamCallback;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserRoleCredential;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PamLoginModule
implements LoginModule {
    private Subject subject;
    private Map sharedState;
    private boolean succeeded;
    private boolean commitSucceeded;
    private CallbackHandler ccbh;
    private String user;
    private String host;
    private PasswordCredential cred;
    private UserRolePrincipal up;
    private UserRoleCredential pc;
    private String commandPath;
    private String className;
    private boolean try_first_pass;
    private boolean try_mapped_pass;
    private boolean use_first_pass;
    private boolean use_mapped_pass;
    private boolean debug = false;
    private static final String DEFAULT_CLASS_NAME = "/jsp/login/UserLogin.jsp";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.ccbh = callbackHandler;
        this.sharedState = map;
        this.commandPath = null;
        this.className = null;
        this.use_first_pass = true;
        this.try_first_pass = false;
        this.use_mapped_pass = false;
        this.try_mapped_pass = false;
        Object var5_5 = null;
        if (map2 != null) {
            this.className = (String)map2.get("presentation_class");
            this.commandPath = (String)map2.get("commandPath");
        }
        if (this.commandPath == null) {
            this.commandPath = LoginConstants.PAMVERIFIER_DEFAULT_PATH;
        }
        if (this.className == null) {
            this.className = DEFAULT_CLASS_NAME;
        }
        this.user = null;
        this.host = null;
        this.cred = null;
        this.succeeded = false;
        this.commitSucceeded = false;
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        if (this.sharedState != null) {
            this.user = (String)this.sharedState.get("javax.security.auth.login.name");
            this.cred = (PasswordCredential)this.sharedState.get("javax.security.auth.login.password");
            this.host = (String)this.sharedState.get("console.login.host");
        }
        int n = -1;
        if (this.user != null && this.user.trim().length() > 0) {
            try {
                n = this.attemptLogin(this.user, this.cred, this.host);
            }
            catch (Exception exception) {
                throw new LoginException("PamLogin: login failed: " + exception.getMessage());
            }
        }
        switch (n) {
            case 0: {
                Debug.trace1((String)("PamLogin: login succeeded: " + this.user));
                this.setAuthValues(this.user, this.cred, this.host);
                this.succeeded = true;
                this.sharedState.put("pam.login.success", "true");
                return true;
            }
            case 1: {
                Debug.trace1((String)("PamLogin: unknown user: " + this.user));
                throw new LoginException("PamLogin: login failed");
            }
            case 2: {
                if (!this.use_first_pass && !this.use_mapped_pass) break;
                Debug.trace1((String)("PamLogin: login failed: " + this.user));
                throw new FailedLoginException("PamLogin: login failed");
            }
        }
        int n2 = -1;
        Callback[] callbackArray = new Callback[1];
        try {
            PamCallback pamCallback = new PamCallback();
            callbackArray[0] = pamCallback;
            ((PamCallback)((Object)callbackArray[0])).setPresentationClassName(this.className);
            if (this.user != null) {
                pamCallback.setUser(this.user);
            }
            this.ccbh.handle(callbackArray);
            this.user = pamCallback.getUser();
            this.cred = pamCallback.getUserCredential();
            this.host = pamCallback.getHost();
            n2 = this.attemptLogin(this.user, this.cred, this.host);
        }
        catch (Exception exception) {
            Debug.trace1((String)("PamLogin: login failed: " + exception.getMessage()));
            throw new LoginException("PamLogin: login failed");
        }
        try {
            if (this.sharedState != null) {
                this.sharedState.put("javax.security.auth.login.name", this.user);
                this.sharedState.put("javax.security.auth.login.password", this.cred);
                this.sharedState.put("console.login.host", this.host);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("PamLogin: error setting shared state: " + exception.getMessage()));
        }
        this.succeeded = false;
        switch (n2) {
            case 0: {
                Debug.trace1((String)("PamLogin: login succeeded: " + this.user));
                this.setAuthValues(this.user, this.cred, this.host);
                this.sharedState.put("pam.login.success", "true");
                this.succeeded = true;
                break;
            }
            case 1: {
                Debug.trace1((String)("PamLogin: unknown user: " + this.user));
                throw new LoginException("PamLogin: login failed");
            }
            default: {
                Debug.trace1((String)"PamLogin: login failed: pamverifier");
                throw new LoginException("PamLogin: login failed");
            }
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded) {
            if (this.subject != null) {
                if (this.up != null && !this.subject.getPrincipals().contains(this.up)) {
                    this.subject.getPrincipals().add(this.up);
                }
                if (this.pc != null && !this.subject.getPrivateCredentials().contains(this.pc)) {
                    this.subject.getPrivateCredentials().add(this.pc);
                }
                this.commitSucceeded = true;
            } else {
                throw new LoginException("PamLogin: commit failed");
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.commitSucceeded) {
            this.logout();
        }
        this.up = null;
        if (this.pc != null) {
            this.pc.clearUserPassword();
            this.pc.clearRolePassword();
            this.pc = null;
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.subject != null) {
            int n;
            Object[] objectArray = this.subject.getPrincipals().toArray();
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof UserRolePrincipal)) continue;
                this.subject.getPrincipals().remove(objectArray[n]);
                break;
            }
            objectArray = this.subject.getPrivateCredentials().toArray();
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof UserRoleCredential)) continue;
                UserRoleCredential userRoleCredential = (UserRoleCredential)objectArray[n];
                this.subject.getPrivateCredentials().remove(this.pc);
                userRoleCredential.clearUserPassword();
                userRoleCredential.clearRolePassword();
                break;
            }
        }
        return true;
    }

    private int attemptLogin(String string, PasswordCredential passwordCredential, String string2) {
        int n = -1;
        ExecProcess execProcess = null;
        try {
            String[] stringArray;
            String string3 = this.commandPath + "/pamverifier";
            String[] stringArray2 = new String[]{string3, "authuser", string, "NULL", this.cred.getUserPassword()};
            execProcess = new ExecProcess(stringArray2);
            Vector vector = null;
            try {
                vector = execProcess.exec();
            }
            catch (Exception exception) {
                Debug.trace1((String)("PamLogin: login failed: " + exception.getMessage()));
            }
            n = 2;
            if (vector != null && vector.size() != 0 && (stringArray = (String[])vector.elementAt(0)) != null && stringArray.length > 0) {
                n = Integer.parseInt(stringArray[0].trim());
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("PamLogin: PAM auth failed: " + exception.getMessage()));
            n = 2;
        }
        return n;
    }

    private void setAuthValues(String string, PasswordCredential passwordCredential, String string2) {
        this.up = new UserRolePrincipal(string, null);
        this.up.setHostName(string2);
        this.pc = new UserRoleCredential(passwordCredential.getUserPassword(), null);
        this.pc.setHostName(string2);
    }
}

