/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import java.util.Random;

public class PasswordCredential {
    public static final int MAX_PASSWORD_SIZE = 128;
    public static final byte[] NULL_PASSWORD = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] junk;
    private byte[] userpswd;
    private String hostname;

    public PasswordCredential() {
        this.setup();
        this.userpswd = new byte[128];
        this.zap(this.userpswd);
        this.hostname = null;
    }

    public PasswordCredential(String string) {
        this.setup();
        this.userpswd = new byte[128];
        if (string != null && string.trim().length() > 0) {
            this.encode(this.userpswd, string);
        } else {
            this.zap(this.userpswd);
        }
        this.hostname = null;
    }

    public String getUserPassword() {
        String string = this.userpswd[0] == 0 && this.userpswd[1] == 0 ? "" : this.decode(this.userpswd);
        return string;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setUserPassword(String string) {
        if (string != null && string.trim().length() > 0) {
            this.encode(this.userpswd, string);
        } else {
            this.zap(this.userpswd);
        }
    }

    public void clearUserPassword() {
        this.zap(this.userpswd);
        this.hostname = null;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    protected void encode(byte[] byArray, String string) {
        if (string != null) {
            int n;
            byte[] byArray2 = new byte[128];
            System.arraycopy(this.junk, 0, byArray2, 0, 128);
            byte[] byArray3 = string.getBytes();
            int n2 = byArray3.length;
            if (n2 > 128) {
                n2 = 128;
            }
            for (n = 0; n < n2; ++n) {
                int n3 = n;
                byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[n]);
            }
            if (n < 128) {
                int n4 = n;
                byArray2[n4] = (byte)(byArray2[n4] ^ 0);
            }
            System.arraycopy(byArray2, 0, byArray, 0, 128);
        } else {
            this.zap(byArray);
        }
    }

    protected String decode(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[128];
        System.arraycopy(this.junk, 0, byArray2, 0, 128);
        int n = 128;
        boolean bl = true;
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[i]);
            if (!bl || byArray2[i] != 0) continue;
            bl = false;
            n2 = i;
        }
        if (n2 > 0) {
            string = new String(byArray2, 0, n2);
        }
        return string;
    }

    protected void zap(byte[] byArray) {
        System.arraycopy(NULL_PASSWORD, 0, byArray, 0, 128);
        byArray[0] = this.junk[0];
    }

    private void setup() {
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[128];
        this.junk = new byte[128];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        for (int i = 0; i < 128; ++i) {
            l3 = l & l2;
            this.junk[i] = l3 > 0L ? byArray[i] : byArray2[i];
            l2 <<= 1;
        }
    }
}

