/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.ExecProcess;
import com.sun.management.services.authentication.LoginConstants;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.RbacRoleCallback;
import com.sun.management.services.authentication.UserPrincipal;
import com.sun.management.services.authentication.UserRoleCredential;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RbacRoleLoginModule
implements LoginModule {
    private Subject subject;
    private Map sharedState;
    private boolean debug = false;
    private boolean force_role_check = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private CallbackHandler ccbh;
    private UserRolePrincipal up = null;
    private UserRoleCredential pc = null;
    private boolean authenticated = false;
    String host = null;
    String user = null;
    String role = null;
    PasswordCredential roleCredential = null;
    private String commandPath = null;
    private String className = null;
    private static final String DEFAULT_CLASS_NAME = "/jsp/login/RoleLogin.jsp";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.ccbh = callbackHandler;
        this.sharedState = map;
        this.commandPath = null;
        this.className = null;
        this.force_role_check = false;
        if (map2 != null) {
            this.className = (String)map2.get("presentation_class");
            this.commandPath = (String)map2.get("commandPath");
            String string = (String)map2.get("force_role_check");
            if (string != null && string.equals("true")) {
                this.force_role_check = true;
            }
        }
        if (this.commandPath == null) {
            this.commandPath = LoginConstants.PAMVERIFIER_DEFAULT_PATH;
        }
        if (this.className == null) {
            this.className = DEFAULT_CLASS_NAME;
        }
        this.authenticated = false;
        this.succeeded = false;
        this.commitSucceeded = false;
    }

    public boolean login() throws LoginException {
        Object object;
        String string = null;
        this.user = null;
        try {
            this.user = (String)this.sharedState.get("javax.security.auth.login.name");
            string = (String)this.sharedState.get("pam.login.success");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.equals("true")) {
            this.authenticated = true;
        }
        if (!this.authenticated || this.user == null) {
            return false;
        }
        String[] stringArray = this.getRoleList(this.user);
        if (!(this.force_role_check || stringArray != null && stringArray.length != 0)) {
            return false;
        }
        int n = -1;
        Callback[] callbackArray = new Callback[1];
        try {
            object = new RbacRoleCallback();
            callbackArray[0] = object;
            object.setPresentationClassName(this.className);
            object.setUser(this.user);
            ((RbacRoleCallback)((Object)object)).setRolelist(stringArray);
            this.ccbh.handle(callbackArray);
            this.role = ((RbacRoleCallback)((Object)object)).getRole();
            if (this.role == null || this.role.equals("**NOROLE**")) {
                return false;
            }
            if (stringArray == null || stringArray.length == 0) {
                Debug.trace1((String)"RbacRoleLogin: bad role assumption");
                throw new Exception("bad role assumption");
            }
            this.host = object.getHost();
            this.role = ((RbacRoleCallback)((Object)object)).getRole();
            this.roleCredential = ((RbacRoleCallback)((Object)object)).getRoleCredential();
        }
        catch (Exception exception) {
            Debug.trace1((String)("RbacRoleLogin: login failed: " + exception.getMessage()));
            throw new LoginException("RbacRoleLogin: login failure");
        }
        try {
            object = new Vector();
            String string2 = this.commandPath + "/pamverifier";
            String[] stringArray2 = new String[]{string2, "authrole", this.role, this.user, this.roleCredential.getUserPassword()};
            ExecProcess execProcess = new ExecProcess(stringArray2);
            try {
                object = execProcess.exec();
            }
            catch (Exception exception) {
                Debug.trace1((String)("RbacRoleLogin: login failed: " + exception.getMessage()));
                throw new LoginException("RbacRoleLogin: login failure");
            }
            if (object != null) {
                String[] stringArray3 = (String[])((Vector)object).elementAt(0);
                n = Integer.parseInt(stringArray3[0].trim());
            }
            if (n == 0) {
                this.succeeded = true;
                this.sharedState.put("rbac.role.name", this.role);
                Debug.trace1((String)("RbacRoleLogin: role assumed: " + this.role));
                return true;
            }
            Debug.trace1((String)("RbacRoleLogin: invalid role: " + this.role));
            throw new Exception("invalid role or credential");
        }
        catch (Exception exception) {
            Debug.trace1((String)("RbacRoleLogin: role failed: " + exception.getMessage()));
            throw new LoginException("RbacRoleLogin: role failed");
        }
    }

    public boolean commit() throws LoginException {
        Object object;
        int n;
        if (!this.succeeded) {
            return true;
        }
        if (this.subject == null) {
            Debug.trace1((String)"RbacRoleLogin: no subject in commit");
            throw new FailedLoginException("RbacRoleLogin: no subject");
        }
        Object[] objectArray = this.subject.getPrincipals().toArray();
        Object[] objectArray2 = this.subject.getPrivateCredentials().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            try {
                object = (UserRolePrincipal)objectArray[n];
                if (!this.host.equals(((UserPrincipal)object).getHostName())) continue;
                ((UserRolePrincipal)object).setRoleName(this.role);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < objectArray2.length; ++n) {
            try {
                object = (UserRoleCredential)objectArray2[n];
                if (!this.host.equals(((PasswordCredential)object).getHostName())) continue;
                ((UserRoleCredential)object).setRolePassword(this.roleCredential.getUserPassword());
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.commitSucceeded) {
            this.logout();
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.role = null;
        this.up = null;
        this.pc = null;
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private String[] getRoleList(String string) {
        String[] stringArray = null;
        Debug.trace3((String)"RbacRoleLogin: getting roles");
        Vector vector = new Vector();
        String string2 = this.commandPath + "/pamverifier";
        String[] stringArray2 = new String[]{string2, "getUserRoles", string};
        ExecProcess execProcess = new ExecProcess(stringArray2);
        try {
            vector = execProcess.exec();
        }
        catch (Exception exception) {
            Debug.trace1((String)("PamLogin: exception getting roles: " + exception.getMessage()));
            vector = null;
        }
        if (vector != null && vector.size() != 0) {
            stringArray = (String[])vector.elementAt(0);
            if (stringArray != null && stringArray.length != 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                }
            }
            Debug.trace3((String)("RbacRoleLogin: retrieved " + stringArray.length + " roles"));
        }
        return stringArray;
    }
}

