/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authorization;

import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.authorization.AuthorizationUtility;
import com.sun.management.services.authorization.SolarisRbacPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;

public final class SolarisRbacAuthorizationService
implements AuthorizationService {
    private static final String PERM_ATTRIBUTE = "permission";
    private static final String PERM_CLASS_NAME = "com.sun.management.services.authorization.SolarisRbacPermission";
    private static final String PRINCIPAL_CLASS_NAME = "com.sun.management.services.authentication.UserRolePrincipal";

    public Permission createPermission(String string, String[][] stringArray) throws AuthorizationException {
        if (string == null || !string.equals(PERM_CLASS_NAME)) {
            throw new AuthorizationException("authz_err_15", string == null ? "null" : string);
        }
        String string2 = null;
        if (stringArray != null && stringArray.length > 0 && stringArray[0][0].equals(PERM_ATTRIBUTE)) {
            string2 = stringArray[0][1];
        }
        if (string2 == null || string2.length() == 0) {
            throw new AuthorizationException("authz_err_16");
        }
        SolarisRbacPermission solarisRbacPermission = new SolarisRbacPermission(string2);
        return solarisRbacPermission;
    }

    public boolean checkPermission(Permission permission) throws AuthorizationException {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        return this.checkPermission(subject, permission);
    }

    public boolean checkPermission(Principal principal, Permission permission) throws AuthorizationException {
        UserRolePrincipal userRolePrincipal = this.validatePrincipal(principal);
        SolarisRbacPermission solarisRbacPermission = this.validatePermission(permission);
        return this.isPermissionGranted(userRolePrincipal, solarisRbacPermission);
    }

    public boolean checkPermission(Subject subject, Permission permission) throws AuthorizationException {
        if (subject == null) {
            throw new AuthorizationException("authz_err_11");
        }
        SolarisRbacPermission solarisRbacPermission = this.validatePermission(permission);
        UserRolePrincipal userRolePrincipal = (UserRolePrincipal)AuthorizationServiceFactory.getPrincipal((Subject)subject, (String)PRINCIPAL_CLASS_NAME);
        if (userRolePrincipal == null) {
            return false;
        }
        return this.isPermissionGranted(userRolePrincipal, solarisRbacPermission);
    }

    private UserRolePrincipal validatePrincipal(Principal principal) throws AuthorizationException {
        UserRolePrincipal userRolePrincipal = null;
        if (principal != null) {
            try {
                userRolePrincipal = (UserRolePrincipal)principal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (userRolePrincipal == null) {
            throw new AuthorizationException("authz_err_13");
        }
        return userRolePrincipal;
    }

    private SolarisRbacPermission validatePermission(Permission permission) throws AuthorizationException {
        SolarisRbacPermission solarisRbacPermission = null;
        if (permission == null) {
            throw new AuthorizationException("authz_err_12");
        }
        try {
            solarisRbacPermission = (SolarisRbacPermission)permission;
        }
        catch (Exception exception) {
            throw new AuthorizationException("authz_err_14");
        }
        return solarisRbacPermission;
    }

    private boolean isPermissionGranted(UserRolePrincipal userRolePrincipal, SolarisRbacPermission solarisRbacPermission) {
        String string = userRolePrincipal.getRoleName();
        if (string == null) {
            string = userRolePrincipal.getUserName();
        }
        return AuthorizationUtility.checkAuthName(string, solarisRbacPermission.getName());
    }
}

