/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.logging;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogRecord;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleSyslogHandler
extends Handler {
    private boolean open = true;
    protected static final int SYSLOG_DEBUG = 7;
    protected static final int SYSLOG_INFO = 6;
    protected static final int SYSLOG_NOTICE = 5;
    protected static final int SYSLOG_WARNING = 4;
    protected static final int SYSLOG_ERR = 3;
    protected static final int SYSLOG_CRIT = 2;
    protected static final int SYSLOG_ALERT = 1;
    protected static final int SYSLOG_EMERG = 0;
    private static final String PREFIX = "Log(syslog): ";
    private static final String JNI_LIBRARY_NAME = "webconsole_services";
    private static String LOG_SERVICE_BUNDLE = "com.sun.management.services.logging.resources.Resources";
    private static boolean library_loaded = false;

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (!library_loaded) {
            return;
        }
        int n = 0;
        int n2 = logRecord.getLevel().intValue();
        if (n2 == Level.SEVERE.intValue()) {
            n = 2;
        } else if (n2 == Level.WARNING.intValue()) {
            n = 4;
        } else if (n2 == Level.INFO.intValue()) {
            n = 6;
        } else if (n2 == Level.CONFIG.intValue()) {
            n = 7;
        }
        String string2 = null;
        String string3 = null;
        ResourceBundle resourceBundle = null;
        resourceBundle = logRecord.getResourceBundle();
        Object[] objectArray = logRecord.getParameters();
        string2 = string = logRecord.getMessage();
        if (resourceBundle != null) {
            try {
                string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
            }
            catch (Exception exception) {
                Debug.trace1((String)("Log(syslog): error localizing message: " + exception.getMessage()));
            }
        } else {
            Debug.trace1((String)"Log(syslog): log resource bundle is missing");
        }
        string3 = "XXX";
        ResourceBundle resourceBundle2 = null;
        try {
            resourceBundle2 = ResourceBundle.getBundle(LOG_SERVICE_BUNDLE, Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            Debug.trace3((String)("Log(syslog): cannot load resource bundle: " + LOG_SERVICE_BUNDLE));
        }
        if (resourceBundle2 != null) {
            try {
                string3 = resourceBundle2.getString("MSG_HEADER");
                if (string3.equals("MSG_HEADER")) {
                    string3 = "XXX";
                }
            }
            catch (Exception exception) {
                string3 = "XXX";
            }
        }
        String string4 = string2;
        try {
            ConsoleLogRecord consoleLogRecord = (ConsoleLogRecord)logRecord;
            String string5 = consoleLogRecord.getUserName();
            if (string5 != null) {
                string4 = "[" + string5 + "] " + string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Debug.trace1((String)(PREFIX + n + " : " + string4));
        CCServiceLibrary.writeSyslog((String)string4, (String)string3, (int)n);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        this.open = false;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (!this.open) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    static {
        try {
            System.loadLibrary(JNI_LIBRARY_NAME);
            library_loaded = true;
        }
        catch (Throwable throwable) {
            Debug.trace1((String)("Log(syslog): sysLog Service failed to init - " + throwable.getMessage()));
            Debug.trace3((String)"Log(syslog): sysLog Service failed to init", (Throwable)throwable);
        }
    }
}

