/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMConcatComponent
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) {
        try {
            SVM sVM = SVM.instance();
            System.out.println("Concat associations:");
            System.out.println();
            Vector vector = sVM.getDevices("Concat");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "Resides On");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn");
            }
            System.exit(0);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            String string = (String)device.getProperty("type");
            return this.concatCompAssocToCI(cIMObjectPath2, device, string, cIMClass, -1, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Concat");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMConcat", cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)device.getProperty("device key").toString()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMConcat"));
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice") && !string.equals("Stripe") && !string.equals("SoftPartition")) continue;
                    CIMInstance cIMInstance = this.concatCompAssocToCI(cIMObjectPath2, device2, string, cIMClass, j, false, false, null);
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMConcatComponent", cIMObjectPath.getNameSpace());
                    cIMObjectPath3.addKey("GroupComponent", new CIMValue(cIMInstance.getProperty("GroupComponent").getValue().getValue()));
                    cIMObjectPath3.addKey("PartComponent", new CIMValue(cIMInstance.getProperty("PartComponent").getValue().getValue()));
                    arrayList.add(cIMObjectPath3);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Concat");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice") && !string.equals("Stripe") && !string.equals("SoftPartition")) continue;
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMConcat", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMConcat"));
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)device.getProperty("device key").toString()));
                    arrayList.add(this.concatCompAssocToCI(cIMObjectPath2, device2, string, cIMClass, j, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMInstance);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        String string = null;
        string = device2 != null ? (String)device2.getProperty("name") : (String)Solaris_VMUtil.getOPValue(cIMObjectPath3, "DeviceID");
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add((String)device.getProperty("name"));
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMConcatComponent", cIMObjectPath.getNameSpace());
        cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
        return cIMObjectPath4;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMConcat");
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4;
                Device device2 = (Device)vector2.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                if (bl3) {
                    if (!this.isValidCompType(string6)) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    if (string6.equals("Stripe")) {
                        cIMObjectPath3.addKey("Name", new CIMValue(device2.getProperty("name")));
                    } else if (string6.equals("SoftPartition")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    } else {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue(device2.getProperty("name")));
                    }
                } else {
                    if (!string6.equalsIgnoreCase("Concat")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    cIMObjectPath4 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath5, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((cIMObjectPath4 = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
                }
                vector.addElement(cIMObjectPath4);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMConcat");
        try {
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                if (bl) {
                    if (!string6.equals("Stripe") && !string6.equals("Slice")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    if (string6.equals("Slice")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue(device2.getProperty("name")));
                    } else if (string6.equals("SoftPartition")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    } else {
                        cIMObjectPath3.addKey("Name", new CIMValue(device2.getProperty("name")));
                    }
                } else {
                    if (!string6.equalsIgnoreCase("Concat")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, cIMObjectPath2.getNameSpace());
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    cIMObjectPath3.setNameSpace(cIMObjectPath2.getNameSpace());
                }
                if (string != null) {
                    CIMClass cIMClass;
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath5, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMConcat");
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMConcatComponent", string3);
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4 = null;
                CIMInstance cIMInstance = null;
                Device device2 = (Device)vector2.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                if (bl3) {
                    if (!this.isValidCompType(string4)) continue;
                    cIMInstance = this.concatCompAssocToCI(cIMObjectPath2, device2, string4, cIMClass, i, bl, bl2, stringArray);
                } else {
                    if (!string4.equalsIgnoreCase("Concat")) continue;
                    cIMObjectPath4 = new CIMObjectPath(string5, string3);
                    cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)string5));
                    cIMObjectPath4.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    cIMInstance = this.concatCompAssocToCI(cIMObjectPath4, device, (String)device2.getProperty("type"), cIMClass, i, bl, bl2, stringArray);
                }
                vector.addElement(cIMInstance);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMConcat");
        try {
            if (this.slvm == null) {
                throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                if (bl) {
                    if (!this.isValidCompType(string4)) continue;
                    cIMObjectPath3 = new CIMObjectPath(string5, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string5));
                    if (string4.equals("Slice")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                    } else if (string4.equals("SoftPartition")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    } else {
                        cIMObjectPath3.addKey("Name", new CIMValue((Object)((String)device2.getProperty("name"))));
                    }
                } else {
                    if (!string4.equalsIgnoreCase("Concat")) continue;
                    string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                    cIMObjectPath3 = new CIMObjectPath(string5, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string5));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMConcatComponent", string3);
                if (bl) {
                    cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
                    cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
                } else {
                    cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath2));
                    cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                }
                arrayList.add(cIMObjectPath4);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private boolean isValidCompType(String string) {
        return string.equals("Slice") || string.equals("Stripe") || string.equals("SoftPartition");
    }

    private CIMInstance concatCompAssocToCI(CIMObjectPath cIMObjectPath, Device device, String string, CIMClass cIMClass, int n, boolean bl, boolean bl2, String[] stringArray) throws CIMProviderException {
        try {
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = Solaris_VMUtil.deviceTypeToClass(string);
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2, cIMObjectPath.getNameSpace());
            String string3 = null;
            if (string.equals("Stripe")) {
                string3 = (String)device.getProperty("name");
                cIMObjectPath2.addKey("Name", new CIMValue((Object)string3));
            } else if (string.equals("SoftPartition")) {
                string3 = device.getProperty("device key").toString();
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string3));
            } else {
                string3 = (String)device.getProperty("name");
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string3));
            }
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)string2));
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            if (n != -1) {
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(n)));
            } else {
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(Solaris_VMUtil.getCompOrder(this.slvm, cIMObjectPath, string3))));
            }
            return cIMInstance.filterProperties(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception);
        }
    }
}

