/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMDiskSet
implements InstanceProvider,
Authorizable,
PropertyProvider,
MethodProvider,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.disksetToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Diskset");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    String string = (String)device.getProperty("name");
                    cIMObjectPath2.addKey("CollectionID", new CIMValue((Object)string));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Diskset");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    arrayList.add(this.disksetToCI(device, cIMClass, bl, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        String string = System.getProperty("os.arch");
        if (string == null || !string.equalsIgnoreCase("sparc")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        String string2 = (String)Solaris_VMUtil.getValue(cIMInstance, "CollectionID");
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"CollectionID");
        }
        String string3 = (String)Solaris_VMUtil.getValue(cIMInstance, "HostName");
        if (string3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"HostName");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string2);
        arrayList.add("-a");
        arrayList.add("-h");
        arrayList.add(string3);
        Solaris_VMUtil.run(arrayList, string3);
        return cIMObjectPath;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        AbstractList abstractList;
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null || string.length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"CollectionID");
        }
        String string2 = null;
        try {
            abstractList = this.slvm.getAntecedents(device, "HostInDiskGroup");
            if (abstractList != null && ((Vector)abstractList).size() > 0) {
                Device device2 = (Device)((Vector)abstractList).get(0);
                string2 = (String)device2.getProperty("name");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"HostName");
        }
        abstractList = new ArrayList();
        ((ArrayList)abstractList).add("/usr/sbin/metaset");
        ((ArrayList)abstractList).add("-s");
        ((ArrayList)abstractList).add(string);
        ((ArrayList)abstractList).add("-d");
        ((ArrayList)abstractList).add("-h");
        ((ArrayList)abstractList).add(string2);
        Solaris_VMUtil.run((ArrayList)abstractList, string2);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.disksetToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string2 = (String)device.getProperty("name");
        if (string2 == null || string2.length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"CollectionID");
        }
        if (string.equalsIgnoreCase("addHost")) {
            return this.addHost(vector, string2);
        }
        if (string.equalsIgnoreCase("deleteHost")) {
            return this.deleteHost(vector, string2);
        }
        if (string.equalsIgnoreCase("addDrive")) {
            return this.addDrive(vector, string2);
        }
        if (string.equalsIgnoreCase("deleteDrive")) {
            return this.deleteDrive(vector, string2);
        }
        if (string.equalsIgnoreCase("setOwner")) {
            return this.setOwner(vector, string2);
        }
        if (string.equalsIgnoreCase("releaseOwner")) {
            return this.releaseOwner(vector, string2);
        }
        if (string.equalsIgnoreCase("distribute")) {
            return this.distribute(vector, string2);
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    private CIMInstance disksetToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        String string = (String)device.getProperty("name");
        cIMInstance.setProperty("CollectionID", new CIMValue((Object)string));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private CIMValue addHost(Vector vector, String string) throws CIMException {
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-a");
        arrayList.add("-h");
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue deleteHost(Vector vector, String string) throws CIMException {
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-d");
        arrayList.add("-h");
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue addDrive(Vector vector, String string) throws CIMException {
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.get(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-a");
        if (unsignedInt32.intValue() != 0) {
            arrayList.add("-l");
            arrayList.add(unsignedInt32.toString());
        }
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue deleteDrive(Vector vector, String string) throws CIMException {
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-d");
        arrayList.add("-f");
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue setOwner(Vector vector, String string) throws CIMException {
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        Boolean bl = (Boolean)vector.get(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-t");
        if (bl.booleanValue()) {
            arrayList.add("-f");
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue releaseOwner(Vector vector, String string) throws CIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-r");
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue distribute(Vector vector, String string) throws CIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaset");
        arrayList.add("-s");
        arrayList.add(string);
        arrayList.add("-b");
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }
}

