/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;

public class Solaris_VMHotSparePool
implements InstanceProvider,
Authorizable,
PropertyProvider,
MethodProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) throws RemoteException {
        SVM sVM = SVM.instance();
        try {
            Vector vector = sVM.getDevices("Hsp");
            System.out.println("HSP:");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                System.out.println(device);
                Solaris_VMUtil.printDependents(sVM, device, "ExtentInDiskGroup", "ExtentInDiskGroup:");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "ExtentRedundancyComponent:");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.hspToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = this.slvm.getDevices("Hsp");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMHotSparePool"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)((String)device.getProperty("name"))));
                arrayList.add(cIMObjectPath2);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            Vector vector = this.slvm.getDevices("Hsp");
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                arrayList.add(this.hspToCI(device, cIMClass, bl, bl2, bl3, stringArray));
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        String string;
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        String string2 = null;
        String string3 = (String)Solaris_VMUtil.getValue(cIMInstance, "Name");
        if (string3 == null) {
            string3 = Solaris_VMUtil.getMDName(this.slvm, true);
        }
        if ((string = (String)Solaris_VMUtil.getValue(cIMInstance, "HotSpareComponent")) != null) {
            string2 = Solaris_VMUtil.getSliceDiskSet(this.slvm, string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metainit");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add(string3);
        if (string != null) {
            arrayList.add(string);
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string2);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        String string4 = null;
        string4 = string2 != null ? string2 + "/" + string3 : string3;
        Device device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string4, "name", "Hsp");
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMHotSparePool"));
        cIMObjectPath2.addKey("Name", new CIMValue((Object)((String)device.getProperty("name"))));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (string.equalsIgnoreCase("addHotSpare")) {
            return this.addHotSpare(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("deleteHotSpare")) {
            return this.deleteHotSpare(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("replace")) {
            return this.replace(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("Failover")) {
            return new CIMValue((Object)new UnsignedInt32(1L));
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.hspToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue addHotSpare(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metahs");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-a");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue deleteHotSpare(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metahs");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-d");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue replace(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        String string3 = (String)vector.get(0);
        String string4 = (String)vector.get(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metahs");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-r");
        arrayList.add(string);
        arrayList.add(string3);
        arrayList.add(string4);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMInstance hspToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMHotSparePool"));
        String string = (String)device.getProperty("name");
        cIMInstance.setProperty("Name", new CIMValue((Object)string));
        cIMInstance.setProperty("RedundancyStatus", new CIMValue((Object)new UnsignedInt16(1)));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }
}

