/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMMirror
implements InstanceProvider,
Authorizable,
PropertyProvider,
MethodProvider,
EventProvider {
    private static final int MD_UN_RESYNC_ACTIVE = 65536;
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;
    private static String objName = "Solaris_VMMirror";

    public static void main(String[] stringArray) throws RemoteException {
        SVM sVM = SVM.instance();
        try {
            Vector vector = sVM.getDevices("Mirror");
            System.out.println("Mirrors:");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                System.out.println(device);
                Solaris_VMUtil.printDependents(sVM, device, "ExtentInDiskGroup", "ExtentInDiskGroup:");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "ResidesOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "ExtentRedundancyComponent:");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.mirrorToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Mirror");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)objName));
                    Long l = (Long)device.getProperty("device key");
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)l.toString()));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Mirror");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    arrayList.add(this.mirrorToCI(device, cIMClass, bl, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        int n;
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "SubMirror");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"SubMirror");
        }
        Device device = this.getSubMirror(string);
        if (device == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"SubMirror");
        }
        String string2 = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string2 == null) {
            string2 = Solaris_VMUtil.getMDName(this.slvm, false);
        }
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)Solaris_VMUtil.getValue(cIMInstance, "Pass");
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "ReadOption");
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "WriteOption");
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metainit");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add(string2);
        arrayList.add("-m");
        arrayList.add(string);
        if (unsignedInt16 != null) {
            n = unsignedInt16.intValue();
            if (n == 2) {
                arrayList.add("-g");
            } else if (n == 3) {
                arrayList.add("-r");
            }
        }
        if (unsignedInt162 != null && (n = unsignedInt162.intValue()) == 2) {
            arrayList.add("-S");
        }
        if (unsignedInt32 != null) {
            arrayList.add(unsignedInt32.toString());
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string3);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        String string4 = null;
        string4 = string3 != null ? string3 + "/" + string2 : string2;
        Device device2 = Solaris_VMUtil.getDeviceByAttr(this.slvm, string4, "name", "Mirror");
        Long l = (Long)device2.getProperty("device key");
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)objName));
        cIMObjectPath2.addKey("Name", new CIMValue((Object)l.toString()));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        Solaris_VMUtil.rename(this.slvm, device, string);
        boolean bl = false;
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)Solaris_VMUtil.getValue(cIMInstance, "Pass");
        boolean bl2 = false;
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "ReadOption");
        boolean bl3 = false;
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "WriteOption");
        if (Solaris_VMUtil.diff(device, "passnumber", new Integer(unsignedInt32.intValue()))) {
            bl = true;
        }
        if (Solaris_VMUtil.diff(device, "readoption", new Integer(unsignedInt16.intValue() - 1))) {
            bl2 = true;
        }
        if (Solaris_VMUtil.diff(device, "writeoption", new Integer(unsignedInt162.intValue() - 1))) {
            bl3 = true;
        }
        if (bl || bl2 || bl3) {
            int n;
            String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/usr/sbin/metaparam");
            if (string2 != null) {
                arrayList.add("-s");
                arrayList.add(string2);
            }
            if (bl) {
                arrayList.add("-p");
                arrayList.add(unsignedInt32.toString());
            }
            if (bl2) {
                n = unsignedInt16.intValue();
                arrayList.add("-r");
                if (n == 1) {
                    arrayList.add("roundrobin");
                } else if (n == 2) {
                    arrayList.add("geometric");
                } else if (n == 3) {
                    arrayList.add("first");
                } else {
                    arrayList.add(String.valueOf(n));
                }
            }
            if (bl3) {
                n = unsignedInt162.intValue();
                arrayList.add("-w");
                if (n == 1) {
                    arrayList.add("parallel");
                } else if (n == 2) {
                    arrayList.add("serial");
                } else {
                    arrayList.add(String.valueOf(n));
                }
            }
            arrayList.add(string);
            Solaris_VMUtil.run(arrayList, this.hostName);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (string.equalsIgnoreCase("attach")) {
            return this.attach(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("detach")) {
            return this.detach(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("offline")) {
            return this.offline(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("online")) {
            return this.online(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("replace")) {
            return this.replace(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("resync")) {
            return this.resync(vector, cIMObjectPath);
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.mirrorToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (!(string2.equalsIgnoreCase("MetaDevice") || string2.equalsIgnoreCase("Pass") || string2.equalsIgnoreCase("ReadOption") || string2.equalsIgnoreCase("WriteOption"))) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string3 = (String)device.getProperty("name");
        if (string2.equalsIgnoreCase("MetaDevice")) {
            String string4 = (String)cIMValue.getValue();
            Solaris_VMUtil.rename(this.slvm, device, string4);
        } else if (string2.equalsIgnoreCase("Pass")) {
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
            String string5 = Solaris_VMUtil.getDiskSet(this.slvm, device);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/usr/sbin/metaparam");
            if (string5 != null) {
                arrayList.add("-s");
                arrayList.add(string5);
            }
            arrayList.add("-p");
            arrayList.add(unsignedInt32.toString());
            arrayList.add(string3);
            Solaris_VMUtil.run(arrayList, this.hostName);
        } else if (string2.equalsIgnoreCase("ReadOption")) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
            int n = unsignedInt16.intValue();
            String string6 = Solaris_VMUtil.getDiskSet(this.slvm, device);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/usr/sbin/metaparam");
            if (string6 != null) {
                arrayList.add("-s");
                arrayList.add(string6);
            }
            arrayList.add("-r");
            if (n == 1) {
                arrayList.add("roundrobin");
            } else if (n == 2) {
                arrayList.add("geometric");
            } else if (n == 3) {
                arrayList.add("first");
            } else {
                arrayList.add(String.valueOf(n));
            }
            arrayList.add(string3);
            Solaris_VMUtil.run(arrayList, this.hostName);
        } else if (string2.equalsIgnoreCase("WriteOption")) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
            int n = unsignedInt16.intValue();
            String string7 = Solaris_VMUtil.getDiskSet(this.slvm, device);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/usr/sbin/metaparam");
            if (string7 != null) {
                arrayList.add("-s");
                arrayList.add(string7);
            }
            arrayList.add("-w");
            if (n == 1) {
                arrayList.add("parallel");
            } else if (n == 2) {
                arrayList.add("serial");
            } else {
                arrayList.add(String.valueOf(n));
            }
            arrayList.add(string3);
            Solaris_VMUtil.run(arrayList, this.hostName);
        }
    }

    private CIMValue attach(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue detach(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metadetach");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-f");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue offline(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaoffline");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-f");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue online(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaonline");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue replace(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        String string4 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metareplace");
        if (string4 != null) {
            arrayList.add("-s");
            arrayList.add(string4);
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue resync(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        Solaris_VMUtil.resync(vector, device, this.slvm, this.hostName);
        return null;
    }

    private CIMInstance mirrorToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Device device2 = null;
        if (this.mustFlush(device)) {
            try {
                device2 = this.slvm.updateState(device);
            }
            catch (RemoteException remoteException) {}
        } else {
            device2 = device;
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (device2 == null) {
            return cIMInstance;
        }
        String string = (String)device2.getProperty("name");
        cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string));
        String string2 = "";
        if (Solaris_VMUtil.isATransLog(device2)) {
            string2 = Solaris_VMUtil.getTransLogState(device2);
        }
        cIMInstance.setProperty("Status", new CIMValue((Object)string2));
        cIMInstance.setProperty("MountPoint", new CIMValue((Object)((String)device2.getProperty("mountpoint"))));
        Long l = (Long)device2.getProperty("size");
        if (l != null) {
            cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt64(l.toString())));
        }
        if ((n4 = (Integer)device2.getProperty("passnumber")) != null) {
            cIMInstance.setProperty("Pass", new CIMValue((Object)new UnsignedInt32((long)n4.intValue())));
        }
        if ((n3 = (Integer)device2.getProperty("readoption")) != null) {
            cIMInstance.setProperty("ReadOption", new CIMValue((Object)new UnsignedInt16(n3 + 1)));
        }
        if ((n2 = (Integer)device2.getProperty("writeoption")) != null) {
            cIMInstance.setProperty("WriteOption", new CIMValue((Object)new UnsignedInt16(n2 + 1)));
        }
        if ((n = (Integer)device2.getProperty("percent done")) != null) {
            cIMInstance.setProperty("PercentDone", new CIMValue((Object)new UnsignedInt16(n.intValue())));
        }
        cIMInstance.setProperty("TypeOfAlgorithm", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("StorageRedundancy", new CIMValue((Object)new UnsignedInt16(0)));
        cIMInstance.setProperty("IsStriped", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("IsConcatenated", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)objName));
        Long l2 = (Long)device2.getProperty("device key");
        cIMInstance.setProperty("Name", new CIMValue((Object)l2.toString()));
        cIMInstance.setProperty("RedundancyStatus", this.getRedundancyStatus(device2));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private boolean mustFlush(Device device) {
        int n = 0;
        Integer n2 = (Integer)device.getProperty("state");
        if (n2 != null) {
            n = n2;
        }
        return (n & 0x10000) > 0;
    }

    private Device getSubMirror(String string) {
        String string2;
        Device device;
        Vector vector = null;
        try {
            vector = this.slvm.getDevices("Concat");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                device = (Device)vector.get(i);
                string2 = (String)device.getProperty("name");
                if (string2 == null || !string2.equals(string)) continue;
                return device;
            }
        }
        try {
            vector = this.slvm.getDevices("Stripe");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                device = (Device)vector.get(i);
                string2 = (String)device.getProperty("name");
                if (string2 == null || !string2.equals(string)) continue;
                return device;
            }
        }
        return null;
    }

    private CIMValue getRedundancyStatus(Device device) {
        int n = 0;
        Vector vector = null;
        try {
            vector = this.slvm.getAntecedents(device, "BasedOn");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        boolean bl = false;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                String string = (String)device2.getProperty("type");
                if (!string.equals("Concat") && !string.equals("Stripe")) continue;
                String string2 = Solaris_VMUtil.getSubmirrorState(this.slvm, device2, device);
                if (!string2.equals("needs maintenance")) {
                    ++n;
                }
                if (!this.submirrorIsSpared(device2)) continue;
                bl = true;
            }
        }
        if (n < 2) {
            return new CIMValue((Object)new UnsignedInt16(4));
        }
        if (bl) {
            return new CIMValue((Object)new UnsignedInt16(3));
        }
        return new CIMValue((Object)new UnsignedInt16(2));
    }

    private boolean submirrorIsSpared(Device device) {
        try {
            Vector vector = this.slvm.getAntecedents(device, "BasedOn");
            if (vector == null) {
                return false;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2;
                Device device2 = (Device)vector.get(i);
                String string = (String)device2.getProperty("type");
                if (!string.equals("Slice") || (vector2 = this.slvm.getDependents(device2, "ExtentRedundancyComponent")) == null || vector2.size() <= 0) continue;
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }
}

