/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMMirrorSubmirrors
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;
    private static final int SMS_OFFLINE = 32;

    public static void main(String[] stringArray) {
        try {
            SVM sVM = SVM.instance();
            System.out.println("Mirror associations:");
            System.out.println();
            Vector vector = sVM.getDevices("Mirror");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "Resides On");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn");
            }
            System.exit(0);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            return this.submirrorCompAssocToCI(cIMObjectPath2, device, cIMClass, -1, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Mirror");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMMirror", cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)device.getProperty("device key").toString()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMMirror"));
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("type");
                    if (!string.equalsIgnoreCase("Concat") && !string.equalsIgnoreCase("Stripe")) continue;
                    CIMInstance cIMInstance = this.submirrorCompAssocToCI(cIMObjectPath2, device2, cIMClass, j, false, false, null);
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMMirrorSubmirrors", cIMObjectPath.getNameSpace());
                    cIMObjectPath3.addKey("GroupComponent", new CIMValue(cIMInstance.getProperty("GroupComponent").getValue().getValue()));
                    cIMObjectPath3.addKey("PartComponent", new CIMValue(cIMInstance.getProperty("PartComponent").getValue().getValue()));
                    arrayList.add(cIMObjectPath3);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Mirror");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("type");
                    if (!string.equalsIgnoreCase("Concat") && !string.equalsIgnoreCase("Stripe")) continue;
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMMirror", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMMirror"));
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    arrayList.add(this.submirrorCompAssocToCI(cIMObjectPath2, device2, cIMClass, j, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        if (device2 == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
        }
        String string = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        arrayList.add((String)device.getProperty("name"));
        arrayList.add((String)device2.getProperty("name"));
        Solaris_VMUtil.run(arrayList, this.hostName);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMMirrorSubmirrors", cIMObjectPath.getNameSpace());
        cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
        return cIMObjectPath4;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        if (device == null || device2 == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        String string = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metadetach");
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        arrayList.add((String)device.getProperty("name"));
        arrayList.add((String)device2.getProperty("name"));
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMProperty cIMProperty = cIMInstance.getProperty("Online");
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMInstance);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        this.setPropertyValue(cIMObjectPath, "Solaris_VMMirrorSubmirrors", "Online", cIMValue);
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMMirror");
        try {
            Vector<Long> vector = new Vector<Long>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            if (bl3) {
                if (string2 != null && !string2.equalsIgnoreCase("GroupComponent")) {
                    return vector;
                }
                vector2 = this.slvm.getAntecedents(device, "BasedOn");
            } else {
                if (string2 != null && !string2.equalsIgnoreCase("PartComponent")) {
                    return vector;
                }
                vector2 = this.slvm.getDependents(device, "BasedOn");
            }
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                Long l;
                Device device2 = (Device)vector2.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                String string8 = null;
                if (bl3) {
                    if (!string6.equalsIgnoreCase("Stripe") && !string6.equalsIgnoreCase("Concat")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    l = (Long)device2.getProperty("device key");
                    string8 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)string8));
                } else {
                    if (!string6.equalsIgnoreCase("Mirror")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    l = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath4, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass((CIMObjectPath)l, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((l = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
                }
                vector.addElement(l);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMMirror");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            if (bl) {
                if (string2 != null && !string2.equalsIgnoreCase("GroupComponent")) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getAntecedents(device, "BasedOn");
            } else {
                if (string2 != null && !string2.equalsIgnoreCase("PartComponent")) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getDependents(device, "BasedOn");
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Long l;
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                String string8 = null;
                if (bl) {
                    if (!string6.equals("Stripe") && !string6.equals("Concat")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    l = (Long)device2.getProperty("device key");
                    string8 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)string8));
                } else {
                    if (!string6.equalsIgnoreCase("Mirror")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    l = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath4, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass((CIMObjectPath)l, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMMirror");
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            if (bl3) {
                if (string != null && !string.equalsIgnoreCase("GroupComponent")) {
                    return vector;
                }
                vector2 = this.slvm.getAntecedents(device, "BasedOn");
            } else {
                if (string != null && !string.equalsIgnoreCase("PartComponent")) {
                    return vector;
                }
                vector2 = this.slvm.getDependents(device, "BasedOn");
            }
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMMirrorSubmirrors", string3);
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4 = null;
                CIMInstance cIMInstance = null;
                Device device2 = (Device)vector2.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                if (bl3) {
                    if (!string4.equalsIgnoreCase("Stripe") && !string4.equalsIgnoreCase("Concat")) continue;
                    cIMInstance = this.submirrorCompAssocToCI(cIMObjectPath2, device2, cIMClass, i, bl, bl2, stringArray);
                } else {
                    if (!string4.equalsIgnoreCase("Mirror")) continue;
                    cIMObjectPath4 = new CIMObjectPath(string5, string3);
                    cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)string5));
                    cIMObjectPath4.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    cIMInstance = this.submirrorCompAssocToCI(cIMObjectPath4, device, cIMClass, i, bl, bl2, stringArray);
                }
                vector.addElement(cIMInstance);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMMirror");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            if (bl) {
                if (string != null && !string.equalsIgnoreCase("GroupComponent")) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getAntecedents(device, "BasedOn");
            } else {
                if (string != null && !string.equalsIgnoreCase("PartComponent")) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getDependents(device, "BasedOn");
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Long l;
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                String string6 = null;
                if (bl) {
                    if (!string4.equalsIgnoreCase("Stripe") && !string4.equalsIgnoreCase("Concat")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string5, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string5));
                    l = (Long)device2.getProperty("device key");
                    string6 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)l));
                } else {
                    if (!string4.equalsIgnoreCase("Mirror")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string5, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string5));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                l = new CIMObjectPath("Solaris_VMMirrorSubmirrors", string3);
                if (bl) {
                    l.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
                    l.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
                } else {
                    l.addKey("PartComponent", new CIMValue((Object)cIMObjectPath2));
                    l.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                }
                arrayList.add(l);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        String string3;
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (!string2.equalsIgnoreCase("Online")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        if (device2 == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
        }
        Boolean bl = (Boolean)cIMValue.getValue();
        String string4 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl.equals(Boolean.TRUE)) {
            arrayList.add("/usr/sbin/metaonline");
        } else {
            arrayList.add("/usr/sbin/metaoffline");
        }
        if (string4 != null) {
            arrayList.add("-s");
            arrayList.add(string4);
        }
        if (bl.equals(Boolean.FALSE) && (string3 = Solaris_VMUtil.getSubmirrorState(this.slvm, device2, device)).equalsIgnoreCase("needs maintenance")) {
            arrayList.add("-f");
        }
        arrayList.add((String)device.getProperty("name"));
        arrayList.add((String)device2.getProperty("name"));
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    private CIMInstance submirrorCompAssocToCI(CIMObjectPath cIMObjectPath, Device device, CIMClass cIMClass, int n, boolean bl, boolean bl2, String[] stringArray) throws CIMProviderException {
        String string = (String)device.getProperty("type");
        String string2 = Solaris_VMUtil.deviceTypeToClass(string);
        String string3 = cIMObjectPath.getNameSpace();
        try {
            String string4 = null;
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2, string3);
            Long l = (Long)device.getProperty("device key");
            string4 = l != null ? l.toString() : (String)device.getProperty("name");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)string2));
            cIMObjectPath2.addKey("Name", new CIMValue((Object)string4));
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            if (n != -1) {
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(n)));
            } else {
                String string5 = (String)device.getProperty("name");
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(Solaris_VMUtil.getCompOrder(this.slvm, cIMObjectPath, string5))));
            }
            int n2 = 0;
            Integer n3 = (Integer)device.getProperty("state");
            if (n3 != null) {
                n2 = n3;
            }
            if ((n2 & 0x20) > 0) {
                cIMInstance.setProperty("Online", new CIMValue((Object)Boolean.FALSE));
            } else {
                cIMInstance.setProperty("Online", new CIMValue((Object)Boolean.TRUE));
            }
            return cIMInstance.filterProperties(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception);
        }
    }
}

