/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMRaid5
implements InstanceProvider,
PropertyProvider,
MethodProvider,
Authorizable,
EventProvider {
    private static final int RUS_INIT = 1;
    private static final int RUS_OKAY = 2;
    private static final int RUS_ERRED = 4;
    private static final int RUS_LAST_ERRED = 8;
    private static final int RUS_DOI = 16;
    private static final int RUS_REGEN = 32;
    private static final int RCS_ERRED = 4;
    private static final int RCS_LAST_ERRED = 8;
    private static final int RCS_RESYNC = 16;
    private static final int RCS_INIT_ERRED = 32;
    private String hostName = null;
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CIMException(unknownHostException.getMessage());
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.raidToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Raid");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMRaid5"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)device.getProperty("device key").toString()));
                arrayList.add(cIMObjectPath2);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Raid");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                arrayList.add(this.raidToCI(device, cIMClass, bl, bl2, bl3, stringArray));
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string == null) {
            string = Solaris_VMUtil.getMDName(this.slvm, false);
        }
        UnsignedInt64 unsignedInt64 = (UnsignedInt64)Solaris_VMUtil.getValue(cIMInstance, "Interlace");
        CIMValue cIMValue = cIMInstance.getProperty("Raid5Components").getValue();
        if (cIMValue == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Raid5Component");
        }
        Vector vector = (Vector)cIMValue.getValue();
        if (vector.size() < 3) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Raid5Components");
        }
        String string2 = Solaris_VMUtil.getSliceDiskSet(this.slvm, (String)vector.get(0));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metainit");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add(string);
        arrayList.add("-r");
        for (int i = 0; i < vector.size(); ++i) {
            arrayList.add((String)vector.elementAt(i));
        }
        if (unsignedInt64 != null) {
            arrayList.add("-i");
            arrayList.add(unsignedInt64.toString() + "b");
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string2);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        String string3 = null;
        string3 = string2 != null ? string2 + "/" + string : string;
        Device device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string3, "name", "Raid");
        Long l = (Long)device.getProperty("device key");
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMRaid5"));
        cIMObjectPath2.addKey("Name", new CIMValue((Object)l.toString()));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string != null) {
            Solaris_VMUtil.rename(this.slvm, device, string);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (string.equalsIgnoreCase("attach")) {
            return this.attach(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("replace")) {
            return this.replace(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("useHSP")) {
            return this.useHSP(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("resync")) {
            return this.resync(vector, cIMObjectPath);
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.raidToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (!string2.equalsIgnoreCase("MetaDevice")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string3 = (String)cIMValue.getValue();
        Solaris_VMUtil.rename(this.slvm, device, string3);
    }

    private CIMValue attach(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        String string2 = (String)vector.get(0);
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"slice");
        }
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue replace(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        if (string2 == null || string3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"component");
        }
        String string4 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metareplace");
        if (string4 != null) {
            arrayList.add("-s");
            arrayList.add(string4);
        }
        arrayList.add("-f");
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue useHSP(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        Solaris_VMUtil.useHSP(vector, device, this.slvm, this.hostName);
        return null;
    }

    private CIMValue resync(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        Solaris_VMUtil.resync(vector, device, this.slvm, this.hostName);
        return null;
    }

    private CIMInstance raidToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        Integer n;
        Long l;
        Device device2 = null;
        Vector vector = null;
        try {
            vector = this.slvm.getAntecedents(device, "BasedOn");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mustFlush(device, vector)) {
            try {
                device2 = this.slvm.updateState(device);
                vector = this.slvm.getAntecedents(device2, "BasedOn");
            }
            catch (RemoteException remoteException) {}
        } else {
            device2 = device;
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (device2 == null) {
            return cIMInstance;
        }
        String string = (String)device2.getProperty("name");
        cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string));
        cIMInstance.setProperty("MountPoint", new CIMValue((Object)((String)device2.getProperty("mountpoint"))));
        Long l2 = (Long)device2.getProperty("size");
        if (l2 != null) {
            cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt64(l2.toString())));
        }
        if ((l = (Long)device2.getProperty("interlace")) != null) {
            cIMInstance.setProperty("Interlace", new CIMValue((Object)new UnsignedInt64(l.toString())));
        }
        if ((n = (Integer)device2.getProperty("percent done")) != null) {
            cIMInstance.setProperty("PercentDone", new CIMValue((Object)new UnsignedInt16(n.intValue())));
        }
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMRaid5"));
        cIMInstance.setProperty("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
        cIMInstance.setProperty("StorageRedundancy", new CIMValue((Object)new UnsignedInt16(0)));
        cIMInstance.setProperty("IsStriped", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("IsConcatenated", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("TypeOfAlgorithm", new CIMValue((Object)new Long(4L)));
        cIMInstance.setProperty("RedundancyStatus", this.getRedundancyStatus(device2, vector));
        Date date = (Date)device2.getProperty("time");
        if (date != null) {
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
        }
        String string2 = "";
        string2 = Solaris_VMUtil.isATransLog(device2) ? Solaris_VMUtil.getTransLogState(device2) : Solaris_VMRaid5.getRaidState(device2);
        cIMInstance.setProperty("Status", new CIMValue((Object)string2));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private boolean mustFlush(Device device, Vector vector) {
        int n = 0;
        Integer n2 = (Integer)device.getProperty("state");
        if (n2 != null) {
            n = n2;
        }
        if (n == 1) {
            return true;
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                String string = (String)device2.getProperty("type");
                if (!string.equals("Slice") || (n2 = (Integer)device2.getProperty("state")) == null || (n = n2.intValue()) != 16) continue;
                return true;
            }
        }
        return false;
    }

    private static String getRaidState(Device device) {
        Integer n = (Integer)device.getProperty("state");
        if (n == null) {
            return "";
        }
        int n2 = n;
        switch (n2) {
            case 1: {
                return "initializing";
            }
            case 2: {
                return "okay";
            }
            case 4: 
            case 8: {
                return "needs maintenance";
            }
            case 16: {
                return "init failed";
            }
            case 32: {
                return "regen";
            }
        }
        return "invalid";
    }

    private CIMValue getRedundancyStatus(Device device, Vector vector) {
        boolean bl = false;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Integer n;
                Device device2 = (Device)vector.get(i);
                String string = (String)device2.getProperty("type");
                if (!string.equals("Slice")) continue;
                if (this.sliceIsSpared(device2)) {
                    bl = true;
                }
                if ((n = (Integer)device2.getProperty("state")) == null) continue;
                int n2 = n;
                switch (n2) {
                    case 4: 
                    case 8: 
                    case 32: {
                        return new CIMValue((Object)new UnsignedInt16(4));
                    }
                }
            }
        }
        if (bl) {
            return new CIMValue((Object)new UnsignedInt16(3));
        }
        return new CIMValue((Object)new UnsignedInt16(2));
    }

    private boolean sliceIsSpared(Device device) {
        try {
            Vector vector = this.slvm.getDependents(device, "ExtentRedundancyComponent");
            if (vector != null && vector.size() > 0) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }
}

