/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMStateDatabase
implements InstanceProvider,
Authorizable,
PropertyProvider,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) throws RemoteException {
        SVM sVM = SVM.instance();
        try {
            Vector vector = sVM.getDevices("Metadb");
            System.out.println("Replicas:");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                System.out.println(device);
                Solaris_VMUtil.printDependents(sVM, device, "ExtentInDiskGroup", "ExtentInDiskGroup");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "ResidesOn:");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.replicaToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Metadb");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStateDatabase"));
                    String string = (String)device.getProperty("name");
                    Long l = (Long)device.getProperty("startblock");
                    cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)(l + string)));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Metadb");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    arrayList.add(this.replicaToCI(device, cIMClass, bl, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        AbstractList abstractList;
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "Name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        UnsignedInt64 unsignedInt64 = (UnsignedInt64)Solaris_VMUtil.getValue(cIMInstance, "NumberOfBlocks");
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)Solaris_VMUtil.getValue(cIMInstance, "NumReplicas");
        String string2 = Solaris_VMUtil.getSliceDiskSet(this.slvm, string);
        boolean bl = true;
        try {
            abstractList = this.slvm.getDevices("Metadb");
            if (abstractList != null && ((Vector)abstractList).size() > 0) {
                bl = false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        abstractList = new ArrayList();
        ((ArrayList)abstractList).add("/usr/sbin/metadb");
        if (string2 != null) {
            ((ArrayList)abstractList).add("-s");
            ((ArrayList)abstractList).add(string2);
        }
        ((ArrayList)abstractList).add("-a");
        if (bl) {
            ((ArrayList)abstractList).add("-f");
        }
        if (unsignedInt64 != null) {
            ((ArrayList)abstractList).add("-l");
            ((ArrayList)abstractList).add(unsignedInt64.toString());
        }
        if (unsignedInt32 != null) {
            ((ArrayList)abstractList).add("-c");
            ((ArrayList)abstractList).add(unsignedInt32.toString());
        }
        ((ArrayList)abstractList).add(string);
        Solaris_VMUtil.run((ArrayList)abstractList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string2);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        Device device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string, "name", "Metadb");
        cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStateDatabase"));
        String string3 = (String)device.getProperty("name");
        Long l = (Long)device.getProperty("startblock");
        cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)(l + string3)));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metadb");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add("-d");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.replicaToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance replicaToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        Object object;
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("ReadErrors", Solaris_VMStateDatabase.getStateValue(device, 1));
        cIMInstance.setProperty("TooSmall", Solaris_VMStateDatabase.getStateValue(device, 2));
        cIMInstance.setProperty("FormatErrors", Solaris_VMStateDatabase.getStateValue(device, 4));
        cIMInstance.setProperty("DataBlockErrors", Solaris_VMStateDatabase.getStateValue(device, 8));
        cIMInstance.setProperty("MasterBlockErrors", Solaris_VMStateDatabase.getStateValue(device, 16));
        cIMInstance.setProperty("Active", Solaris_VMStateDatabase.getStateValue(device, 32));
        cIMInstance.setProperty("WriteErrors", Solaris_VMStateDatabase.getStateValue(device, 64));
        cIMInstance.setProperty("Master", Solaris_VMStateDatabase.getStateValue(device, 128));
        cIMInstance.setProperty("InKernel", Solaris_VMStateDatabase.getStateValue(device, 1024));
        cIMInstance.setProperty("InConf", Solaris_VMStateDatabase.getStateValue(device, 2048));
        cIMInstance.setProperty("LocatorRead", Solaris_VMStateDatabase.getStateValue(device, 8192));
        cIMInstance.setProperty("UpToDate", Solaris_VMStateDatabase.getStateValue(device, 16384));
        cIMInstance.setProperty("WasActive", Solaris_VMStateDatabase.getStateValue(device, 32768));
        cIMInstance.setProperty("NumReplicas", new CIMValue((Object)new UnsignedInt32(1L)));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)this.hostName));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMStateDatabase"));
        String string = (String)device.getProperty("name");
        Long l = (Long)device.getProperty("startblock");
        cIMInstance.setProperty("DeviceID", new CIMValue((Object)(l + string)));
        cIMInstance.setProperty("Name", new CIMValue((Object)string));
        Long l2 = (Long)device.getProperty("size");
        if (l2 != null && l2 != -1L) {
            object = l2.toString();
            cIMInstance.setProperty("NumberOfBlocks", new CIMValue((Object)new UnsignedInt64((String)object)));
        }
        cIMInstance.setProperty("DataOrganization", new CIMValue((Object)new UnsignedInt16(2)));
        cIMInstance.setProperty("Access", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)Solaris_VMUtil.BLOCKSIZE));
        cIMInstance.setProperty("ConsumableBlocks", new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty("IsBasedOnUnderlyingRedundancy", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("SequentialAccess", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("PowerManagementSupported", new CIMValue((Object)Boolean.FALSE));
        object = new Vector();
        ((Vector)object).add(new UnsignedInt16(1));
        cIMInstance.setProperty("PowerManagementCapabilities", new CIMValue(object));
        cIMInstance.setProperty("Availability", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("StatusInfo", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("LastErrorCode", new CIMValue((Object)new UnsignedInt32(0L)));
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.add(new UnsignedInt16(6));
        cIMInstance.setProperty("AdditionalAvailability", new CIMValue(vector));
        cIMInstance.setProperty("MaxQuiesceTime", new CIMValue((Object)new UnsignedInt64("0")));
        String string2 = "okay";
        if (Solaris_VMStateDatabase.errored(device)) {
            string2 = "error";
        }
        cIMInstance.setProperty("Status", new CIMValue((Object)string2));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private static CIMValue getStateValue(Device device, int n) {
        Integer n2 = (Integer)device.getProperty("state");
        if (n2 != null && (n2 & n) != 0) {
            return new CIMValue((Object)Boolean.TRUE);
        }
        return new CIMValue((Object)Boolean.FALSE);
    }

    private static boolean errored(Device device) {
        Integer n = (Integer)device.getProperty("state");
        if (n != null) {
            int n2 = n;
            if ((n2 & 1) != 0) {
                return true;
            }
            if ((n2 & 2) != 0) {
                return true;
            }
            if ((n2 & 4) != 0) {
                return true;
            }
            if ((n2 & 8) != 0) {
                return true;
            }
            if ((n2 & 0x10) != 0) {
                return true;
            }
            if ((n2 & 0x40) != 0) {
                return true;
            }
        }
        return false;
    }
}

