/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMStripeComponent
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) {
        try {
            SVM sVM = SVM.instance();
            System.out.println("STRIPE associations:");
            System.out.println();
            Vector vector = null;
            vector = sVM.getDevices("Stripe");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "Resides On");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn");
            }
            System.exit(0);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            return this.stripeCompAssocToCI(cIMObjectPath2, device, cIMClass, -1, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Stripe");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMStripe", cIMObjectPath.getNameSpace());
                String string = null;
                Long l = (Long)device.getProperty("device key");
                string = l != null ? l.toString() : (String)device.getProperty("name");
                cIMObjectPath2.addKey("Name", new CIMValue((Object)string));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStripe"));
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string2 = (String)device2.getProperty("type");
                    if (!string2.equals("Slice") && !string2.equals("SoftPartition")) continue;
                    CIMInstance cIMInstance = this.stripeCompAssocToCI(cIMObjectPath2, device2, cIMClass, j, false, false, null);
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMStripeComponent", cIMObjectPath.getNameSpace());
                    cIMObjectPath3.addKey("GroupComponent", new CIMValue(cIMInstance.getProperty("GroupComponent").getValue().getValue()));
                    cIMObjectPath3.addKey("PartComponent", new CIMValue(cIMInstance.getProperty("PartComponent").getValue().getValue()));
                    arrayList.add(cIMObjectPath3);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Stripe");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "BasedOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice") && !string.equals("SoftPartition")) continue;
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMStripe", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStripe"));
                    String string2 = null;
                    Long l = (Long)device.getProperty("device key");
                    string2 = l != null ? l.toString() : (String)device.getProperty("name");
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)string2));
                    arrayList.add(this.stripeCompAssocToCI(cIMObjectPath2, device2, cIMClass, j, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "GroupComponent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "PartComponent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        String string = null;
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        string = device2 != null ? (String)device2.getProperty("name") : (String)Solaris_VMUtil.getOPValue(cIMObjectPath3, "DeviceID");
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add((String)device.getProperty("name"));
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMStripeComponent", cIMObjectPath.getNameSpace());
        cIMObjectPath4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
        return cIMObjectPath4;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMStripe");
        try {
            Vector<String> vector = new Vector<String>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                Long l;
                String string6;
                Device device2 = (Device)vector2.elementAt(i);
                String string7 = (String)device2.getProperty("type");
                String string8 = Solaris_VMUtil.deviceTypeToClass(string7);
                if (bl3) {
                    if (!string7.equals("Slice") && !string7.equals("SoftPartition")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, string5);
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    if (string7.equals("Slice")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                    } else {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    }
                } else {
                    if (!string7.equals("Stripe")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    string6 = null;
                    l = (Long)device2.getProperty("device key");
                    string6 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)string6));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    string6 = new CIMObjectPath(string8, string5);
                    l = new CIMObjectPath(string, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass((CIMObjectPath)string6, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass((CIMObjectPath)l, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((string6 = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
                }
                vector.addElement(string6);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMStripe");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Long l;
                String string6;
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string7 = (String)device2.getProperty("type");
                String string8 = Solaris_VMUtil.deviceTypeToClass(string7);
                if (bl) {
                    if (!string7.equals("Slice") && !string7.equals("SoftPartition")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, string5);
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    if (string7.equals("Slice")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                    } else {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    }
                } else {
                    if (!string7.equals("Stripe")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, cIMObjectPath2.getNameSpace());
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    string6 = null;
                    l = (Long)device2.getProperty("device key");
                    string6 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)string6));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    string6 = new CIMObjectPath(string8, string5);
                    l = new CIMObjectPath(string, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass((CIMObjectPath)string6, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass((CIMObjectPath)l, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMStripe");
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMStripeComponent", string3);
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4 = null;
                CIMInstance cIMInstance = null;
                Device device2 = (Device)vector2.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                if (bl3) {
                    if (!string4.equals("Slice") && !string4.equals("SoftPartition")) continue;
                    cIMInstance = this.stripeCompAssocToCI(cIMObjectPath2, device2, cIMClass, i, bl, bl2, stringArray);
                } else {
                    if (!string4.equals("Stripe")) continue;
                    String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                    cIMObjectPath4 = new CIMObjectPath(string5, string3);
                    cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)string5));
                    String string6 = null;
                    Long l = (Long)device2.getProperty("device key");
                    string6 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMInstance = this.stripeCompAssocToCI(cIMObjectPath4, device, cIMClass, i, bl, bl2, stringArray);
                }
                vector.addElement(cIMInstance);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMStripe");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "BasedOn") : this.slvm.getDependents(device, "BasedOn");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                String string4;
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string5 = (String)device2.getProperty("type");
                String string6 = Solaris_VMUtil.deviceTypeToClass(string5);
                if (bl) {
                    if (!string5.equals("Slice") && !string5.equals("SoftPartition")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string6, string3);
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string6));
                    if (string5.equals("Slice")) {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                    } else {
                        cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)device2.getProperty("device key").toString()));
                    }
                } else {
                    if (!string5.equals("Stripe")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string6, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string6));
                    string4 = null;
                    Long l = (Long)device2.getProperty("device key");
                    string4 = l != null ? l.toString() : (String)device2.getProperty("name");
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)string4));
                }
                string4 = new CIMObjectPath("Solaris_VMStripeComponent", string3);
                if (bl) {
                    string4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath2));
                    string4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath3));
                } else {
                    string4.addKey("PartComponent", new CIMValue((Object)cIMObjectPath2));
                    string4.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                }
                arrayList.add(string4);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance stripeCompAssocToCI(CIMObjectPath cIMObjectPath, Device device, CIMClass cIMClass, int n, boolean bl, boolean bl2, String[] stringArray) throws CIMProviderException {
        String string = (String)device.getProperty("type");
        String string2 = Solaris_VMUtil.deviceTypeToClass(string);
        String string3 = cIMObjectPath.getNameSpace();
        try {
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2, string3);
            String string4 = null;
            string4 = string.equals("Slice") ? (String)device.getProperty("name") : device.getProperty("device key").toString();
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)string2));
            cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string4));
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            if (n != -1) {
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(n)));
            } else {
                int n2 = Solaris_VMUtil.getCompOrder(this.slvm, cIMObjectPath, string4);
                cIMInstance.setProperty("Order", new CIMValue((Object)new Integer(n2)));
            }
            return cIMInstance.filterProperties(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception);
        }
    }
}

