/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMTrans
implements InstanceProvider,
PropertyProvider,
MethodProvider,
Authorizable,
EventProvider {
    private static final int TRANS_NEED_OPEN = 1;
    private static final int TRANS_OPENED = 2;
    private static final int TRANS_DETACHING = 4;
    private static final int TRANS_DETACHED = 8;
    private static final int TRANS_DETACH_SKIP = 16;
    private static final int TRANS_ATTACHING = 32;
    private static final int TRANS_ROLL_ON_WRITE = 64;
    private static final int TRANS_NEED_SCANROLL = 128;
    private String[] deviceTypes = new String[]{"Raid", "Stripe", "Mirror", "Concat", "SoftPartition"};
    private String hostName = null;
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;

    public static void main(String[] stringArray) throws RemoteException {
        SVM sVM = SVM.instance();
        System.out.println("TRANS:");
        System.out.println();
        Vector vector = null;
        try {
            vector = sVM.getDevices("Trans");
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Device device = (Device)vector.get(i);
            System.out.println(device.toString());
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CIMException(unknownHostException.getMessage());
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.transToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Trans");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMTrans"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)device.getProperty("device key").toString()));
                arrayList.add(cIMObjectPath2);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Trans");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                arrayList.add(this.transToCI(device, cIMClass, bl, bl2, bl3, stringArray));
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (string.equalsIgnoreCase("attach")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("detach")) {
            return this.detach(vector, cIMObjectPath);
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.transToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue detach(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metadetach");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMInstance transToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        String string;
        CIMInstance cIMInstance = cIMClass.newInstance();
        String string2 = (String)device.getProperty("name");
        cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string2));
        Long l = (Long)device.getProperty("size");
        if (l != null) {
            cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt64(l.toString())));
        }
        if ((string = (String)device.getProperty("mountpoint")) != null) {
            cIMInstance.setProperty("MountPoint", new CIMValue((Object)string));
        }
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMTrans"));
        cIMInstance.setProperty("Name", new CIMValue((Object)device.getProperty("device key").toString()));
        Date date = (Date)device.getProperty("time");
        if (date != null) {
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
        }
        String string3 = Solaris_VMTrans.getTransState(device);
        cIMInstance.setProperty("Status", new CIMValue((Object)string3));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private static String getTransState(Device device) {
        if (device == null) {
            return "";
        }
        int n = 0;
        Integer n2 = (Integer)device.getProperty("flags");
        if (n2 != null) {
            n = n2;
        }
        if ((n & 8) > 0) {
            return "detached";
        }
        if ((n & 4) > 0) {
            return "detaching";
        }
        if ((n & 0x20) > 0) {
            return "attaching";
        }
        return Solaris_VMUtil.getTransLogState(device);
    }

    private Device getMasterDevice(String string) {
        Device device = null;
        for (int i = 0; i < this.deviceTypes.length && (device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string, "name", this.deviceTypes[i])) == null; ++i) {
        }
        return device;
    }
}

