/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMTransLog
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) {
        try {
            SVM sVM = SVM.instance();
            System.out.println("TRANS associations:");
            System.out.println();
            Vector vector = null;
            vector = sVM.getDevices("Trans");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "Resides On");
                Solaris_VMUtil.printAntecedents(sVM, device, "TransLogOn", "Trans Log");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn");
                Solaris_VMUtil.printDependents(sVM, device, "TransLogOn", "Trans Log");
            }
            System.exit(0);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Antecedent");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Dependent");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
            }
            Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device2 == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            return this.transLogAssocToCI(cIMObjectPath, device2, device, cIMClass, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Trans");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "TransLogOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("trans component type");
                    if (!string.equals("log")) continue;
                    CIMInstance cIMInstance = this.transLogAssocToCI(cIMObjectPath, device, device2, cIMClass, false, false, null);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMTransLog", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("Antecedent", new CIMValue(cIMInstance.getProperty("Antecedent").getValue().getValue()));
                    cIMObjectPath2.addKey("Dependent", new CIMValue(cIMInstance.getProperty("Dependent").getValue().getValue()));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Trans");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "TransLogOn");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    String string = (String)device2.getProperty("trans component type");
                    if (!string.equals("log")) continue;
                    arrayList.add(this.transLogAssocToCI(cIMObjectPath, device, device2, cIMClass, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Dependent");
        if (cIMObjectPath2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        String string = Solaris_VMUtil.getDiskSet(this.slvm, device);
        String string2 = (String)device.getProperty("type");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metadetach");
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        arrayList.add("-f");
        arrayList.add((String)device.getProperty("name"));
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMTrans");
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "TransLogOn") : this.slvm.getDependents(device, "TransLogOn");
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4;
                Device device2 = (Device)vector2.elementAt(i);
                String string6 = (String)device2.getProperty("trans component type");
                String string7 = (String)device2.getProperty("type");
                String string8 = Solaris_VMUtil.deviceTypeToClass(string7);
                if (bl3) {
                    if (!string6.equals("log")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    if (string7.equalsIgnoreCase("Slice")) {
                        cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                        cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                        cIMObjectPath3.addKey("DeviceID", new CIMValue(device2.getProperty("name")));
                    } else {
                        cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    }
                } else {
                    if (!string7.equals("Trans")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string8, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string8));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    cIMObjectPath4 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string8, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath5, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((cIMObjectPath4 = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
                }
                vector.addElement(cIMObjectPath4);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMTrans");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "TransLogOn") : this.slvm.getDependents(device, "TransLogOn");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                String string8 = (String)device2.getProperty("trans component type");
                if (bl) {
                    if (!string8.equals("log")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    if (string6.equalsIgnoreCase("Slice")) {
                        cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                        cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                        cIMObjectPath3.addKey("DeviceID", new CIMValue(device2.getProperty("name")));
                    } else {
                        cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                    }
                } else {
                    if (!string6.equals("Trans")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)device2.getProperty("device key").toString()));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string7, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath4, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath5, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMTrans");
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "TransLogOn") : this.slvm.getDependents(device, "TransLogOn");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMTransLog", cIMObjectPath2.getNameSpace());
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                Object var16_17 = null;
                CIMInstance cIMInstance = null;
                Device device2 = (Device)vector2.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = (String)device2.getProperty("trans component type");
                if (bl3) {
                    if (!string5.equals("log")) continue;
                    cIMInstance = this.transLogAssocToCI(cIMObjectPath2, device, device2, cIMClass, bl, bl2, stringArray);
                } else {
                    if (!string4.equals("Trans")) continue;
                    cIMInstance = this.transLogAssocToCI(cIMObjectPath2, device2, device, cIMClass, bl, bl2, stringArray);
                }
                vector.addElement(cIMInstance);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMTrans");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "TransLogOn") : this.slvm.getDependents(device, "TransLogOn");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3 = null;
                Device device2 = (Device)vector.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = (String)device2.getProperty("trans component type");
                CIMInstance cIMInstance = null;
                cIMObjectPath3 = new CIMObjectPath("Solaris_VMTransLog", string3);
                CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, false, false, null);
                if (bl) {
                    if (!string5.equals("log")) continue;
                    cIMInstance = this.transLogAssocToCI(cIMObjectPath2, device, device2, cIMClass, false, false, null);
                } else {
                    if (!string4.equals("Trans")) continue;
                    cIMInstance = this.transLogAssocToCI(cIMObjectPath2, device2, device, cIMClass, false, false, null);
                }
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMTransLog", cIMObjectPath2.getNameSpace());
                cIMObjectPath4.addKey("Dependent", new CIMValue((Object)((CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Dependent"))));
                cIMObjectPath4.addKey("Antecedent", new CIMValue((Object)((CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Antecedent"))));
                arrayList.add(cIMObjectPath4);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance transLogAssocToCI(CIMObjectPath cIMObjectPath, Device device, Device device2, CIMClass cIMClass, boolean bl, boolean bl2, String[] stringArray) throws CIMProviderException {
        String string = null;
        String string2 = null;
        String string3 = (String)device2.getProperty("type");
        String string4 = Solaris_VMUtil.deviceTypeToClass(string3);
        String string5 = (String)device.getProperty("type");
        String string6 = Solaris_VMUtil.deviceTypeToClass(string5);
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string6, cIMObjectPath.getNameSpace());
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(string4, cIMObjectPath.getNameSpace());
            string = string3.equalsIgnoreCase("Slice") ? (String)device2.getProperty("name") : device2.getProperty("device key").toString();
            string2 = string5.equalsIgnoreCase("Slice") ? (String)device.getProperty("name") : device.getProperty("device key").toString();
            if (string3.equalsIgnoreCase("Slice")) {
                cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string4));
                cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)string));
            } else {
                cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string4));
                cIMObjectPath3.addKey("Name", new CIMValue((Object)string));
            }
            if (string5.equalsIgnoreCase("Slice")) {
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)string6));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string2));
            } else {
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)string6));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)string2));
            }
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath3));
            cIMInstance.setProperty("Dependent", new CIMValue((Object)cIMObjectPath2));
            return cIMInstance.filterProperties(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    private String getLogName(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        String string = null;
        String string2 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath2, "CreationClassName");
        if (string2.equalsIgnoreCase("Solaris_VMExtent")) {
            string = (String)Solaris_VMUtil.getOPValue(cIMObjectPath2, "DeviceID");
        } else {
            cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
            CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath2, false, false, false, null);
            string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        }
        return string;
    }
}

