/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.util.Command;
import com.sun.admin.volmgr.common.util.CommandResult;
import com.sun.admin.volmgr.server.SVM;
import com.sun.admin.volmgr.server.SVMEventListener;
import com.sun.wbem.solarisprovider.lvm.DeviceCompare;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMEventListener;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_VMUtil {
    public static final String LVM_WRITE_RIGHT = "solaris.admin.volmgr.write";
    public static final String LVM_READ_RIGHT = "solaris.admin.volmgr.read";
    public static final String LVM_PROVIDER_DEBUG = "com.sun.wbem.solarisprovider.lvm.provDebug";
    public static final String GROUP_COMPONENT = "GroupComponent";
    public static final String PART_COMPONENT = "PartComponent";
    public static final String COLLECTION = "Collection";
    public static final String MEMBER = "Member";
    public static final String ANTECEDENT = "Antecedent";
    public static final String DEPENDENT = "Dependent";
    public static final String COMMANDRESULT_GENERAL = "An error occurred while executing the command:\n\n";
    public static final String COMMANDRESULT_EXITCODE = "Exit Code: ";
    public static final String COMMANDRESULT_STDOUT = "Output: ";
    public static final String COMMANDRESULT_STDERR = "Error Output : ";
    public static final UnsignedInt64 BLOCKSIZE = new UnsignedInt64("512");
    private static String[] deviceTypes = new String[]{"Raid", "Stripe", "Mirror", "Concat", "Diskset", "Host", "Hsp", "HotSpare", "Metadb", "Disk", "Trans", "SoftPartition", "Slice"};
    private static PrintStream log = null;
    public static Hashtable subscriptions = new Hashtable();
    private static final int LDL_ERROR = 1;
    private static final int LDL_HERROR = 2;
    private static final int SMS_UNUSED = 0;
    private static final int SMS_RUNNING = 1;
    private static final int SMS_COMP_ERRED = 2;
    private static final int SMS_COMP_RESYNC = 4;
    private static final int SMS_ATTACHED = 8;
    private static final int SMS_ATTACHED_RESYNC = 16;
    private static final int SMS_OFFLINE = 32;
    private static final int SMS_OFFLINE_RESYNC = 64;
    private static final int SMS_ALL_ERRED = 128;
    private static final int SMS_INUSE = 65535;
    private static final int SMS_LIMPING = 6;
    private static final int SMS_IGNORE = 16384;
    private static final int SMS_ACTIVE = 87;
    private static final int MD_SM_RESYNC_TARGET = 1;
    private static final int MD_UN_RESYNC_ACTIVE = 65536;
    private static final int MD_UN_WAR = 131072;
    private static final int MD_UN_OFFLINE_SM = 262144;
    private static final int MD_UN_OPT_NOT_DONE = 524288;
    private static final int MD_UN_KEEP_DIRTY = 786432;
    private static final int MD_UN_RESYNC_CANCEL = 0x100000;
    private static final int MD_UN_REPLAYED = 0x200000;
    private static final int MD_UN_RENAMING = 0x400000;
    private static final int MD_UN_MOD_INPROGRESS = 0x490000;
    private static SVMEventListener svmEventListener = null;

    public static void writeLog(String string) {
        File file = new File("/tmp/cimlog.txt");
        if (!file.exists()) {
            log = Solaris_VMUtil.openLog();
        }
        if (log != null) {
            log.println(string);
        }
    }

    public static void activateFilter(String string, CIMObjectPath cIMObjectPath, boolean bl, ProviderCIMOMHandle providerCIMOMHandle, SVM sVM) throws CIMException {
        try {
            if (subscriptions.isEmpty()) {
                svmEventListener = new Solaris_VMEventListener(sVM, cIMObjectPath.getNameSpace());
                sVM.addEventListener(svmEventListener);
            }
            if (bl) {
                String string2 = Solaris_VMUtil.mapToType(string, cIMObjectPath);
                subscriptions.put(string2.toUpperCase(), providerCIMOMHandle);
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public static void deActivateFilter(String string, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle, SVM sVM) throws CIMException {
        try {
            String string2 = Solaris_VMUtil.mapToType(string, cIMObjectPath);
            subscriptions.remove(string2);
            if (subscriptions.isEmpty()) {
                sVM.removeEventListener(svmEventListener);
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public static void authorizeFilter(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Solaris_VMUtil.checkRights(providerCIMOMHandle, LVM_READ_RIGHT, cIMObjectPath);
    }

    public static boolean mustPoll(String string) throws CIMException {
        return string.equals("CIM_InstRead") || string.equals("CIM_InstMethodCall");
    }

    public static void checkRights(ProviderCIMOMHandle providerCIMOMHandle, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        String string2 = providerCIMOMHandle.getCurrentRole();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = providerCIMOMHandle.getCurrentUser();
        }
        if (string2 == null) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (string2.equals("guest")) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (!AuthorizationUtility.checkAuthName((String)string2, (String)string)) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    public static String deviceTypeToClass(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("Slice")) {
            return "Solaris_VMExtent";
        }
        if (string.equalsIgnoreCase("Metadb")) {
            return "Solaris_VMStateDatabase";
        }
        if (string.equalsIgnoreCase("Disk")) {
            return "Solaris_DiskDrive";
        }
        if (string.equalsIgnoreCase("Concat")) {
            return "Solaris_VMConcat";
        }
        if (string.equalsIgnoreCase("Stripe")) {
            return "Solaris_VMStripe";
        }
        if (string.equalsIgnoreCase("Raid")) {
            return "Solaris_VMRaid5";
        }
        if (string.equalsIgnoreCase("Diskset")) {
            return "Solaris_VMDiskSet";
        }
        if (string.equalsIgnoreCase("Hsp")) {
            return "Solaris_VMHotSparePool";
        }
        if (string.equalsIgnoreCase("Mirror")) {
            return "Solaris_VMMirror";
        }
        if (string.equalsIgnoreCase("Trans")) {
            return "Solaris_VMTrans";
        }
        if (string.equalsIgnoreCase("Host")) {
            return "Solaris_ComputerSystem";
        }
        if (string.equalsIgnoreCase("SoftPartition")) {
            return "Solaris_VMSoftPartition";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMDName(SVM sVM, boolean bl) throws CIMException {
        String string = null;
        try {
            int n;
            Object object;
            Vector vector;
            Integer[] integerArray;
            Vector vector2;
            Vector[] vectorArray = new Vector[bl ? 1 : 5];
            Vector<Integer> vector3 = new Vector<Integer>();
            if (!bl) {
                vector2 = sVM.getDevices("Raid");
                Vector vector4 = sVM.getDevices("Stripe");
                integerArray = sVM.getDevices("Concat");
                vector = sVM.getDevices("Mirror");
                object = sVM.getDevices("Trans");
                vectorArray[0] = vector2;
                vectorArray[1] = vector4;
                vectorArray[2] = integerArray;
                vectorArray[3] = vector;
                vectorArray[4] = object;
            } else {
                vectorArray[0] = vector2 = sVM.getDevices("Hsp");
            }
            int n2 = 0;
            for (n = 0; n < vectorArray.length; ++n) {
                for (int i = 0; vectorArray[n] != null && i < vectorArray[n].size(); ++i) {
                    vector = (Device)vectorArray[n].elementAt(i);
                    object = (String)vector.getProperty("name");
                    n2 = bl ? Integer.parseInt(((String)object).substring(((String)object).lastIndexOf("hsp") + 1)) : Integer.parseInt(((String)object).substring(((String)object).lastIndexOf("d") + 1));
                    vector3.addElement(new Integer(n2));
                }
            }
            if (vector3.size() != 0) {
                int n3;
                integerArray = new Integer[vector3.size()];
                vector3.toArray(integerArray);
                Arrays.sort(integerArray, new DeviceCompare());
                for (n = 0; n < integerArray.length && (n3 = integerArray[n].intValue()) <= n; ++n) {
                }
            }
            if (!bl) return "d" + new Integer(n).toString();
            if (n < 10) {
                return "hsp00" + new Integer(n).toString();
            }
            if (n >= 10 && n <= 99) {
                return "hsp0" + new Integer(n).toString();
            }
            if (n < 100) throw new CIMException("CIM_ERR_FAILED", (Object)"Too Many Hot Spare Pools");
            if (n > 999) throw new CIMException("CIM_ERR_FAILED", (Object)"Too Many Hot Spare Pools");
            return "hsp" + new Integer(n).toString();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public static Object getValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.getValue();
    }

    public static void flush(SVM sVM, String string) {
        Device device = null;
        Vector vector = null;
        try {
            vector = sVM.getDevices("Diskset");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                String string2 = (String)device2.getProperty("name");
                if (string == null && (string2 == null || string2.length() == 0)) {
                    device = device2;
                    break;
                }
                if (string == null || string2 == null || !string2.equals(string)) continue;
                device = device2;
                break;
            }
        }
        if (device != null) {
            try {
                sVM.updateState(device);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public static String getDiskSet(SVM sVM, Device device) {
        if (device == null) {
            return null;
        }
        String string = (String)device.getProperty("type");
        if (string.equals("Slice")) {
            return Solaris_VMUtil.getSliceDiskSet(sVM, (String)device.getProperty("name"));
        }
        Boolean bl = (Boolean)device.getProperty("top level device");
        if (bl != null && bl.booleanValue()) {
            String string2 = "ExtentInDiskGroup";
            if (string.equals("Hsp")) {
                string2 = "ExtentRedundancyComponent";
            }
            Vector vector = null;
            try {
                vector = sVM.getDependents(device, string2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device2 = (Device)vector.get(i);
                    string = (String)device2.getProperty("type");
                    if (!string.equals("Diskset")) continue;
                    Integer n = (Integer)device2.getProperty("setnumber");
                    if (n == null || n < 1) {
                        return null;
                    }
                    return (String)device2.getProperty("name");
                }
            }
            return null;
        }
        String string3 = (String)device.getProperty("trans component type");
        String string4 = "BasedOn";
        if (string3 != null && string3.equals("log")) {
            string4 = "TransLogOn";
        }
        Vector vector = null;
        try {
            vector = sVM.getDependents(device, string4);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null && vector.size() > 0) {
            return Solaris_VMUtil.getDiskSet(sVM, (Device)vector.get(0));
        }
        return null;
    }

    public static String getSliceDiskSet(SVM sVM, String string) {
        Vector vector = null;
        try {
            vector = sVM.getDevices("Diskset");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector == null) {
            return null;
        }
        int n = string.lastIndexOf("s");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i < vector.size(); ++i) {
            Device device = (Device)vector.get(i);
            Integer n2 = (Integer)device.getProperty("setnumber");
            if (n2 == null || n2 < 1) continue;
            Vector vector2 = null;
            try {
                vector2 = sVM.getAntecedents(device, "DriveInDiskGroup");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector2 == null) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                Device device2 = (Device)vector2.get(j);
                String string3 = (String)device2.getProperty("name");
                if (string3 == null || !string2.equals(string3)) continue;
                return (String)device.getProperty("name");
            }
        }
        return null;
    }

    public static Object getOPValue(CIMObjectPath cIMObjectPath, String string) {
        Object object = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(string)) continue;
            object = cIMProperty.getValue().getValue();
            break;
        }
        return object;
    }

    public static Device getDeviceByOP(SVM sVM, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "CreationClassName");
        if (string == null && !(string = cIMObjectPath.getObjectName()).equalsIgnoreCase("Solaris_VMDiskSet")) {
            return null;
        }
        Object object = null;
        Device device = null;
        if (string.equals("Solaris_VMStateDatabase")) {
            object = Solaris_VMUtil.getOPValue(cIMObjectPath, "DeviceID");
            if (object == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
            }
            Vector vector = null;
            try {
                vector = sVM.getDevices("Metadb");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device2 = (Device)vector.get(i);
                    String string2 = (String)device2.getProperty("name");
                    Long l = (Long)device2.getProperty("startblock");
                    String string3 = l + string2;
                    if (!string3.equals(object)) continue;
                    device = device2;
                    break;
                }
            }
        } else if (string.equals("Solaris_VMStripe")) {
            object = Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
            if (object == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
            }
            Vector vector = null;
            try {
                vector = sVM.getDevices("Stripe");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device3 = (Device)vector.get(i);
                    String string4 = null;
                    Long l = (Long)device3.getProperty("device key");
                    string4 = l != null ? l.toString() : (String)device3.getProperty("name");
                    if (!string4.equals(object)) continue;
                    device = device3;
                    break;
                }
            }
        } else {
            String string5 = null;
            String string6 = null;
            if (string.equals("Solaris_VMExtent")) {
                string5 = "name";
                string6 = "Slice";
                object = Solaris_VMUtil.getOPValue(cIMObjectPath, "DeviceID");
            } else if (string.equals("Solaris_VMConcat")) {
                string5 = "device key";
                string6 = "Concat";
                String string7 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
                object = new Long(string7);
            } else if (string.equals("Solaris_VMMirror")) {
                string5 = "device key";
                string6 = "Mirror";
                String string8 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
                object = new Long(string8);
            } else if (string.equals("Solaris_VMRaid5")) {
                string5 = "device key";
                string6 = "Raid";
                String string9 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
                object = new Long(string9);
            } else if (string.equals("Solaris_VMTrans")) {
                string5 = "device key";
                string6 = "Trans";
                String string10 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
                object = new Long(string10);
            } else if (string.equals("Solaris_VMHotSparePool")) {
                string5 = "name";
                string6 = "Hsp";
                object = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
            } else if (string.equals("Solaris_VMDiskSet")) {
                string5 = "name";
                string6 = "Diskset";
                object = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "CollectionID");
            } else if (string.equals("Solaris_DiskDrive")) {
                string5 = "name";
                string6 = "Disk";
                object = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "DeviceID");
            } else if (string.equals("Solaris_ComputerSystem")) {
                string5 = "name";
                string6 = "Host";
                object = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "Name");
            } else if (string.equals("Solaris_VMSoftPartition")) {
                string5 = "device key";
                string6 = "SoftPartition";
                String string11 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "DeviceID");
                object = new Long(string11);
            } else {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Unsupported device: " + string));
            }
            if (object == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
            }
            device = Solaris_VMUtil.getDeviceByAttr(sVM, object, string5, string6);
            if (device == null && string.equals("Solaris_VMExtent")) {
                string6 = "HotSpare";
                device = Solaris_VMUtil.getDeviceByAttr(sVM, object, string5, string6);
            }
        }
        return device;
    }

    public static Device getDeviceByAttr(SVM sVM, Object object, String string, String string2) {
        try {
            Vector vector = sVM.getDevices(string2);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    Object object2 = device.getProperty(string);
                    if (object2 == null || !object2.equals(object)) continue;
                    return device;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static void rename(SVM sVM, Device device, String string) throws CIMException {
        if (Solaris_VMUtil.diff(device, "name", string)) {
            String string2 = (String)device.getProperty("name");
            if (string2 == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)"name");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = Solaris_VMUtil.getDiskSet(sVM, device);
            arrayList.add("/usr/sbin/metarename");
            if (string3 != null) {
                arrayList.add("-s");
                arrayList.add(string3);
            }
            arrayList.add(string2);
            arrayList.add(string);
            String string4 = null;
            try {
                string4 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            Solaris_VMUtil.run(arrayList, string4);
        }
    }

    public static CIMInstance[] execQuery(CIMInstance[] cIMInstanceArray, String string, String string2) throws CIMException {
        CIMInstance[] cIMInstanceArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        ArrayList<CIMElement> arrayList = new ArrayList<CIMElement>();
        try {
            cIMInstanceArray2 = (CIMInstance[])wQLParser.querySpecification();
            SelectList selectList = cIMInstanceArray2.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)cIMInstanceArray2.getFromClause();
            QueryExp queryExp = cIMInstanceArray2.getWhereClause();
            for (int i = 0; i < cIMInstanceArray.length; ++i) {
                CIMInstance cIMInstance = cIMInstanceArray[i];
                if (queryExp != null && !queryExp.apply((CIMElement)cIMInstance)) continue;
                arrayList.add(selectList.apply((CIMElement)cIMInstance));
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        cIMInstanceArray2 = new CIMInstance[arrayList.size()];
        arrayList.toArray(cIMInstanceArray2);
        return cIMInstanceArray2;
    }

    public static void printDependents(SVM sVM, Device device, String string, String string2) throws RemoteException {
        System.out.println("    DEP - " + string2);
        Vector vector = sVM.getDependents(device, string);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                System.out.println("        " + device2);
            }
        }
    }

    public static void printAntecedents(SVM sVM, Device device, String string, String string2) throws RemoteException {
        System.out.println("    ANT - " + string2);
        Vector vector = sVM.getAntecedents(device, string);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                System.out.println("        " + device2);
            }
        }
    }

    public static void run(ArrayList arrayList, String string) throws CIMException {
        String[][] stringArray = new String[][]{arrayList.toArray(new String[arrayList.size()])};
        String string2 = null;
        CommandResult[] commandResultArray = null;
        try {
            Command command = new Command(stringArray);
            command.exec(true);
            commandResultArray = command.getResults();
            if (commandResultArray[0].getExitCode() == 0) {
                return;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        string2 = commandResultArray[0].toString(COMMANDRESULT_GENERAL, COMMANDRESULT_EXITCODE, COMMANDRESULT_STDOUT, COMMANDRESULT_STDERR);
        throw new CIMException("CIM_ERR_FAILED", (Object)string2);
    }

    public static ProviderCIMOMHandle getSubscriptionKey(String string) {
        return (ProviderCIMOMHandle)subscriptions.get(string);
    }

    public static String getSubmirrorState(SVM sVM, Device device, Device device2) {
        Integer n = (Integer)device.getProperty("state");
        int n2 = n;
        int n3 = 0;
        Integer n4 = (Integer)device.getProperty("flags");
        if (n4 != null) {
            n3 = n4;
        }
        boolean bl = (n3 & 1) > 0;
        int n5 = 0;
        Integer n6 = (Integer)device2.getProperty("state");
        if (n6 != null) {
            n5 = n6;
        }
        if ((n2 & 1) > 0 && ((n5 & 0x80000) <= 0 || (n5 & 0x80000) > 0 && !bl)) {
            return "okay";
        }
        if ((n2 & 0x54) > 0 || (n5 & 0x80000) > 0) {
            if ((n5 & 0x10000) > 0) {
                return "resyncing";
            }
            return "needs maintenance";
        }
        if ((n2 & 0x2A) > 0) {
            return "needs maintenance";
        }
        return "";
    }

    public static String getTransLogState(Device device) {
        Integer n = (Integer)device.getProperty("trans flags");
        if (n == null) {
            return "";
        }
        int n2 = n;
        if ((n2 & 1) > 0) {
            return "error";
        }
        if ((n2 & 2) > 0) {
            return "hard error";
        }
        return "okay";
    }

    public static Device getMyMirror(SVM sVM, Device device) {
        try {
            Vector vector = sVM.getDependents(device, "BasedOn");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device2 = (Device)vector.get(i);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Mirror")) continue;
                    return device2;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isATransLog(Device device) {
        String string = (String)device.getProperty("trans component type");
        return string != null && string.equals("log");
    }

    public static void resync(Vector vector, Device device, SVM sVM, String string) throws CIMException {
        String string2 = (String)device.getProperty("name");
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.get(0);
        String string3 = Solaris_VMUtil.getDiskSet(sVM, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metasync");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        if (unsignedInt32 != null) {
            arrayList.add(unsignedInt32.toString());
        }
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, string);
    }

    public static void useHSP(Vector vector, Device device, SVM sVM, String string) throws CIMException {
        String string2 = (String)device.getProperty("name");
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        String string3 = (String)vector.get(0);
        String string4 = Solaris_VMUtil.getDiskSet(sVM, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaparam");
        if (string4 != null) {
            arrayList.add("-s");
            arrayList.add(string4);
        }
        arrayList.add("-h");
        if (string3.length() == 0) {
            arrayList.add("none");
        } else {
            arrayList.add(string3);
        }
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, string);
    }

    public static boolean diff(Device device, String string, Object object) {
        String string2;
        Object object2 = device.getProperty(string);
        if (object2 == null && object != null) {
            return true;
        }
        if (object == null && object2 != null) {
            return true;
        }
        if (object2 == null && object == null) {
            return false;
        }
        String string3 = object2.toString();
        return !string3.equals(string2 = object.toString());
    }

    public static boolean isSuperClass(CIMClass cIMClass, CIMClass cIMClass2) throws CIMException {
        try {
            if (cIMClass.getName().equalsIgnoreCase(cIMClass2.getName())) {
                return true;
            }
            String string = cIMClass.getSuperClass();
            if (string == null || string.length() == 0) {
                return false;
            }
            CIMClass cIMClass3 = new CIMClass(string);
            return Solaris_VMUtil.isSuperClass(cIMClass3, cIMClass2);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public static int getCompOrder(SVM sVM, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        int n = -1;
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(sVM, cIMObjectPath);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
            }
            Vector vector = sVM.getAntecedents(device, "BasedOn");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device2 = (Device)vector.elementAt(i);
                String string2 = (String)device2.getProperty("name");
                if (!string2.equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)string);
            }
        }
        catch (Exception exception) {
            throw new CIMException(exception.getMessage());
        }
        return n;
    }

    public static long getCompStartBlock(SVM sVM, Device device, Device device2) throws CIMException {
        long l = 0L;
        try {
            Vector vector = sVM.getAntecedents(device, "BasedOn");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device3 = (Device)vector.elementAt(i);
                String string = (String)device2.getProperty("name");
                Long l2 = (Long)device3.getProperty("size");
                if (l2 != null) {
                    l += (long)i * l2;
                }
                if (!string.equalsIgnoreCase((String)device3.getProperty("name"))) continue;
                return l;
            }
            return l;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public static Device getDeviceByName(SVM sVM, String string) throws CIMException {
        try {
            if (string == null) {
                return null;
            }
            Device device = null;
            for (int i = 0; i < deviceTypes.length; ++i) {
                device = Solaris_VMUtil.getDeviceByAttr(sVM, string, "name", deviceTypes[i]);
                if (device == null) continue;
                return device;
            }
            return device;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    private static String mapToType(String string, CIMObjectPath cIMObjectPath) {
        String string2 = cIMObjectPath.getObjectName();
        if (string.equalsIgnoreCase("CIM_InstCreation")) {
            return string2 + "Create";
        }
        if (string.equalsIgnoreCase("CIM_InstModification")) {
            return string2 + "Modify";
        }
        if (string.equalsIgnoreCase("CIM_InstDeletion")) {
            return string2 + "Delete";
        }
        return null;
    }

    private static PrintStream openLog() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream("/tmp/cimlog.txt", true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        log = new PrintStream(fileOutputStream);
        return log;
    }
}

