/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.security.KeyStore;
import java.util.Hashtable;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SMCRMISocketFactory
extends RMISocketFactory
implements Serializable {
    protected static SSLServerSocketFactory ssf = null;
    protected static SSLSocketFactory csf = null;
    protected static ServerSocketFactory sf = null;
    protected static SocketFactory cf = null;
    protected static Hashtable insecureHosts = new Hashtable();

    public ServerSocket createServerSocket(int port) throws IOException {
        String is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes");
        String remote = System.getProperty("remote.connections");
        if (is_ssl.equals("no")) {
            if (sf == null) {
                sf = ServerSocketFactory.getDefault();
            }
            if (remote != null && remote.equals("true")) {
                return sf.createServerSocket(port);
            }
            return sf.createServerSocket(port, 10, InetAddress.getByName(null));
        }
        if (ssf == null) {
            try {
                char[] passphrase = SMCSSLConfig.getKeyStorePasswd();
                System.setProperty("javax.net.ssl.keyStorePassword", new String(passphrase));
                SSLContext ctx = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(SMCSSLConfig.getSMCServerKeyStore()), passphrase);
                kmf.init(ks, passphrase);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SMCX509");
                tmf.init((KeyStore)null);
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                ssf = ctx.getServerSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                ssf = null;
                throw new IOException("RMISSLSocketFactory: Failed to initialize Server SSL Context " + e);
            }
        }
        if (remote != null && remote.equals("true")) {
            return ssf.createServerSocket(port);
        }
        return ssf.createServerSocket(port, 10, InetAddress.getByName(null));
    }

    public Socket createSocket(String host, int port) throws IOException {
        boolean secure = true;
        String is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes");
        String remote = System.getProperty("remote.connections");
        if (is_ssl.equals("no")) {
            secure = false;
        } else if (!SMCRMISocketFactory.isServerSecure(host)) {
            secure = false;
        }
        if (!secure) {
            if (cf == null) {
                cf = SocketFactory.getDefault();
            }
            return cf.createSocket(host, port);
        }
        if (csf == null) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SMCX509");
                tmf.init((KeyStore)null);
                ctx.init(null, tmf.getTrustManagers(), null);
                csf = ctx.getSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                csf = null;
                throw new IOException("RMISSLSocketFactory: Failed to initialize Client SSL Context " + e);
            }
        }
        if (remote != null && remote.equals("false")) {
            host = "127.0.0.1";
        }
        return csf.createSocket(host, port);
    }

    public static void setInsecureHost(String hostname) throws UnknownHostException {
        InetAddress[] addr = InetAddress.getAllByName(hostname);
        String addrtxt = addr[0].getHostAddress();
        if (!insecureHosts.containsKey(addrtxt)) {
            insecureHosts.put(addrtxt, hostname);
        }
    }

    public static boolean isServerSecure(String hostname) {
        return !insecureHosts.containsKey(hostname) && !insecureHosts.containsValue(hostname);
    }
}

