/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.CertificateInfo;
import com.sun.management.viperimpl.util.security.DialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.misc.HexDumpEncoder;

public class CertificateDialog {
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private Component parentComponent;
    JTree certChainTree = null;
    final JTable certInfoTable = new JTable();
    final JTextArea textArea = new JTextArea();
    Object[] msg;
    Object[] options;

    public CertificateDialog(Certificate[] certs, int start, int end) {
        this(null, certs, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateDialog(Component parentComponent, Certificate[] certs, int start, int end) {
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.parentComponent = parentComponent;
        UIManager.getBorder("TableHeader.cellBorder");
        UIManager.getBorder("Table.focusCellHighlightBorder");
        UIManager.getColor("Table.focusCellForeground");
        UIManager.getColor("Table.focusCellBackground");
        JTable dummy = new JTable();
        dummy.getDefaultRenderer(String.class);
        dummy.getDefaultRenderer(Object.class);
        if (certs.length > start && certs[start] instanceof X509Certificate) {
            Border etchBorder = BorderFactory.createEtchedBorder();
            this.certChainTree = this.buildCertChainTree(certs, start, end);
            this.certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)CertificateDialog.this.certChainTree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    CertificateInfo certInfo = (CertificateInfo)node.getUserObject();
                    CertificateDialog.this.showCertificateInfo(certInfo.getCertificate());
                }
            });
            this.showCertificateInfo((X509Certificate)certs[start]);
            this.certInfoTable.setSelectionMode(0);
            ListSelectionModel rowSM = this.certInfoTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int row = CertificateDialog.this.certInfoTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    String value = (String)CertificateDialog.this.certInfoTable.getValueAt(row, 1);
                    CertificateDialog.this.textArea.setText(value);
                    CertificateDialog.this.textArea.repaint();
                }
            });
            this.textArea.setLineWrap(false);
            this.textArea.setEditable(false);
            this.textArea.setRows(10);
            this.textArea.setColumns(40);
            this.certInfoTable.setRowSelectionInterval(6, 6);
            JPanel panelInfo = new JPanel();
            panelInfo.setLayout(new BorderLayout());
            Dimension dim = this.certInfoTable.getPreferredScrollableViewportSize();
            dim.setSize(dim.getWidth(), 120.0);
            this.certInfoTable.setPreferredScrollableViewportSize(dim);
            JScrollPane scrollPane = new JScrollPane(this.certInfoTable);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), scrollPane.getBorder()));
            panelInfo.add((Component)scrollPane, "Center");
            panelInfo.add((Component)new JScrollPane(this.textArea), "South");
            panelInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            dim = this.certChainTree.getPreferredScrollableViewportSize();
            dim.setSize(200.0, 100.0);
            scrollPane = new JScrollPane(this.certChainTree);
            scrollPane.setPreferredSize(dim);
            panel.add((Component)scrollPane, "West");
            panel.add((Component)panelInfo, "East");
            this.msg = new Object[]{panel};
            JButton closeButton = new JButton(CertificateDialog.getMessage("cert_dialog.close"));
            closeButton.setMnemonic(CertificateDialog.getAcceleratorKey("cert_dialog.close"));
            this.options = new Object[]{closeButton};
        }
    }

    public void DoModal() {
        DialogFactory.showOptionDialog(this.parentComponent, (Object)this.msg, CertificateDialog.getMessage("cert_dialog.caption"), this.options, this.options[0]);
    }

    private String formatDNString(String dnString) {
        int len = dnString.length();
        boolean last = false;
        boolean inQuote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = dnString.charAt(i);
            if (ch == '\"' || ch == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (ch == ',' && !inQuote) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private JTree buildCertChainTree(Certificate[] cert, int start, int end) {
        DefaultMutableTreeNode root = null;
        DefaultMutableTreeNode currentNode = null;
        for (int i = start; i < cert.length && i < end; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)cert[i]));
            if (root == null) {
                root = childNode;
                currentNode = childNode;
                continue;
            }
            currentNode.add(childNode);
            currentNode = childNode;
        }
        JTree tree = new JTree(root);
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        return tree;
    }

    private void showCertificateInfo(X509Certificate cert) {
        String certVersion = "V" + cert.getVersion();
        BigInteger serial = cert.getSerialNumber();
        String certSerialNumber = "[" + serial + "]";
        String certSigAlg = "[" + cert.getSigAlgName() + "]";
        String certIssuer = this.formatDNString(((Object)cert.getIssuerDN()).toString());
        String certValidity = "[From: " + cert.getNotBefore() + ",\n To: " + cert.getNotAfter() + "]";
        String certSubject = this.formatDNString(((Object)cert.getSubjectDN()).toString());
        HexDumpEncoder encoder = new HexDumpEncoder();
        String certSig = encoder.encodeBuffer(cert.getSignature());
        Object[][] data = new Object[][]{{CertificateDialog.getMessage("cert_dialog.field.Version"), certVersion}, {CertificateDialog.getMessage("cert_dialog.field.SerialNumber"), certSerialNumber}, {CertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), certSigAlg}, {CertificateDialog.getMessage("cert_dialog.field.Issuer"), certIssuer}, {CertificateDialog.getMessage("cert_dialog.field.Validity"), certValidity}, {CertificateDialog.getMessage("cert_dialog.field.Subject"), certSubject}, {CertificateDialog.getMessage("cert_dialog.field.Signature"), certSig}};
        Object[] columnNames = new String[]{CertificateDialog.getMessage("cert_dialog.field"), CertificateDialog.getMessage("cert_dialog.value")};
        this.certInfoTable.setModel(new DefaultTableModel(data, columnNames){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        this.certInfoTable.setRowSelectionInterval(6, 6);
        this.certInfoTable.repaint();
        this.textArea.repaint();
    }

    private static String getMessage(String key) {
        return ImplResourceManager.getString((String)key);
    }

    private static int getAcceleratorKey(String key) {
        return ImplResourceManager.getAcceleratorKey((String)key);
    }
}

