/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.DefaultActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    private static String confirmDialogTitle = ImplResourceManager.getString((String)"usability.confirmDialogTitle");
    private static String inputDialogTitle = ImplResourceManager.getString((String)"usability.inputDialogTitle");
    private static String messageDialogTitle = ImplResourceManager.getString((String)"usability.messageDialogTitle");
    private static String exceptionDialogTitle = ImplResourceManager.getString((String)"usability.exceptionDialogTitle");
    private static String optionDialogTitle = ImplResourceManager.getString((String)"usability.optionDialogTitle");
    private static String aboutDialogTitle = ImplResourceManager.getString((String)"usability.aboutDialogTitle");
    private static String javaHomeLink = ImplResourceManager.getString((String)"usability.java.home.link");

    public static Icon loadIcon() {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL url = ClassLoader.getSystemResource("com/sun/management/viperimpl/util/security/logo.png");
                    ImageIcon imageIcon = new ImageIcon(url);
                    return imageIcon;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return icon;
    }

    public static void showAboutPluginDialog() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object lookAndFeel = null;
                JOptionPane pane = new JOptionPane();
                pane.setMessageType(-1);
                JButton btnClose = new JButton(ImplResourceManager.getString((String)"about.option.close"));
                btnClose.setMnemonic(67);
                pane.setOptions(new Object[]{btnClose});
                pane.setWantsInput(false);
                pane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                pane.setInitialValue(btnClose);
                pane.updateUI();
                DialogFactory.showDialog(pane, null, aboutDialogTitle, DialogFactory.createInfoPane(), false);
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    private static void launchLink(String link) {
    }

    private static JPanel createInfoPane() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setForeground(Color.WHITE);
        pane.setBackground(Color.WHITE);
        pane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        try {
            URL url = ClassLoader.getSystemResource("com/sun/management/viperimpl/util/security/aboutjava.png");
            ImageIcon imageTopIcon = new ImageIcon(url);
            JLabel topImage = new JLabel(imageTopIcon);
            JPanel topImagePane = new JPanel(new BorderLayout());
            topImagePane.setForeground(Color.WHITE);
            topImagePane.setBackground(Color.WHITE);
            topImagePane.add((Component)topImage, "Center");
            topImagePane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            pane.add("North", topImagePane);
            int lineWidth = imageTopIcon.getIconWidth() - 8;
            JPanel layoutPane = new JPanel();
            layoutPane.setLayout(new BoxLayout(layoutPane, 1));
            layoutPane.setBorder(BorderFactory.createEmptyBorder(0, 8, 4, 8));
            layoutPane.setForeground(Color.WHITE);
            layoutPane.setBackground(Color.WHITE);
            String verText = new StringBuffer(MessageFormat.format(ImplResourceManager.getString((String)"about.java.version"), System.getProperty("java.version"), System.getProperty("java.runtime.version"))).append('\n').append(ImplResourceManager.getString((String)"about.legal.note")).toString();
            JTextArea txtVer = new JTextArea();
            txtVer.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            txtVer.setEditable(false);
            txtVer.setLineWrap(true);
            txtVer.setWrapStyleWord(true);
            txtVer.setText(verText);
            Font font = txtVer.getFont();
            FontMetrics fm = txtVer.getFontMetrics(font);
            int txtLen = fm.stringWidth(ImplResourceManager.getString((String)"about.legal.note"));
            int rows = txtLen / (lineWidth - 8) + 2;
            txtVer.setRows(rows);
            layoutPane.add(txtVer);
            layoutPane.add(Box.createVerticalStrut(30));
            String strInfo = ImplResourceManager.getString((String)"about.prompt.info");
            String linkURL = ImplResourceManager.getString((String)"about.home.link");
            final String text = new StringBuffer("<font face=").append(font.getFamily()).append(" size=-1>").append(strInfo).append(" <a style='color:blue' href=").append(linkURL).append('>').append(linkURL).append("</a></font>").toString();
            final JEditorPane editPane = new JEditorPane("text/html", text);
            Insets is = editPane.getMargin();
            fm = editPane.getFontMetrics(font);
            txtLen = fm.stringWidth(strInfo + ' ' + linkURL);
            rows = txtLen / (lineWidth - is.left - is.right) + 1;
            Dimension d = new Dimension(lineWidth, rows * (fm.getHeight() + fm.getMaxDescent()) + is.top + is.bottom);
            editPane.setPreferredSize(d);
            editPane.setEditable(false);
            editPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        DialogFactory.launchLink(e.getURL().toString());
                    } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        editPane.setText(text.replaceFirst("'color:blue'", "'color:red'"));
                    } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        editPane.setText(text);
                    }
                }
            });
            layoutPane.add(editPane);
            pane.add((Component)layoutPane, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pane;
    }

    public static int showConfirmDialog(Object message) {
        return DialogFactory.showConfirmDialog(null, message, confirmDialogTitle);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) {
        return DialogFactory.showConfirmDialog(parentComponent, message, confirmDialogTitle);
    }

    public static String showInputDialog(Object message) {
        return DialogFactory.showInputDialog(null, message, inputDialogTitle);
    }

    public static String showInputDialog(Component parentComponent, Object message) {
        return DialogFactory.showInputDialog(parentComponent, message, inputDialogTitle);
    }

    public static void showInformationDialog(Object message) {
        DialogFactory.showInformationDialog(null, message, messageDialogTitle);
    }

    public static void showInformationDialog(Component parentComponent, Object message) {
        DialogFactory.showInformationDialog(parentComponent, message, messageDialogTitle);
    }

    public static void showErrorDialog(String message) {
        DialogFactory.showErrorDialog(null, message, messageDialogTitle);
    }

    public static void showErrorDialog(Component parentComponent, String message) {
        DialogFactory.showErrorDialog(parentComponent, message, messageDialogTitle);
    }

    public static void showExceptionDialog(Throwable ex) {
        DialogFactory.showExceptionDialog(null, ex, ex.toString(), exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component parentComponent, Throwable ex) {
        DialogFactory.showExceptionDialog(parentComponent, ex, ex.toString(), exceptionDialogTitle);
    }

    public static int showConfirmDialog(Object message, String title) {
        return DialogFactory.showConfirmDialog(null, message, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showConfirmDialog(Component parentComponent, Object message, String title) {
        Object lookAndFeel = null;
        JButton yes = new JButton(ImplResourceManager.getString((String)"usability.confirm.yes"));
        JButton no = new JButton(ImplResourceManager.getString((String)"usability.confirm.no"));
        yes.setMnemonic(ImplResourceManager.getAcceleratorKey((String)"usability.confirm.yes"));
        no.setMnemonic(ImplResourceManager.getAcceleratorKey((String)"usability.confirm.no"));
        Object[] options = new Object[]{yes, no};
        if (title == null) {
            title = confirmDialogTitle;
        }
        int n = DialogFactory.showOptionDialog(parentComponent, 4, message, title, options, options[0]);
        return n;
    }

    public static int showOptionDialog(Object message, String title, Object[] options, Object initValue) {
        return DialogFactory.showOptionDialog(null, message, title, options, initValue);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, Object[] options, Object initValue) {
        return DialogFactory.showOptionDialog(parentComponent, 5, message, title, options, initValue);
    }

    public static int showOptionDialog(int messageType, Object message, String title, Object[] options, Object initValue) {
        return DialogFactory.showOptionDialog(null, messageType, message, title, options, initValue);
    }

    public static int showOptionDialog(Component parentComponent, int messageType, Object message, String title, Object[] options, Object initValue) {
        return DialogFactory.showOptionDialogImpl(parentComponent, messageType, message, title, options, initValue, false);
    }

    public static void preLoadDialog(int messageType, Object message, String title, Object[] options, Object initValue) {
        DialogFactory.showOptionDialogImpl(null, messageType, message, title, options, options[0], true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showOptionDialogImpl(Component parentComponent, int messageType, Object message, String title, Object[] options, Object initValue, boolean preload) {
        Object selectedValue;
        Object lookAndFeel = null;
        int selection = -1;
        JOptionPane pane = new JOptionPane();
        switch (messageType) {
            case 1: {
                pane.setMessageType(0);
                break;
            }
            case 2: {
                pane.setMessageType(1);
                break;
            }
            case 3: {
                pane.setMessageType(2);
                break;
            }
            case 4: {
                pane.setMessageType(3);
                break;
            }
        }
        pane.setOptions(options);
        pane.setInitialValue(initValue);
        pane.setWantsInput(false);
        Object msg = DialogFactory.extractMessage(pane, message);
        if (title == null) {
            title = optionDialogTitle;
        }
        if (DialogFactory.showDialog(pane, parentComponent, title, msg, true, preload) && (selectedValue = pane.getValue()) != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!options[i].equals(selectedValue)) continue;
                selection = i;
                break;
            }
        }
        int n = selection;
        return n;
    }

    public static String showInputDialog(Object message, String title) {
        return DialogFactory.showInputDialog(null, message, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showInputDialog(Component parentComponent, Object message, String title) {
        Object selectedValue;
        Object lookAndFeel = null;
        String selection = null;
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(3);
        pane.setOptionType(2);
        pane.setWantsInput(true);
        Object msg = DialogFactory.extractMessage(pane, message);
        if (title == null) {
            title = inputDialogTitle;
        }
        if (DialogFactory.showDialog(pane, parentComponent, title, msg) && (selectedValue = pane.getInputValue()) != null && selectedValue instanceof String) {
            selection = selectedValue.toString();
        }
        String string = selection;
        return string;
    }

    private static void showMessageDialog(int messageType, Object message, String title, boolean fModal) {
        DialogFactory.showMessageDialog(null, messageType, message, title, fModal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageDialog(Component parentComponent, int messageType, Object message, String title, boolean fModal) {
        Object lookAndFeel = null;
        JOptionPane pane = new JOptionPane();
        switch (messageType) {
            case 1: {
                pane.setMessageType(0);
                break;
            }
            case 2: {
                pane.setMessageType(1);
                break;
            }
            case 3: {
                pane.setMessageType(2);
                break;
            }
            case 4: {
                pane.setMessageType(3);
                break;
            }
        }
        pane.setOptionType(-1);
        pane.setWantsInput(false);
        Object msg = DialogFactory.extractMessage(pane, message);
        if (title == null) {
            title = messageDialogTitle;
        }
        DialogFactory.showDialog(pane, parentComponent, title, msg, fModal);
    }

    public static void showInformationDialog(Object message, String title) {
        DialogFactory.showInformationDialog(null, message, title);
    }

    public static void showInformationDialog(Component parentComponent, Object message, String title) {
        DialogFactory.showMessageDialog(parentComponent, 2, message, title, true);
    }

    public static void showErrorDialog(String message, String title) {
        DialogFactory.showErrorDialog(null, message, title);
    }

    public static void showErrorDialog(Component parentComponent, String message, String title) {
        DialogFactory.showMessageDialog(parentComponent, 1, message, title, true);
    }

    public static void showExceptionDialog(Throwable ex, String message) {
        DialogFactory.showExceptionDialog(ex, message, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component parentComponent, Throwable ex, String message) {
        DialogFactory.showExceptionDialog(parentComponent, ex, message, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Throwable e, String message, String title) {
        DialogFactory.showExceptionDialog(null, e, message, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showExceptionDialog(Component parentComponent, Throwable e, String message, String title) {
        Object lookAndFeel = null;
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(0);
        pane.setOptionType(-1);
        pane.setWantsInput(false);
        Component ex = (Component)DialogFactory.extractMessage(pane, e);
        final JPanel morePanel = new JPanel();
        JButton moreButton = new JButton(ImplResourceManager.getString((String)"usability.moreInfo"));
        moreButton.setMnemonic(ImplResourceManager.getAcceleratorKey((String)"usability.moreInfo"));
        morePanel.setLayout(new FlowLayout(2));
        morePanel.add(moreButton);
        final JPanel lessPanel = new JPanel();
        JButton lessButton = new JButton(ImplResourceManager.getString((String)"usability.lessInfo"));
        lessButton.setMnemonic(ImplResourceManager.getAcceleratorKey((String)"usability.lessInfo"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(lessButton);
        lessPanel.setLayout(new BorderLayout());
        lessPanel.add((Component)buttonPanel, "Center");
        lessPanel.add(ex, "South");
        final JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)morePanel, "Center");
        moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component source = (Component)e.getSource();
                Dialog dialog = null;
                while (source.getParent() != null) {
                    if (source instanceof JDialog) {
                        dialog = (JDialog)source;
                    }
                    source = source.getParent();
                }
                if (dialog != null) {
                    dialog.setVisible(false);
                    dialog.setResizable(true);
                    containerPanel.remove(morePanel);
                    containerPanel.add((Component)lessPanel, "Center");
                    dialog.doLayout();
                    dialog.pack();
                    dialog.setResizable(false);
                    dialog.setVisible(true);
                }
            }
        });
        lessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component source = (Component)e.getSource();
                Dialog dialog = null;
                while (source.getParent() != null) {
                    if (source instanceof JDialog) {
                        dialog = (JDialog)source;
                    }
                    source = source.getParent();
                }
                if (dialog != null) {
                    dialog.setVisible(false);
                    dialog.setResizable(true);
                    containerPanel.remove(lessPanel);
                    containerPanel.add((Component)morePanel, "Center");
                    dialog.doLayout();
                    dialog.pack();
                    dialog.setResizable(false);
                    dialog.setVisible(true);
                }
            }
        });
        Object[] msgs = new Object[]{DialogFactory.extractMessage(pane, message), containerPanel};
        if (title == null) {
            title = exceptionDialogTitle;
        }
        DialogFactory.showDialog(pane, parentComponent, title, msgs);
    }

    private static boolean showDialog(JOptionPane pane, Component parentComponent, String title, Object msg) {
        return DialogFactory.showDialog(pane, parentComponent, title, msg, true, false);
    }

    private static boolean showDialog(JOptionPane pane, Component parentComponent, String title, Object msg, boolean fModal) {
        return DialogFactory.showDialog(pane, parentComponent, title, msg, fModal, false);
    }

    private static boolean showDialog(final JOptionPane pane, final Component parentComponent, final String title, final Object msg, final boolean fModal, final boolean preload) {
        boolean dialogNoError = true;
        try {
            pane.setValue(null);
            Runnable work = new Runnable(){

                public void run() {
                    JDialog dialog = pane.createDialog(parentComponent, title);
                    Object[] options = pane.getOptions();
                    if (null != options) {
                        DefaultActionListener lsr = new DefaultActionListener(dialog, pane);
                        for (int index = 0; index < options.length; ++index) {
                            if (!(options[index] instanceof JButton)) continue;
                            JButton btn = (JButton)options[index];
                            ActionListener[] listeners = btn.getActionListeners();
                            for (int i = 0; i < listeners.length; ++i) {
                                if (!(listeners[i] instanceof DefaultActionListener)) continue;
                                btn.removeActionListener((DefaultActionListener)listeners[i]);
                            }
                            if (btn.getActionListeners().length != 0) continue;
                            btn.addActionListener(lsr);
                        }
                    }
                    pane.setMessage(msg);
                    dialog.pack();
                    DialogFactory.fixSwingLayoutBug(msg);
                    dialog.pack();
                    dialog.setResizable(false);
                    dialog.setModal(fModal);
                    Dimension dlgDimension = dialog.getSize();
                    Dimension scrndimension = Toolkit.getDefaultToolkit().getScreenSize();
                    dlgDimension.width += 30;
                    dialog.setLocation((scrndimension.width - dlgDimension.width) / 2, (scrndimension.height - dlgDimension.height) / 2);
                    if (!preload) {
                        dialog.show();
                        dialog.pack();
                        dialog.toFront();
                    }
                }
            };
            if (preload || SwingUtilities.isEventDispatchThread()) {
                work.run();
            } else if (fModal) {
                SwingUtilities.invokeAndWait(work);
            } else {
                SwingUtilities.invokeLater(work);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dialogNoError = false;
        }
        return dialogNoError;
    }

    private static Object extractMessage(JOptionPane pane, Throwable message) {
        return DialogFactory.formatExceptionMessage(pane, message);
    }

    private static Object extractMessage(JOptionPane pane, String message) {
        return DialogFactory.formatStringMessage(pane, message);
    }

    private static Object extractMessage(JOptionPane pane, Object[] messages) {
        Object[] result = null;
        if (messages != null) {
            result = new Object[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                result[i] = DialogFactory.extractMessage(pane, messages[i]);
            }
        }
        return result;
    }

    private static Object extractMessage(JOptionPane pane, Object message) {
        if (message instanceof Object[]) {
            return DialogFactory.extractMessage(pane, (Object[])message);
        }
        if (message instanceof String) {
            return DialogFactory.extractMessage(pane, (String)message);
        }
        if (message instanceof Exception) {
            return DialogFactory.extractMessage(pane, (Exception)message);
        }
        return message;
    }

    private static Object formatStringMessage(JOptionPane pane, String in) {
        int i;
        if (in == null) {
            in = "null";
        }
        if ((i = in.indexOf("</html>")) == -1) {
            JTextArea text = new JTextArea();
            text.setColumns(40);
            text.setAutoscrolls(true);
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setBackground(pane.getBackground());
            text.setText(in);
            return text;
        }
        if (i + 7 == in.length()) {
            return new JLabel(in);
        }
        Object[] msgs = new Object[]{new JLabel(in.substring(0, i + 7)), DialogFactory.formatStringMessage(pane, in.substring(i + 7))};
        return msgs;
    }

    private static Object formatExceptionMessage(JOptionPane pane, Throwable e) {
        StringWriter byt = new StringWriter();
        PrintWriter print = new PrintWriter(byt);
        e.printStackTrace(print);
        JTextArea text = new JTextArea("" + byt.toString());
        text.setColumns(40);
        text.setRows(10);
        text.setEditable(false);
        JScrollPane spane = new JScrollPane(text);
        text.setBackground(pane.getBackground());
        return spane;
    }

    private static void fixSwingLayoutBug(Object msg) {
        if (msg == null) {
            return;
        }
        if (msg instanceof JTextArea) {
            JTextArea text = (JTextArea)msg;
            text.getUI().getPreferredSize(text);
            return;
        }
        if (msg.getClass().isArray()) {
            int len = Array.getLength(msg);
            for (int i = 0; i < len; ++i) {
                DialogFactory.fixSwingLayoutBug(Array.get(msg, i));
            }
        }
    }
}

