/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.SMCRMISocketFactory;
import com.sun.management.viperimpl.util.security.RandomThread;
import com.sun.management.viperimpl.util.security.RootCACertificateStore;
import com.sun.management.viperimpl.util.security.SMCProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.RMISocketFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.Random;

public class SMCSSLConfig {
    protected static boolean initDone = false;
    protected static Properties sslProps;
    private static byte[] pp;
    protected static String baseDir;

    protected SMCSSLConfig() {
    }

    public static String getUserCertificateFile() {
        return System.getProperty("user.home") + "/.smccerts";
    }

    public static char[] getUserCertificatePswd() {
        return "passphrase".toCharArray();
    }

    public static String getRootCertificateFile() {
        return baseDir + "/" + sslProps.getProperty("smc.ssl.cacerts");
    }

    public static String getSMCServerKeyStore() {
        return baseDir + sslProps.getProperty("smc.ssl.keystore");
    }

    public static char[] getKeyStorePasswd() {
        return "passphrase".toCharArray();
    }

    public static void setupServer() {
        if (initDone) {
            return;
        }
        System.setProperty("sun.smc.internal.ssl.enable", sslProps.getProperty("sun.smc.internal.ssl.enable"));
        if (!sslProps.getProperty("sun.smc.internal.ssl.enable").equals("yes")) {
            initDone = true;
            return;
        }
        RandomThread.start();
        try {
            char[] _storepass = SMCSSLConfig.getKeyStorePasswd();
            String _smcrootcert = SMCSSLConfig.getSMCServerKeyStore();
            FileInputStream fis = new FileInputStream(new File(_smcrootcert));
            BufferedInputStream bis = new BufferedInputStream(fis);
            KeyStore servercert = KeyStore.getInstance("JKS");
            servercert.load(bis, _storepass);
            bis.close();
            fis.close();
            Certificate scert = servercert.getCertificate("smcserverkey");
            servercert.deleteEntry("smcserverkey");
            RootCACertificateStore rootStore = new RootCACertificateStore();
            rootStore.load();
            if (!rootStore.contains(scert)) {
                rootStore.replaceSMC("smcservercert", scert);
                rootStore.save();
            }
            SMCProvider prov = new SMCProvider();
            Security.addProvider(prov);
            System.setProperty("com.sun.wbem.rmisocketfactory.class", SMCSSLConfig.getSSLSocketfactoryClass());
            try {
                RMISocketFactory.setSocketFactory(new SMCRMISocketFactory());
            }
            catch (IOException ie) {
                // empty catch block
            }
            initDone = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.setProperty("sun.smc.internal.ssl.enable", "no");
            return;
        }
    }

    public static void setup() {
        if (initDone) {
            return;
        }
        System.setProperty("sun.smc.internal.ssl.enable", sslProps.getProperty("sun.smc.internal.ssl.enable"));
        if (!sslProps.getProperty("sun.smc.internal.ssl.enable").equals("yes")) {
            initDone = true;
            return;
        }
        try {
            RandomThread.sr = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException na) {
            RandomThread.sr = new Random(System.currentTimeMillis());
        }
        byte[] dmy = new byte[4];
        RandomThread.sr.nextBytes(dmy);
        try {
            SMCProvider prov = new SMCProvider();
            Security.addProvider(prov);
            System.setProperty("com.sun.wbem.rmisocketfactory.class", SMCSSLConfig.getSSLSocketfactoryClass());
            try {
                RMISocketFactory.setSocketFactory(new SMCRMISocketFactory());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            initDone = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.setProperty("sun.smc.internal.ssl.enable", "no");
            return;
        }
    }

    public static String getSSLSocketfactoryClass() {
        return SMCRMISocketFactory.class.getName();
    }

    static {
        pp = null;
        baseDir = System.getProperty("BaseDir");
        if (baseDir == null) {
            baseDir = "/";
        }
        sslProps = new Properties();
        try {
            FileInputStream si = new FileInputStream("/usr/sadm/lib/wbem/WbemServices.properties");
            sslProps.load(si);
            ((InputStream)si).close();
            if (sslProps.getProperty("smc.ssl.pp.file") != null) {
                try {
                    String pf = baseDir + sslProps.getProperty("smc.ssl.pp.file");
                    pp = new byte[20];
                    FileInputStream fi = new FileInputStream(pf);
                    fi.read(pp, 0, 10);
                    fi.close();
                }
                catch (IOException ioe) {
                    pp = null;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.setProperty("javax.net.ssl.trustStore", SMCSSLConfig.getRootCertificateFile());
        if (pp != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", new String(pp));
        } else {
            System.setProperty("javax.net.ssl.trustStorePassword", new String("passphrase"));
        }
    }
}

