/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.CertificateDialog;
import com.sun.management.viperimpl.util.security.DialogFactory;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;
    private boolean httpsDialog = false;
    private CertificateDialog dialog = null;

    TrustDeciderDialog(Certificate[] certs, int start, int end, boolean rootCANotValid, boolean timeNotValid) {
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.rootCANotValid = rootCANotValid;
        this.timeNotValid = timeNotValid;
        this.dialog = new CertificateDialog(certs, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int DoModal() {
        Object lookAndFeel = null;
        int ret = -1;
        if (this.certs[this.start] instanceof X509Certificate && this.certs[this.end - 1] instanceof X509Certificate) {
            JLabel label;
            X509Certificate cert = (X509Certificate)this.certs[this.start];
            X509Certificate cert2 = (X509Certificate)this.certs[this.end - 1];
            Principal prinSubject = cert.getSubjectDN();
            Principal prinIssuer = cert2.getIssuerDN();
            String subjectDNName = prinSubject.getName();
            String subjectName = null;
            int i = subjectDNName.indexOf("CN=");
            int j = 0;
            if (i < 0) {
                subjectName = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
            } else {
                try {
                    j = subjectDNName.charAt(i += 3) == '\"' ? subjectDNName.indexOf(34, ++i) : subjectDNName.indexOf(44, i);
                    subjectName = j < 0 ? subjectDNName.substring(i) : subjectDNName.substring(i, j);
                }
                catch (IndexOutOfBoundsException e) {
                    subjectName = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
                }
            }
            String issuerDNName = prinIssuer.getName();
            String issuerName = null;
            i = issuerDNName.indexOf("O=");
            j = 0;
            if (i < 0) {
                issuerName = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
            } else {
                try {
                    j = issuerDNName.charAt(i += 2) == '\"' ? issuerDNName.indexOf(34, ++i) : issuerDNName.indexOf(44, i);
                    issuerName = j < 0 ? issuerDNName.substring(i) : issuerDNName.substring(i, j);
                }
                catch (IndexOutOfBoundsException e) {
                    issuerName = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
                }
            }
            ArrayList<Object> dialogMsgArray = new ArrayList<Object>();
            MessageFormat mf = null;
            mf = this.getHttpsDialog() ? new MessageFormat(TrustDeciderDialog.getMessage("security_dialog_https.text0")) : new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text0"));
            Object[] args = new Object[]{subjectName, issuerName};
            dialogMsgArray.add(mf.format(args));
            dialogMsgArray.add("");
            if (this.rootCANotValid) {
                label = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCANotValid"));
                label.setIcon(this.getWarningIcon());
                dialogMsgArray.add(label);
            } else {
                label = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCAValid"));
                label.setIcon(this.getInfoIcon());
                dialogMsgArray.add(label);
            }
            dialogMsgArray.add("");
            if (this.timeNotValid) {
                label = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeNotValid"));
                label.setIcon(this.getWarningIcon());
                dialogMsgArray.add(label);
            } else {
                label = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeValid"));
                label.setIcon(this.getInfoIcon());
                dialogMsgArray.add(label);
            }
            mf = new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text1"));
            Object[] args2 = new Object[]{subjectName, subjectName};
            dialogMsgArray.add(mf.format(args2));
            JButton infoButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonViewCert"));
            infoButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonViewCert"));
            infoButton.addActionListener(this);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(infoButton);
            buttonPanel.setLayout(new FlowLayout(2));
            dialogMsgArray.add(buttonPanel);
            JButton yesButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonYes"));
            JButton noButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonNo"));
            JButton alwaysButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonAlways"));
            yesButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonYes"));
            noButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonNo"));
            alwaysButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security_dialog.buttonAlways"));
            Object[] options = new Object[]{yesButton, noButton, alwaysButton};
            ret = DialogFactory.showOptionDialog(4, (Object)dialogMsgArray.toArray(), TrustDeciderDialog.getMessage("security_dialog.caption"), options, options[0]);
        }
        int n = ret;
        return n;
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog.DoModal();
    }

    private static String getMessage(String key) {
        return ImplResourceManager.getString((String)key);
    }

    private static int getAcceleratorKey(String key) {
        return ImplResourceManager.getAcceleratorKey((String)key);
    }

    private Icon getWarningIcon() {
        return this.getIcon("javax/swing/plaf/metal/icons/Warn.gif");
    }

    private Icon getInfoIcon() {
        return this.getIcon("javax/swing/plaf/metal/icons/Inform.gif");
    }

    private Icon getIcon(String image) {
        URL url = ClassLoader.getSystemResource(image);
        return new ImageIcon(url);
    }

    private boolean getHttpsDialog() {
        return this.httpsDialog;
    }

    public void setHttpsDialog(boolean httpsDialogType) {
        this.httpsDialog = httpsDialogType;
    }
}

