/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.wbem.cim.MOFFormatter;

public class CIMDateTime
implements Serializable {
    static final long serialVersionUID = 200L;
    private boolean isInterval = false;
    private String dateString = null;

    public CIMDateTime() {
        this(new Date());
    }

    public CIMDateTime(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        this.dateString = this.getCalendarString(cal);
    }

    public CIMDateTime(Calendar c) {
        this.dateString = this.getCalendarString(c);
    }

    public CIMDateTime(String dt) throws IllegalArgumentException {
        boolean b = true;
        if (dt.length() != 25 || dt.charAt(14) != '.') {
            b = false;
        } else if (dt.charAt(21) == ':') {
            this.isInterval = true;
            int i = Integer.valueOf(dt.substring(0, 8));
            i = Integer.valueOf(dt.substring(8, 10));
            b = b && i >= 0 && i <= 24;
            i = Integer.valueOf(dt.substring(10, 12));
            b = b && i >= 0 && i <= 60;
            i = Integer.valueOf(dt.substring(12, 14));
            b = b && i >= 0 && i <= 60;
            i = Integer.valueOf(dt.substring(15, 21));
            b = b && i >= 0 && i <= 999999;
            this.dateString = dt.substring(0, 22);
            this.dateString.concat("000");
        } else {
            this.dateString = dt;
            Calendar calendar = this.getCalendar();
        }
        if (!b) {
            throw new IllegalArgumentException(dt);
        }
    }

    public Calendar getCalendar() throws IllegalArgumentException {
        Calendar retCal = null;
        if (this.dateString.charAt(21) != '+' && this.dateString.charAt(21) != '-') {
            throw new IllegalArgumentException(this.dateString);
        }
        try {
            int i = Integer.parseInt(this.dateString.substring(15, 21));
            retCal = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            formatter.setLenient(false);
            Date date = formatter.parse(this.dateString.substring(0, 18));
            retCal.setTime(date);
            Integer offset = Integer.valueOf(this.dateString.substring(22));
            if (this.dateString.charAt(21) == '-') {
                offset = new Integer(offset * -1);
            }
            TimeZone tz = TimeZone.getTimeZone("GMT");
            tz.setRawOffset(offset * 60 * 1000);
            retCal.setTimeZone(tz);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.dateString + " " + e);
        }
        return retCal;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public boolean after(CIMDateTime when) throws IllegalArgumentException {
        if (this.isInterval() && !when.isInterval() || !this.isInterval() && when.isInterval()) {
            throw new IllegalArgumentException(when.toString());
        }
        if (this.isInterval()) {
            return this.toString().compareTo(when.toString()) > 0;
        }
        Calendar cal = this.getCalendar();
        return cal.after(when.getCalendar());
    }

    public boolean before(CIMDateTime when) throws IllegalArgumentException {
        if (this.isInterval() && !when.isInterval() || !this.isInterval() && when.isInterval()) {
            throw new IllegalArgumentException(when.toString());
        }
        if (this.isInterval()) {
            return this.toString().compareTo(when.toString()) < 0;
        }
        Calendar cal = this.getCalendar();
        return cal.before(when.getCalendar());
    }

    public boolean equals(Object obj) throws IllegalArgumentException {
        CIMDateTime date = (CIMDateTime)obj;
        if (this.isInterval() && !date.isInterval() || !this.isInterval() && date.isInterval()) {
            throw new IllegalArgumentException(date.toString());
        }
        return this.dateString.equals(date.getDateTimeString());
    }

    protected String getDateTimeString() {
        return this.dateString;
    }

    private String getCalendarString(Calendar c) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.padLeadingZeros(c.get(1), 4));
        buf.append(this.padLeadingZeros(c.get(2) + 1, 2));
        buf.append(this.padLeadingZeros(c.get(5), 2));
        buf.append(this.padLeadingZeros(c.get(11), 2));
        buf.append(this.padLeadingZeros(c.get(12), 2));
        buf.append(this.padLeadingZeros(c.get(13), 2));
        buf.append(".");
        buf.append(this.padTrailingZeros(c.get(14), 6));
        int offset = c.get(15);
        if (offset < 0) {
            buf.append("-");
        } else {
            buf.append("+");
        }
        buf.append(this.padLeadingZeros(Math.abs(offset / 60000), 3));
        return buf.toString();
    }

    private String padLeadingZeros(int number, int numSize) {
        return this.padLeadingZeros(String.valueOf(number), numSize);
    }

    private String padLeadingZeros(String number, int numSize) {
        StringBuffer buf = new StringBuffer(number);
        for (int i = number.length(); i < numSize; ++i) {
            buf.insert(0, 0);
        }
        return buf.toString();
    }

    private String padTrailingZeros(int number, int numSize) {
        return this.padTrailingZeros(String.valueOf(number), numSize);
    }

    private String padTrailingZeros(String number, int numSize) {
        StringBuffer buf = new StringBuffer(number);
        for (int i = number.length(); i < numSize; ++i) {
            buf.append(0);
        }
        return buf.toString();
    }
}

