/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.MOFFormatter;

public class CIMMethod
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private String originClass = "";
    private CIMDataType type = null;
    private int size = 0;
    private Vector qualifiers = new Vector();
    private Vector parameters = new Vector();
    private String om;

    public CIMMethod() {
        this("");
    }

    public CIMMethod(String name) {
        super(name);
    }

    public void setQualifiers(Vector qTable) {
        this.qualifiers = qTable;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            return null;
        }
        int tempIndex = this.qualifiers.indexOf(new CIMQualifier(name));
        CIMQualifier qe = tempIndex >= 0 ? (CIMQualifier)this.qualifiers.elementAt(tempIndex) : null;
        return qe;
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public void setOriginClass(String originClass) {
        this.originClass = originClass == null ? "" : originClass;
    }

    public void setParameters(Vector pTable) {
        this.parameters = pTable;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void setType(CIMDataType type) {
        this.type = type;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setOverridingMethod(String name) {
        this.om = name;
    }

    public String getOverridingMethod() {
        return this.om;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public synchronized Object clone() {
        return this.clone(true, true);
    }

    public synchronized Object clone(boolean includeQualifier, boolean includeClassOrigin) {
        Enumeration e;
        Vector<Object> ov;
        CIMMethod me = new CIMMethod();
        me.name = this.name;
        me.identifier = this.identifier;
        me.type = this.type;
        if (includeClassOrigin) {
            me.originClass = this.originClass;
        }
        me.size = this.size;
        if (this.qualifiers == null || !includeQualifier) {
            me.qualifiers = new Vector();
        } else {
            ov = new Vector<Object>();
            e = this.qualifiers.elements();
            while (e.hasMoreElements()) {
                CIMQualifier qe = (CIMQualifier)e.nextElement();
                ov.addElement(qe.clone());
            }
            me.qualifiers = ov;
        }
        if (this.parameters == null) {
            me.parameters = null;
        } else {
            ov = new Vector();
            e = this.parameters.elements();
            while (e.hasMoreElements()) {
                CIMParameter pe = (CIMParameter)e.nextElement();
                ov.addElement(pe.clone(includeQualifier));
            }
            me.parameters = ov;
        }
        return me;
    }
}

