/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;

public class CIMObjectPath
implements Serializable {
    static final long serialVersionUID = 200L;
    private String nameSpace = "";
    private String objectName = "";
    private Vector keys = new Vector();
    private String host = "";

    private String validateNameSpace(String s) {
        int endindex;
        if (s == null || s.length() == 0) {
            return "";
        }
        boolean startindex = false;
        s = s.replace('/', '\\');
        s = s.toLowerCase();
        StringBuffer sb = new StringBuffer("");
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c != '\\') continue;
            try {
                while (s.charAt(i + 1) == '\\') {
                    ++i;
                }
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        if ((endindex = (s = sb.toString()).length()) > 1 && s.endsWith("\\")) {
            --endindex;
        }
        return s.substring(0, endindex).toLowerCase();
    }

    public CIMObjectPath() {
    }

    public CIMObjectPath(String elementName) {
        this();
        this.objectName = elementName;
    }

    public CIMObjectPath(String elementName, String nameSpace) {
        this(elementName);
        this.nameSpace = this.validateNameSpace(nameSpace);
    }

    public CIMObjectPath(String objectName, Vector keys) {
        this(objectName);
        this.keys = keys;
    }

    public void addKey(String name, CIMValue value) {
        CIMProperty cp = new CIMProperty(name, value);
        try {
            cp.addQualifier(new CIMQualifier("key"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value != null) {
            cp.setType(value.getType());
        }
        this.keys.addElement(cp);
    }

    public Vector getKeys() {
        return this.keys;
    }

    public void setKeys(Vector v) {
        this.keys = v;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void parse(String p) {
        p = p.replace('/', '\\');
        this.nameSpace = this.validateNameSpace(p.substring(0, p.lastIndexOf("\\")));
        this.objectName = p.substring(p.lastIndexOf("\\") + 1, p.length());
    }

    public void setHost(String host) {
        this.host = host == null ? "" : host;
    }

    public void setNameSpace(String ns) {
        this.nameSpace = this.validateNameSpace(ns);
    }

    public void setObjectName(String op) {
        this.objectName = op;
    }

    private String escaped(char in, int nestLevel) {
        int nescapes;
        StringBuffer sb = new StringBuffer();
        for (int i = nescapes = (1 << nestLevel) - 1; i > 0; --i) {
            sb.append('\\');
        }
        sb.append(in);
        return sb.toString();
    }

    private String escapedns(String namespace, int nestLevel) {
        StringBuffer sb = new StringBuffer();
        int size = namespace.length();
        for (int i = 0; i < size; ++i) {
            char ch = namespace.charAt(i);
            if (ch != '\\' && ch != '/') {
                sb.append(ch);
                continue;
            }
            sb.append(this.escaped('\\', nestLevel));
        }
        return sb.toString();
    }

    private String escapedString(String inp, int nestLevel) {
        int nls = nestLevel + 1;
        StringBuffer sb = new StringBuffer();
        String quote = this.escaped('\"', nestLevel);
        sb.append(quote);
        int size = inp.length();
        block9: for (int i = 0; i < size; ++i) {
            char ch = inp.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append(this.escaped('n', nls));
                    continue block9;
                }
                case '\t': {
                    sb.append(this.escaped('t', nls));
                    continue block9;
                }
                case '\b': {
                    sb.append(this.escaped('b', nls));
                    continue block9;
                }
                case '\r': {
                    sb.append(this.escaped('r', nls));
                    continue block9;
                }
                case '\f': {
                    sb.append(this.escaped('f', nls));
                    continue block9;
                }
                case '\\': {
                    sb.append(this.escaped('\\', nls));
                    continue block9;
                }
                case '\"': {
                    sb.append(this.escaped('\"', nls));
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append(quote);
        return sb.toString();
    }

    private String toString(int nestLevel) {
        int nlp = nestLevel - 1;
        String quote = this.escaped('\"', nlp);
        if (this.keys == null || this.keys.size() == 0) {
            if (this.objectName != null && this.objectName.length() != 0) {
                return quote + this.escapedns(this.nameSpace, nestLevel) + ":" + this.objectName + quote;
            }
            return quote + this.escapedns(this.nameSpace, nestLevel) + quote;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Enumeration e = this.keys.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (pe == null) continue;
            sb.append(pe.getName() + "=");
            Object o = null;
            CIMValue cv = null;
            try {
                cv = pe.getValue();
                o = cv.getValue();
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
            if (o instanceof String) {
                sb.append(this.escapedString((String)o, nestLevel));
            } else if (o instanceof CIMObjectPath) {
                sb.append(((CIMObjectPath)o).toString(nestLevel + 1));
            } else if (o instanceof CIMDateTime) {
                String tquote = this.escaped('\"', nestLevel);
                sb.append(tquote + o.toString() + tquote);
            } else {
                sb.append("" + cv);
            }
            sb.append(",");
            ++i;
        }
        if (i > 0) {
            String s = sb.toString();
            return quote + this.escapedns(this.nameSpace, nestLevel) + ":" + this.objectName + "." + s.substring(0, s.lastIndexOf(",")) + quote;
        }
        return quote + this.escapedns(this.nameSpace, nestLevel) + ":" + this.objectName + quote;
    }

    public String toString() {
        return this.toString(1);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean ignoreClassOrigin) {
        if (!(o instanceof CIMObjectPath) || o == null) {
            return false;
        }
        CIMObjectPath inp = (CIMObjectPath)o;
        if (inp.nameSpace == null ? this.nameSpace != null && this.nameSpace.length() != 0 : !inp.nameSpace.equalsIgnoreCase(this.nameSpace)) {
            return false;
        }
        if (inp.objectName == null ? this.objectName != null && this.objectName.length() != 0 : !inp.objectName.equalsIgnoreCase(this.objectName)) {
            return false;
        }
        if (inp.keys == null) {
            if (this.keys != null) {
                return false;
            }
        } else {
            CIMProperty pe;
            int i;
            if (this.keys == null) {
                return false;
            }
            if (inp.keys.size() != this.keys.size()) {
                return false;
            }
            Hashtable<String, CIMProperty> ht = new Hashtable<String, CIMProperty>();
            for (i = 0; i < this.keys.size(); ++i) {
                pe = (CIMProperty)this.keys.elementAt(i);
                if (ignoreClassOrigin) {
                    ht.put(pe.getName().toLowerCase(), pe);
                    continue;
                }
                ht.put(pe.getOriginClass().toLowerCase() + "." + pe.getName().toLowerCase(), pe);
            }
            for (i = 0; i < this.keys.size(); ++i) {
                CIMProperty ipe = (CIMProperty)inp.keys.elementAt(i);
                pe = ignoreClassOrigin ? (CIMProperty)ht.get(ipe.getName().toLowerCase()) : (CIMProperty)ht.get(ipe.getOriginClass().toLowerCase() + "." + ipe.getName().toLowerCase());
                if (pe == null) {
                    return false;
                }
                CIMValue val = pe.getValue();
                CIMValue ival = ipe.getValue();
                if (!(ival == null ? val != null : !ival.equals(val))) continue;
                return false;
            }
        }
        return true;
    }
}

