/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.PasswordAuthentication;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cimxml.XMLParser;
import javax.wbem.cimxml.XmlInstance;
import javax.wbem.cimxml.XmlResponseIF;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Response {
    Response() {
    }

    static Vector getCIMResponse(XmlDocument response) throws IOException, CIMException {
        Vector<Hashtable> responses = new Vector<Hashtable>();
        TreeWalker walker = new TreeWalker((Node)response);
        Node node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.endsWith("SIMPLERSP")) {
                responses.addElement(Response.getSimpleCIMResponse(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            node = walker.getNext();
        }
        return responses;
    }

    private static Hashtable getSimpleCIMResponse(Node response) throws IOException, CIMException {
        XMLParser parser = new XMLParser();
        Vector<Object> v = new Vector<Object>();
        Hashtable simple = new Hashtable(1);
        String method = null;
        String cimtype = null;
        boolean isinvokemethod = false;
        TreeWalker walker = new TreeWalker(response);
        Node node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.endsWith("METHODRESPONSE")) {
                if (nodename.equals("METHODRESPONSE")) {
                    isinvokemethod = true;
                }
                method = ((ElementNode)node).getAttribute("NAME");
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals("ERROR")) {
                int code = Integer.parseInt(((ElementNode)node).getAttribute("CODE"));
                CIMException e = new CIMException();
                v.addElement(new CIMException(e.getXmlCode(code)));
                node = walker.getNext();
                continue;
            }
            if (nodename.equals("CLASS")) {
                v.addElement(XMLParser.getCIMClass(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals("INSTANCE") || nodename.equals("VALUE.NAMEDINSTANCE")) {
                v.addElement(XMLParser.getCIMInstance(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals("CLASSNAME") || nodename.equals("INSTANCENAME")) {
                v.addElement(XMLParser.getCIMObjectPath(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals("VALUE")) {
                v.addElement(XMLParser.getCIMValue(node, cimtype));
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals("VALUE.OBJECTWITHPATH")) {
                NodeList nl = node.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node item = nl.item(i);
                    if ("CLASS".equalsIgnoreCase(item.getNodeName())) {
                        v.addElement(XMLParser.getCIMClass(item));
                        continue;
                    }
                    if (!"INSTANCE".equalsIgnoreCase(item.getNodeName())) continue;
                    v.addElement(XMLParser.getCIMInstance(item));
                }
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals("QUALIFIER.DECLARATION")) {
                v.addElement(XMLParser.getCIMQualifierType(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals("VALUE.ARRAY") || nodename.equals("VALUE.REFERENCE")) {
                v.addElement(XMLParser.getCIMValue(node, cimtype));
                break;
            }
            if (nodename.equals("PARAMVALUE")) {
                v.addElement(Response.getParamValue(node, parser));
                node = walker.getNextElement(nodename);
                continue;
            }
            node = walker.getNextElement(null);
        }
        if (isinvokemethod) {
            Vector<Vector<Object>> v2 = new Vector<Vector<Object>>();
            v2.addElement(v);
            simple.put(method, v2);
        } else {
            simple.put(method, v);
        }
        return simple;
    }

    boolean isMultiRsp(XmlDocument response) {
        TreeWalker walker = new TreeWalker((Node)response);
        Node node = walker.getCurrent();
        while (node != null) {
            if (!node.getNodeName().equals("MULTIRSP")) continue;
            return true;
        }
        return false;
    }

    static XmlDocument getXMLResponse(XmlResponseIF rsp, XmlDocument request, PasswordAuthentication auth) throws IOException, SAXException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)buf, "UTF8");
        XmlInstance xi = new XmlInstance();
        TreeWalker walker = new TreeWalker((Node)request);
        String roottag = "CIM";
        String nodename = null;
        String callname = null;
        String version = null;
        Node node = walker.getCurrent();
        while (node != null) {
            Node item;
            int i;
            NamedNodeMap attrs;
            nodename = node.getNodeName();
            if (nodename.equals(roottag) || nodename.equals("MESSAGE")) {
                attrs = node.getAttributes();
                if (attrs != null) {
                    for (i = 0; i < attrs.getLength(); ++i) {
                        item = attrs.item(i);
                        xi.setAttr(item.getNodeName(), item.getNodeValue());
                        if (!item.getNodeName().equals("CIMVERSION")) continue;
                        version = item.getNodeValue();
                    }
                }
                out.write(xi.stag(nodename));
            } else if (nodename.equals("MULTIREQ")) {
                out.write(xi.stag("MULTIRSP"));
            } else if (nodename.equals("SIMPLEREQ")) {
                out.write(xi.stag("SIMPLERSP"));
            } else if (nodename.equals("IMETHODCALL") || nodename.equals("METHODCALL") || nodename.equals("EXPMETHODCALL")) {
                attrs = node.getAttributes();
                if (attrs != null) {
                    for (i = 0; i < attrs.getLength(); ++i) {
                        item = attrs.item(i);
                        xi.setAttr(item.getNodeName(), item.getNodeValue());
                        callname = item.getNodeName().equals("NAME") ? item.getNodeValue() : callname;
                    }
                }
                String methodtype = nodename.substring(0, nodename.indexOf("CALL"));
                out.write(xi.stag(methodtype + "RESPONSE"));
                if (nodename.equals("EXPMETHODCALL")) {
                    out.write(xi.etag("SIMPLEEXPRSP"));
                } else {
                    if (callname != null) {
                        out.write(rsp.getSimpleXMLResponse(methodtype, callname, node, auth, version));
                    }
                    out.write(xi.etag("SIMPLERSP"));
                }
            } else if (nodename.equals("MULTIEXPREQ")) {
                out.write(xi.stag("MULTIEXPRSP"));
            } else if (nodename.equals("SIMPLEEXPREQ")) {
                out.write(xi.stag("SIMPLEEXPRSP"));
            }
            node = walker.getNext();
        }
        out.write(xi.etag(roottag));
        ((Writer)out).flush();
        return xi.pcdata2Xml(buf.toString());
    }

    static String getError(CIMException e, boolean showImplied) {
        XmlInstance xm = new XmlInstance();
        xm.setShowImplied(showImplied);
        if (e.isXmlCode(e.getID())) {
            xm.setError(e.getXmlCode(e.getID()), e.getID());
        } else {
            xm.setError(1, e.getID());
        }
        return xm.otag("ERROR");
    }

    static String createInstanceResult(CIMObjectPath ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.stag("IRETURNVALUE") + xm.instanceName(ci) + xm.etag();
    }

    static String getClassResult(CIMClass cc, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.stag("IRETURNVALUE") + xm.cimClass(cc) + xm.etag();
    }

    static String getInstanceResult(CIMInstance ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.stag("IRETURNVALUE") + xm.instance(ci) + xm.etag();
    }

    static String getPropertyResult(CIMValue cv, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.stag("IRETURNVALUE") + xm.value(cv) + xm.etag();
    }

    static String enumerateClassesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.cimClass((CIMClass)enum1.nextElement()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String enumerateClassNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.className(((CIMObjectPath)enum1.nextElement()).getObjectName()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String enumerateInstancesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.valueNamedInstance((CIMInstance)enum1.nextElement()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String enumerateInstanceNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.instanceName((CIMObjectPath)enum1.nextElement()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String associatorsResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.valueObjectWithPath(enum1.nextElement()));
        }
        buf.append(xm.etag());
        return buf.toString();
    }

    static String associatorNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.objectPath((CIMObjectPath)enum1.nextElement()));
        }
        buf.append(xm.etag());
        return buf.toString();
    }

    static String referencesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.associatorsResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    static String referenceNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.associatorNamesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    static String enumerateNamespaceResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        String KEY = "key";
        String NAMESPACE = "NameSpace";
        String LOCALNAMESPACEPATH = "LocalNameSpacePath";
        CIMClass ns_class = new CIMClass("__Namespace");
        CIMProperty p = new CIMProperty(LOCALNAMESPACEPATH);
        try {
            p.addQualifier(new CIMQualifier(KEY));
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        ns_class.addProperty(p);
        p = new CIMProperty(NAMESPACE);
        try {
            p.addQualifier(new CIMQualifier(KEY));
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        ns_class.addProperty(p);
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            String ns_name = ((CIMObjectPath)enum1.nextElement()).getNameSpace();
            if (ns_name != null && ns_name.length() > 0) {
                CIMInstance ns_instance = ns_class.newInstance();
                ns_instance.setProperty(LOCALNAMESPACEPATH, new CIMValue("", new CIMDataType(8)));
                ns_instance.setProperty(NAMESPACE, new CIMValue(ns_name, new CIMDataType(8)));
                buf.append(xm.instanceName(ns_instance));
                continue;
            }
            buf.append("");
        }
        buf.append(xm.etag());
        return buf.toString();
    }

    static String getQualifierResult(CIMQualifierType qt, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.stag("IRETURNVALUE") + xm.qualifierDeclaration(qt) + xm.etag();
    }

    static String enumerateQualifiersResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.qualifierDeclaration((CIMQualifierType)enum1.nextElement()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String execQueryResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        buf.append(xm.stag("IRETURNVALUE"));
        while (enum1.hasMoreElements()) {
            buf.append(xm.object(enum1.nextElement()));
        }
        buf.append(xm.etag("IRETURNVALUE"));
        return buf.toString();
    }

    static String invokeMethodResult(Vector v, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        CIMValue cv = (CIMValue)v.elementAt(0);
        buf.append(xm.returnValue(cv));
        for (int i = 1; i < v.size(); ++i) {
            cv = (CIMValue)v.elementAt(i);
            CIMProperty p = new CIMProperty(xm.getCIMType(cv.getType()), cv);
            buf.append(xm.paramValue(p));
        }
        return buf.toString();
    }

    static String invokeArgsMethodResult(Vector v, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        StringBuffer buf = new StringBuffer();
        CIMValue cv = (CIMValue)v.elementAt(0);
        buf.append(xm.returnValue(cv));
        for (int i = 1; i < v.size(); ++i) {
            CIMArgument ca = (CIMArgument)v.elementAt(i);
            buf.append(xm.paramValue(ca));
        }
        return buf.toString();
    }

    private static Object getParamValue(Node node, XMLParser xp) {
        String type = ((ElementNode)node).getAttribute("PARAMTYPE");
        String name = ((ElementNode)node).getAttribute("NAME");
        if (name == null || name.equals("string") || name.equals("char16") || name.equals("datetime") || name.equals("boolean") || name.equals("uint8") || name.equals("uint16") || name.equals("sint16") || name.equals("uint32") || name.equals("sint32") || name.equals("uint64") || name.equals("sint64") || name.equals("real32") || name.equals("real64") || name.equals("reference")) {
            return XMLParser.getCIMValue(node, name);
        }
        return new CIMArgument(name, XMLParser.getCIMValue(node, type));
    }
}

