/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.cimxml.XmlElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XmlInstance
extends XmlElement {
    static final String ARRAYSIZE = "ARRAYSIZE";
    static final String ASSOCIATION = "ASSOCIATION";
    static final String CIMVERSION = "CIMVERSION";
    static final String CIMVERSIONSTRING = "2.0";
    static final String CLASSORIGIN = "CLASSORIGIN";
    static final String CODE = "CODE";
    static final String DESCRIPTION = "DESCRIPTION";
    static final String DTDVERSION = "DTDVERSION";
    static final String DTDVERSIONSTRING = "2.0";
    static final String EMBEDDEDOBJECT = "EmbeddedObject";
    static final String ID = "ID";
    static final String INDICATION = "INDICATION";
    static final String ISARRAY = "ISARRAY";
    static final String METHOD = "METHOD";
    static final String NAME = "NAME";
    static final String OVERRIDABLE = "OVERRIDABLE";
    static final String PARAMETER = "PARAMETER";
    static final String PROTOCOLVERSION = "PROTOCOLVERSION";
    static final String PROTOCOLVERSIONSTRING = "1.0";
    static final String PROPAGATED = "PROPAGATED";
    static final String PROPERTY = "PROPERTY";
    static final String REFERENCE = "REFERENCE";
    static final String REFERENCECLASS = "REFERENCECLASS";
    static final String SUPERCLASS = "SUPERCLASS";
    static final String TOSUBCLASS = "TOSUBCLASS";
    static final String TRANSLATABLE = "TRANSLATABLE";
    static final String TYPE = "TYPE";
    static final String VALUETYPE = "VALUETYPE";
    static final String PARAMTYPE = "PARAMTYPE";
    static final String XMLERROR = "XMLERROR";
    static final String CNAME = "__Namespace";
    private static final String REFERENCETYPE = "reference";
    static final String TRUE = "true";
    static final String FALSE = "false";
    private boolean validate = false;

    public XmlInstance() {
    }

    public XmlInstance(boolean showImplied) {
        super(showImplied);
    }

    public XmlInstance(boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        super(includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public XmlInstance(boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied, boolean showDefault, boolean showHost, boolean showNamespace) {
        super(includeQualifiers, includeClassOrigin, propertyList, showImplied, showDefault, showHost, showNamespace);
    }

    String cloak(String frag) {
        return this.stag("TOXML") + frag + this.etag();
    }

    XmlDocument pcdata2Xml(String pcdata) throws SAXException, IOException {
        InputSource input = new InputSource(new StringReader(pcdata));
        return XmlDocument.createXmlDocument((InputSource)input, (boolean)this.validate);
    }

    String xml2Pcdata(XmlDocument doc) throws IOException {
        StringWriter sw = new StringWriter();
        doc.write((Writer)sw);
        return sw.toString();
    }

    void setCIMName(String name) {
        this.setAttr(NAME, name);
    }

    void setCIMName(CIMElement ce) {
        this.setCIMName(ce.getName());
    }

    void setCIMType(CIMDataType cdt) {
        if (cdt != null && !cdt.isReferenceType()) {
            this.setAttr(TYPE, this.getCIMType(cdt));
        }
    }

    String getCIMType(CIMDataType cdt) {
        String type = null;
        if (cdt == null) {
            return type;
        }
        if (!cdt.isReferenceType()) {
            type = cdt.toString().toLowerCase();
            if (type.indexOf("_") > 0) {
                type = type.substring(0, type.indexOf("_"));
            } else if (type.indexOf("[") > 0) {
                type = type.substring(0, type.indexOf("["));
            }
        } else {
            type = REFERENCETYPE;
        }
        return type;
    }

    void setParamType(CIMDataType cdt) {
        this.setAttr(PARAMTYPE, this.getCIMType(cdt));
    }

    void setQualifierFlavor(CIMQualifier cq) {
        if (cq.hasFlavor(new CIMFlavor(1))) {
            this.setAttr(OVERRIDABLE, FALSE);
        } else if (this.getShowDefault()) {
            this.setAttr(OVERRIDABLE, TRUE);
        }
        if (cq.hasFlavor(new CIMFlavor(2))) {
            this.setAttr(TOSUBCLASS, FALSE);
        } else if (this.getShowDefault()) {
            this.setAttr(TOSUBCLASS, TRUE);
        }
        if (cq.hasFlavor(new CIMFlavor(4))) {
            this.setAttr(TRANSLATABLE, TRUE);
        } else if (this.getShowDefault()) {
            this.setAttr(TRANSLATABLE, FALSE);
        }
    }

    void setClassOrigin(String origin) {
        if (origin != null && (this.getIncludeClassOrigin() || this.getShowImplied())) {
            this.setAttr(CLASSORIGIN, origin);
        }
    }

    void setClassOrigin(CIMProperty cp) {
        if (this.getIncludeClassOrigin() || this.getShowImplied()) {
            this.setClassOrigin(cp.getOriginClass());
        }
    }

    void setClassOrigin(CIMMethod cm) {
        if (this.getIncludeClassOrigin() || this.getShowImplied()) {
            this.setClassOrigin(cm.getOriginClass());
        }
    }

    void setPropagated(boolean propagated) {
        String s;
        String string = s = propagated ? TRUE : FALSE;
        if (this.getShowDefault() || propagated) {
            this.setAttr(PROPAGATED, s);
        }
    }

    void setPropagated(CIMProperty cp, String name) {
        if (name.equals(cp.getOriginClass())) {
            this.setPropagated(false);
        } else {
            this.setPropagated(true);
        }
    }

    void setPropagated(CIMQualifier cq) {
        this.setPropagated(false);
    }

    void setPropagated(CIMMethod cm, String name) {
        if (name.equals(cm.getOriginClass())) {
            this.setPropagated(false);
        } else {
            this.setPropagated(true);
        }
    }

    void setArraySize(int size) {
        if (this.getShowImplied()) {
            this.setAttr(ARRAYSIZE, String.valueOf(size));
        }
    }

    void setSuperClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr(SUPERCLASS, name);
        }
    }

    void setSuperClass(CIMClass cc) {
        String name;
        if (this.getShowImplied() && (name = cc.getSuperClass()).length() != 0) {
            this.setSuperClass(name);
        }
    }

    void setSuperClass(CIMInstance ci) {
        String name;
        if (this.getShowImplied() && (name = ci.getClassName()).length() != 0) {
            this.setSuperClass(name);
        }
    }

    void setClassName(String name) {
        this.setAttr("CLASSNAME", name);
    }

    void setClassName(CIMObjectPath cop) {
        String name = cop.getObjectName();
        if (name.length() != 0) {
            this.setClassName(name);
        }
    }

    void setClassName(CIMInstance ci) {
        String name = ci.getClassName();
        if (name.length() != 0) {
            this.setClassName(name);
        }
    }

    void setReferenceClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr(REFERENCECLASS, name);
        }
    }

    void setReferenceClass(CIMProperty cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    void setReferenceClass(CIMParameter cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    String root(String body) {
        this.setAttr(CIMVERSION, "2.0");
        this.setAttr(DTDVERSION, "2.0");
        return this.stag("CIM") + body + this.etag();
    }

    String value(String pcdata) {
        return this.stag("VALUE") + this.pcdata(pcdata) + this.etag();
    }

    String value(String[] pcdata) {
        StringBuffer Xml = new StringBuffer();
        Xml.append(this.stag("VALUE.ARRAY"));
        for (int i = 0; i < pcdata.length; ++i) {
            Xml.append(this.value(pcdata[i]));
        }
        return Xml.toString() + this.etag();
    }

    String value(boolean value) {
        return this.stag("VALUE") + (value ? "TRUE" : "FALSE") + this.etag();
    }

    String value(CIMValue cv) {
        if (cv == null) {
            return this.stag("VALUE") + this.etag();
        }
        if (cv.isArrayValue()) {
            return this.valueArray(cv);
        }
        return this.stag("VALUE") + this.pcdata(cv) + this.etag();
    }

    String value(Vector values) {
        if (values == null) {
            return "";
        }
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            CIMValue cv = new CIMValue(values.elementAt(i));
            Xml.append(this.value(cv));
        }
        return Xml.toString();
    }

    String value(CIMProperty cp) {
        if (cp.isReference()) {
            return this.valueReference(cp);
        }
        if (cp.getValue() != null) {
            return this.value(cp.getValue());
        }
        return "";
    }

    String value(CIMQualifier cq) {
        String Xml = "";
        if (cq.getValue() != null) {
            Xml = this.value(cq.getValue());
        }
        return Xml;
    }

    String value(CIMArgument cp) {
        if (cp.getType().isReferenceType()) {
            return this.valueReference(cp);
        }
        if (cp.getValue() != null) {
            return this.value(cp.getValue());
        }
        return "";
    }

    String quoted(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            if (pcdata.charAt(i) == '\\' || pcdata.charAt(i) == '\"') {
                buf.append("\\");
            }
            buf.append(pcdata.charAt(i));
        }
        return buf.toString();
    }

    boolean hasMarkup(String pcdata) {
        return pcdata.indexOf("<") != -1 || pcdata.indexOf("&") != -1;
    }

    String cdata(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        block4: for (int i = 0; i < pcdata.length(); ++i) {
            switch (pcdata.charAt(i)) {
                case '<': {
                    buf.append("&lt;");
                    continue block4;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block4;
                }
                default: {
                    buf.append(pcdata.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    String pcdata(String pcdata) {
        String Xml = pcdata;
        if (this.hasMarkup(pcdata)) {
            Xml = this.cdata(pcdata);
        }
        return Xml;
    }

    String pcdata(CIMValue cv) {
        if (cv == null) {
            return "";
        }
        if (cv.getType() != null && cv.getType().isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (cv.getValue() == null) {
            return "";
        }
        Object obj = cv.getValue();
        if (obj instanceof CIMInstance) {
            return this.pcdata(this.quoted(this.instance((CIMInstance)obj)));
        }
        if (obj instanceof CIMClass) {
            return this.pcdata(this.quoted(this.cimClass((CIMClass)obj)));
        }
        return this.pcdata(obj.toString());
    }

    boolean hasMse(String pcdata) {
        return pcdata.indexOf("]]>") > 0;
    }

    String valueArray(CIMValue cv) {
        return this.stag("VALUE.ARRAY") + this.value((Vector)cv.getValue()) + this.etag();
    }

    String valueReference(CIMObjectPath cop) {
        return this.stag("VALUE.REFERENCE") + this.pickObjectName(cop) + this.etag();
    }

    String valueReference(CIMProperty cp) {
        StringBuffer Xml = new StringBuffer();
        CIMValue cv = cp.getValue();
        CIMObjectPath cop = new CIMObjectPath();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        Xml.append(this.valueReference(cop));
        return Xml.toString();
    }

    String valueReference(CIMArgument cp) {
        StringBuffer Xml = new StringBuffer();
        CIMValue cv = cp.getValue();
        CIMObjectPath cop = new CIMObjectPath();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        Xml.append(this.valueReference(cop));
        return Xml.toString();
    }

    String valueRefArray(CIMObjectPath cop) {
        return this.stag("VALUE.REFARRAY") + this.valueReference(cop) + this.etag();
    }

    String valueObject(Object obj) {
        return this.stag("VALUE.OBJECT") + this.object(obj) + this.etag();
    }

    String valueNamedInstance(CIMInstance ci) {
        return this.stag("VALUE.NAMEDINSTANCE") + this.instanceName(ci) + this.instance(ci) + this.etag();
    }

    String valueNamedInstance(CIMObjectPath name, CIMInstance ci) {
        return this.stag("VALUE.NAMEDINSTANCE") + this.instanceName(name) + this.instance(ci) + this.etag();
    }

    String valueNamedObject(Object obj) {
        return this.stag("VALUE.NAMEDOBJECT") + this.namedObject(obj) + this.etag();
    }

    String valueObjectWithLocalPath(Object obj) {
        return this.stag("VALUE.OBJECTWITHLOCALPATH") + this.objectWithLocalPath(obj) + this.etag();
    }

    String valueObjectWithPath(Object obj) {
        return this.stag("VALUE.OBJECTWITHPATH") + this.objectWithPath(obj) + this.etag();
    }

    String pickObjectName(CIMObjectPath cop) {
        if (this.getShowHost()) {
            return this.objectPath(cop, false);
        }
        if (this.getShowNamespace()) {
            return this.localObjectPath(cop);
        }
        return this.objectName(cop);
    }

    String localObjectPath(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.localInstancePath(cop);
        }
        return this.localClassPath(cop);
    }

    String objectName(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.instanceName(cop);
        }
        return this.className(cop);
    }

    String nameSpacePath(CIMObjectPath cop) {
        return this.stag("NAMESPACEPATH") + this.host("localhost") + this.localNameSpacePath(cop) + this.etag();
    }

    String nameSpacePath(CIMNameSpace cns) {
        return this.stag("NAMESPACEPATH") + this.host(cns.getHost()) + this.localNameSpacePath(cns) + this.etag();
    }

    String localNameSpacePath(String ns) {
        StringBuffer Xml = new StringBuffer(this.stag("LOCALNAMESPACEPATH"));
        int i = ns.indexOf("\\");
        while (i >= 0) {
            if (i != 0) {
                Xml.append(this.nameSpace(ns.substring(0, i)));
            }
            ns = ns.substring(i + 1);
            i = ns.indexOf("\\");
        }
        return Xml.toString() + this.nameSpace(ns) + this.etag();
    }

    String localNameSpacePath(CIMNameSpace cns) {
        return this.localNameSpacePath(cns.getNameSpace());
    }

    String localNameSpacePath(CIMObjectPath cop) {
        return this.localNameSpacePath(cop.getNameSpace());
    }

    String host(String name) {
        return this.stag("HOST") + this.pcdata(name) + this.etag();
    }

    String nameSpace(String name) {
        this.setCIMName(name);
        return this.otag("NAMESPACE");
    }

    String classPath(CIMObjectPath cop) {
        return this.stag("CLASSPATH") + this.nameSpacePath(cop) + this.className(cop.getObjectName()) + this.etag();
    }

    String localClassPath(CIMObjectPath cop) {
        return this.stag("LOCALCLASSPATH") + this.localNameSpacePath(cop) + this.className(cop) + this.etag();
    }

    String className(String name) {
        this.setCIMName(name);
        return this.otag("CLASSNAME");
    }

    String className(CIMClass cc) {
        return this.className(cc.getName());
    }

    String className(CIMObjectPath cop) {
        return this.className(cop.getObjectName());
    }

    String instancePath(CIMObjectPath cop) {
        return this.stag("INSTANCEPATH") + this.nameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    String localInstancePath(CIMObjectPath cop) {
        return this.stag("LOCALINSTANCEPATH") + this.localNameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    String instanceName(Vector cp, String name) {
        String keybinding = this.keyBinding(cp);
        this.setClassName(name);
        return this.stag("INSTANCENAME") + keybinding + this.etag();
    }

    String instanceName(CIMObjectPath cop) {
        return this.instanceName(cop.getKeys(), cop.getObjectName());
    }

    String instanceName(CIMInstance ci) {
        return this.instanceName(ci.getKeyValuePairs(), ci.getClassName());
    }

    String objectPath(CIMObjectPath cop) {
        return this.objectPath(cop, true);
    }

    String objectPath(CIMObjectPath cop, boolean includetype) {
        StringBuffer Xml = new StringBuffer();
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            Xml.append(this.instancePath(cop));
        } else {
            Xml.append(this.classPath(cop));
        }
        if (includetype) {
            Xml = new StringBuffer(this.stag("OBJECTPATH") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String keyBinding(CIMProperty cp) {
        this.setCIMName(cp);
        StringBuffer Xml = new StringBuffer(this.stag("KEYBINDING"));
        if (cp.isReference()) {
            Xml.append(this.valueReference(cp));
        } else {
            Xml.append(this.keyValue(cp));
        }
        return Xml.toString() + this.etag();
    }

    String keyBinding(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            if (!(cp.elementAt(i) instanceof CIMProperty)) continue;
            CIMProperty p = (CIMProperty)cp.elementAt(i);
            Xml.append(this.keyBinding(p));
        }
        return Xml.toString();
    }

    void setValueType(CIMDataType cdt) {
        String type = this.getCIMType(cdt);
        if (type == null) {
            return;
        }
        type = type.equals("string") || type.equals("datetime") ? "string" : (type.equals("boolean") ? "boolean" : "numeric");
        this.setAttr(VALUETYPE, type);
    }

    String keyValue(CIMProperty cp) {
        this.setValueType(cp.getType());
        return this.stag("KEYVALUE") + (cp.getValue() == null ? "" : this.pcdata(cp.getValue())) + this.etag();
    }

    String object(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instance((CIMInstance)obj);
        }
        return "";
    }

    String namedObject(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instanceName((CIMInstance)obj) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String objectWithPath(Object obj) {
        if (obj instanceof CIMClass) {
            return this.classPath(new CIMObjectPath()) + this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instancePath(new CIMObjectPath()) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String objectWithLocalPath(Object obj) {
        if (obj instanceof CIMClass) {
            return this.localClassPath(new CIMObjectPath()) + this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            CIMInstance iop = (CIMInstance)obj;
            return this.localInstancePath(iop.getObjectPath()) + this.instance(iop);
        }
        return "";
    }

    String cimClass(CIMClass cc) {
        this.setCIMName(cc);
        this.setSuperClass(cc);
        return this.stag("CLASS") + this.qualifier(cc) + this.property(cc) + this.method(cc) + this.etag("CLASS");
    }

    String instance(CIMInstance ci) {
        this.setClassName(ci);
        return this.stag("INSTANCE") + this.qualifier(ci) + this.property(ci) + this.etag();
    }

    String qualifier(CIMQualifier q) {
        StringBuffer Xml = new StringBuffer();
        if (this.getIncludeQualifiers()) {
            this.setCIMName(q);
            if (q.getValue() != null) {
                this.setCIMType(q.getValue().getType());
            } else {
                CIMDataType cdt = new CIMDataType(8);
                this.setCIMType(cdt);
            }
            this.setPropagated(q);
            this.setQualifierFlavor(q);
            Xml = new StringBuffer(this.stag("QUALIFIER"));
            if (q.getValue() != null) {
                if (q.getValue().isArrayValue()) {
                    Xml.append(this.valueArray(q.getValue()));
                } else {
                    Xml.append(this.value(q.getValue()));
                }
            }
            Xml.append(this.etag("QUALIFIER"));
        }
        return Xml.toString();
    }

    String qualifier(Vector qualifiers) {
        StringBuffer Xml = new StringBuffer();
        if (this.getIncludeQualifiers()) {
            for (int i = 0; i < qualifiers.size(); ++i) {
                Xml.append(this.qualifier((CIMQualifier)qualifiers.elementAt(i)));
            }
        }
        return Xml.toString();
    }

    String qualifier(CIMClass cc) {
        return this.getIncludeQualifiers() ? this.qualifier(cc.getQualifiers()) : "";
    }

    String qualifier(CIMInstance ci) {
        return this.getIncludeQualifiers() ? this.qualifier(ci.getQualifiers()) : "";
    }

    String qualifier(CIMProperty cp) {
        return this.getIncludeQualifiers() ? this.qualifier(cp.getQualifiers()) : "";
    }

    String qualifier(CIMMethod cm) {
        return this.getIncludeQualifiers() ? this.qualifier(cm.getQualifiers()) : "";
    }

    String qualifier(CIMParameter cp) {
        return this.getIncludeQualifiers() ? this.qualifier(cp.getQualifiers()) : "";
    }

    String qualifierDeclaration(CIMQualifierType qt) {
        this.setCIMName(qt.getName());
        this.setCIMType(qt.getType());
        if (this.getShowImplied()) {
            this.setAttr(ISARRAY, qt.isArrayValue() ? TRUE : FALSE);
        }
        this.setQualifierFlavor(new CIMQualifier("", qt));
        return this.stag("QUALIFIER.DECLARATION") + this.scope(qt) + (qt.hasDefaultValue() && qt.getDefaultValue().getValue() != null ? this.value(qt.getDefaultValue()) : "") + this.etag();
    }

    String scope(CIMQualifierType qt) {
        boolean showscope = false;
        if (qt.hasScope(new CIMScope(1))) {
            this.setAttr("CLASS", TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("CLASS", FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(2))) {
            this.setAttr(ASSOCIATION, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(ASSOCIATION, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(3))) {
            this.setAttr(INDICATION, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(INDICATION, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(4))) {
            this.setAttr(PROPERTY, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(PROPERTY, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(5))) {
            this.setAttr(REFERENCE, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(REFERENCE, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(6))) {
            this.setAttr(METHOD, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(METHOD, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(7))) {
            this.setAttr(PARAMETER, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(PARAMETER, FALSE);
            showscope = true;
        }
        return showscope ? this.otag("SCOPE") : "";
    }

    boolean includeProperty(String property) {
        if (this.PropertyList == null) {
            return true;
        }
        if (this.PropertyList.length == 0) {
            return false;
        }
        for (int i = 0; i < this.PropertyList.length; ++i) {
            if (!property.equalsIgnoreCase(this.PropertyList[i])) continue;
            return true;
        }
        return false;
    }

    String property(CIMProperty cp, String name) {
        if (cp.getOverridingProperty() != null) {
            return "";
        }
        if (!this.includeProperty(cp.getName())) {
            return "";
        }
        if (cp.getType().isArrayType()) {
            return this.propertyArray(cp, name);
        }
        if (cp.isReference()) {
            return this.propertyReference(cp, name);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        boolean found = false;
        Vector v = cp.getQualifiers();
        CIMValue cv = cp.getValue();
        if (cv != null && cv.getValue() instanceof CIMInstance) {
            for (int i = 0; i < v.size(); ++i) {
                CIMQualifier q = (CIMQualifier)v.elementAt(i);
                if (!q.getName().equals(EMBEDDEDOBJECT)) continue;
                found = true;
                break;
            }
            if (!found) {
                v.addElement(new CIMQualifier(EMBEDDEDOBJECT));
            }
        }
        return this.stag(PROPERTY) + this.qualifier(v) + this.value(cp) + this.etag();
    }

    String property(Vector p, String name) {
        String refs = "";
        String notrefs = "";
        for (int i = 0; i < p.size(); ++i) {
            CIMProperty cp = (CIMProperty)p.elementAt(i);
            if (cp == null || !this.includeProperty(cp.getName()) || cp.getType() == null) continue;
            if (cp.getType().isReferenceType()) {
                refs = refs + this.propertyReference(cp, name);
                continue;
            }
            notrefs = notrefs + this.property(cp, name);
        }
        return refs + notrefs;
    }

    String property(CIMClass cc) {
        return this.property(cc.getProperties(), cc.getName());
    }

    String property(CIMInstance ci) {
        return this.property(ci.getProperties(), ci.getClassName());
    }

    String propertyArray(CIMProperty cp, String name) {
        StringBuffer Xml = new StringBuffer();
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        Xml.append(this.stag("PROPERTY.ARRAY") + this.qualifier(cp.getQualifiers()));
        if (cp.getValue() != null) {
            Xml.append(this.valueArray(cp.getValue()));
        }
        return Xml.toString() + this.etag();
    }

    String propertyReference(CIMProperty cp, String name) {
        CIMObjectPath cop = new CIMObjectPath(cp.getType().getRefClassName());
        CIMValue cv = cp.getValue();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        return this.stag("PROPERTY.REFERENCE") + this.qualifier(cp) + this.valueReference(cop) + this.etag();
    }

    String method(CIMMethod cm, String name) {
        this.setCIMName(cm);
        this.setCIMType(cm.getType());
        this.setClassOrigin(cm);
        this.setPropagated(cm, name);
        return this.stag(METHOD) + this.qualifier(cm) + this.parameter(cm.getParameters()) + this.etag();
    }

    String method(Vector cms, String name) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cms.size(); ++i) {
            Xml.append(this.method((CIMMethod)cms.elementAt(i), name));
        }
        return Xml.toString();
    }

    String method(CIMClass cc) {
        return this.method(cc.getMethods(), cc.getName());
    }

    String parameter(CIMParameter cp) {
        if (cp.getType().isArrayType()) {
            if (cp.getType().isReferenceType()) {
                return this.parameterRefArray(cp);
            }
            return this.parameterArray(cp);
        }
        if (cp.getType().isReferenceType()) {
            return this.parameterReference(cp);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag(PARAMETER) + this.qualifier(cp) + this.etag();
    }

    String parameter(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            Xml.append(this.parameter((CIMParameter)cp.elementAt(i)));
        }
        return Xml.toString();
    }

    String parameterReference(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag("PARAMETER.REFERENCE") + this.qualifier(cp) + this.etag();
    }

    String parameterArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag("PARAMETER.ARRAY") + this.qualifier(cp) + this.etag();
    }

    String parameterRefArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag("PARAMETER.REFARRAY") + this.qualifier(cp) + this.etag();
    }

    void setError(int code) {
        this.setAttr(CODE, String.valueOf(code));
    }

    void setError(int code, String description) {
        this.setAttr(CODE, String.valueOf(code));
        if (this.getShowImplied()) {
            this.setAttr(DESCRIPTION, description);
        }
    }

    void setId(String cdata) {
        this.setAttr(ID, cdata);
    }

    void setProtocolVersion() {
        this.setAttr(PROTOCOLVERSION, PROTOCOLVERSIONSTRING);
    }

    String message(String body) {
        this.setId(this.getUniqueString());
        this.setProtocolVersion();
        return this.stag("MESSAGE") + body + this.etag();
    }

    String request(String call) {
        return this.stag("SIMPLEREQ") + call + this.etag();
    }

    String request(Vector calls) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < calls.size(); ++i) {
            Xml.append(this.request((String)calls.elementAt(i)));
        }
        if (calls.size() > 1) {
            Xml = new StringBuffer(this.stag("MULTIREQ") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String exprequest(String call) {
        return this.stag("SIMPLEEXPREQ") + call + this.etag();
    }

    String exprequest(Vector calls) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < calls.size(); ++i) {
            Xml.append(this.exprequest((String)calls.elementAt(i)));
        }
        if (calls.size() > 1) {
            Xml = new StringBuffer(this.stag("MULTIEXPREQ") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String call(String name, String body) {
        this.setCIMName(name);
        return this.stag("IMETHODCALL") + body + this.etag();
    }

    String expcall(String name, String body) {
        this.setCIMName(name);
        return this.stag("EXPMETHODCALL") + body + this.etag();
    }

    String xcall(String name, String body) {
        this.setCIMName(name);
        return this.stag("METHODCALL") + body + this.etag();
    }

    String paramValue(CIMProperty p) {
        this.setCIMName(p.getName());
        if (p.getValue().isArrayValue()) {
            if (p.isReference()) {
                return this.stag("PARAMVALUE") + this.stag("VALUE.REFARRAY") + this.value(p) + this.etag("PARAMVALUE");
            }
            return this.stag("PARAMVALUE") + this.value(p) + this.etag("PARAMVALUE");
        }
        return this.stag("PARAMVALUE") + this.value(p) + this.etag();
    }

    String paramValue(Vector params) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < params.size(); ++i) {
            Xml.append(this.paramValue((CIMProperty)params.elementAt(i)));
        }
        return Xml.toString();
    }

    String paramValue(CIMArgument p) {
        this.setCIMName(p.getName());
        this.setParamType(p.getType());
        CIMValue cv = p.getValue();
        if (cv == null) {
            return this.otag("PARAMVALUE");
        }
        if (cv.isArrayValue()) {
            if (p.getType().isReferenceType()) {
                return this.stag("PARAMVALUE") + this.stag("VALUE.REFARRAY") + this.value(p) + this.etag("PARAMVALUE");
            }
            return this.stag("PARAMVALUE") + this.value(p) + this.etag("PARAMVALUE");
        }
        return this.stag("PARAMVALUE") + this.value(p) + this.etag();
    }

    String paramValue(CIMArgument[] params) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Xml.append(this.paramValue(params[i]));
        }
        return Xml.toString();
    }

    String iParamValue(String name, String value) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(value) + this.etag();
    }

    String iParamValue(String name, String[] value) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(value) + this.etag();
    }

    String iParamValue(String name, boolean b) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(b) + this.etag();
    }

    String iParamValue(String name, CIMObjectPath cop) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.objectName(cop) + this.etag();
    }

    String iParamValue(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            this.setCIMName("InstanceName");
        } else {
            this.setCIMName("ClassName");
        }
        return this.stag("IPARAMVALUE") + this.objectName(cop) + this.etag();
    }

    String iParamValue(CIMValue cv) {
        this.setCIMName("NewValue");
        return this.stag("IPARAMVALUE") + this.value(cv) + this.etag();
    }

    String iParamValue(CIMClass cc, String call) {
        if (call.equals("CreateClass")) {
            this.setCIMName("NewClass");
        } else if (call.equals("ModifyClass")) {
            this.setCIMName("ModifiedClass");
        }
        return this.stag("IPARAMVALUE") + this.cimClass(cc) + this.etag();
    }

    String iParamValue(CIMInstance ci) {
        this.setCIMName("NewInstance");
        return this.stag("IPARAMVALUE") + this.instance(ci) + this.etag();
    }

    String iParamValue(CIMObjectPath name, CIMInstance ci) {
        this.setCIMName("ModifiedInstance");
        return this.stag("IPARAMVALUE") + this.valueNamedInstance(name, ci) + this.etag();
    }

    String iParamValue(CIMQualifierType qt) {
        this.setCIMName("QualifierDeclaration");
        return this.stag("IPARAMVALUE") + this.qualifierDeclaration(qt) + this.etag();
    }

    private String response(String[] responses) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < responses.length; ++i) {
            Xml.append(responses[i]);
        }
        if (responses.length > 1) {
            Xml = new StringBuffer(this.stag("MULTIRSP") + Xml.toString() + this.etag());
        }
        this.setId(this.getUniqueString());
        this.setProtocolVersion();
        return this.stag("MESSAGE") + Xml.toString() + this.etag();
    }

    String returnValue(CIMValue cv) {
        this.setParamType(cv.getType());
        return this.stag("RETURNVALUE") + this.value(cv) + this.etag();
    }
}

