/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMCreateClassOp;
import javax.wbem.client.CIMCreateInstanceOp;
import javax.wbem.client.CIMCreateNameSpaceOp;
import javax.wbem.client.CIMCreateQualifierTypeOp;
import javax.wbem.client.CIMDeleteClassOp;
import javax.wbem.client.CIMDeleteInstanceOp;
import javax.wbem.client.CIMDeleteNameSpaceOp;
import javax.wbem.client.CIMDeleteQualifierTypeOp;
import javax.wbem.client.CIMEnumClassNamesOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMEnumNameSpaceOp;
import javax.wbem.client.CIMEnumQualifierTypesOp;
import javax.wbem.client.CIMExecQueryOp;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMGetPropertyOp;
import javax.wbem.client.CIMGetQualifierTypeOp;
import javax.wbem.client.CIMInvokeArgsMethodOp;
import javax.wbem.client.CIMInvokeMethodOp;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSetClassOp;
import javax.wbem.client.CIMSetInstanceOp;
import javax.wbem.client.CIMSetPropertyOp;
import javax.wbem.client.CIMSetQualifierTypeOp;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.adapter.http.Errors;
import javax.wbem.client.adapter.http.HttpEventListener;
import javax.wbem.client.adapter.http.XmlRpcClient;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.security.BasicClientSecurity;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.SecurityToken;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CIMClientXML
extends XmlRpcClient
implements CIMClientAPI {
    private static final String protocol_name = "cim-xml";
    public static final String HTTPPORT = "5988";
    private CIMNameSpace nameSpace;
    private CIMListener clientListener;
    private SecurityToken st = null;
    private String version;
    private HttpClientConnection conn = null;
    private HttpEventListener ls = null;
    private static int debug = 3;
    private boolean retryPost = true;
    private boolean useMPost = true;
    private boolean useChunking = false;
    private static final String LOCALONLY = "LocalOnly";
    private static final String DEEPINHERITANCE = "DeepInheritance";
    private static final String INCLUDEQUALIFIERS = "IncludeQualifiers";
    private static final String INCLUDECLASSORIGIN = "IncludeClassOrigin";
    private static final String PROPERTYLIST = "PropertyList";
    Resolver resolver = new Resolver();
    private static final String SYSTEMID = "http://www.dmtf.org/cim/mapping/xml/v2.0";
    private static final String PUBLICID = "-//DMTF//DTD CIM 2.0//EN";
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private String prefix = "";
    private static final String HANDLERCLASS = "CIM_IndicationHandlerCIMXML";
    private boolean sendDoctype = false;
    private CIMXml xmlImpl;
    private HttpEventListener listener = null;
    private ClassCache cache = new ClassCache();

    public CIMClientXML(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        this.nameSpace = name;
        this.clientListener = clientListener;
        try {
            URL ns;
            if (System.getProperty("remote.connections", "true").equals("false")) {
                ns = new URL("http://127.0.0.1:5988/CIMOM" + version);
            } else {
                ns = name.getHostURL();
                if (ns == null) {
                    ns = new URL("http://" + this.nameSpace.getHost() + ":" + HTTPPORT + "/CIMOM" + version);
                }
            }
            this.setUrl(ns);
        }
        catch (MalformedURLException e3) {
            CIMTransportException e = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
            throw e;
        }
        debug = dbg;
        this.setCheckTypes(System.getProperty("checktypes") != null ? "true".equalsIgnoreCase(System.getProperty("checktypes")) : false);
        this.sendDoctype = System.getProperty("setdoctype") != null ? "true".equalsIgnoreCase(System.getProperty("setdoctype")) : this.sendDoctype;
        this.resolver.registerCatalogEntry(PUBLICID, "javax/wbem/client/cim20.dtd", this.getClass().getClassLoader());
        this.customizeResolver((EntityResolver)this.resolver);
        this.xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    }

    public String getProtocol() {
        return protocol_name;
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        BasicClientSecurity cs = null;
        try {
            cs = (BasicClientSecurity)csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", "Bad credential");
        }
        String username = new String(cs.getUserName());
        String password = cs.getUserPassword();
        Authenticator.setDefault(new HttpAuthenticator(username, password));
    }

    boolean getUseMPost() {
        return this.useMPost;
    }

    void setUseMPost(boolean usempost) {
        this.useMPost = usempost;
        this.retryPost = false;
    }

    XmlDocument call(XmlDocument request) throws CIMException, IOException {
        XmlDocumentBuilder builder;
        OutboundRequest outRequest;
        block23: {
            ValidatingParser parser;
            URL url = this.getUrl();
            if (url == null) {
                throw new IllegalStateException("URL is not set");
            }
            OutputStreamWriter out = null;
            String host = url.getHost();
            int port = url.getPort();
            HttpSocketFactory factory = new HttpSocketFactory(url.getProtocol());
            outRequest = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    if (this.conn == null) {
                        this.conn = new HttpClientConnection(host, port, factory, this.useMPost, this.useChunking);
                    }
                    outRequest = this.conn.newRequest(url.getPath());
                    out = new OutputStreamWriter(outRequest.getRequestOutputStream(), "UTF8");
                    this.setRequestHeaders(outRequest, this.xmlImpl.getXmlRequestHeaders(request));
                    outRequest.endWriteHeader();
                    request.write((Writer)out);
                    ((Writer)out).flush();
                    ((Writer)out).close();
                    break;
                }
                catch (IOException e) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    if (i != 1) continue;
                    throw e;
                }
            }
            if (this.getCheckTypes()) {
                parser = new ValidatingParser();
                parser.setErrorHandler((ErrorHandler)Errors.instance);
            } else {
                parser = new Parser();
                parser.setFastStandalone(true);
            }
            builder = new XmlDocumentBuilder();
            parser.setDocumentHandler((DocumentHandler)builder);
            if (this.resolver == null) {
                this.resolver = new Resolver();
            }
            parser.setEntityResolver((EntityResolver)this.resolver);
            try {
                InputStream contentInput = outRequest.getResponseInputStream();
                InputSource in = Resolver.createInputSource(null, (InputStream)contentInput, (boolean)this.getCheckTypes(), (String)url.getProtocol());
                if (debug == 1 || debug == 3) {
                    this.dumpRequest(request, outRequest);
                }
                if (outRequest.getResponseCode() >= 400) {
                    throw new IOException();
                }
                try {
                    parser.parse(in);
                    contentInput.close();
                }
                catch (SAXException e) {
                    if (debug > 0) {
                        StringBuffer buf = new StringBuffer();
                        Reader r = in.getCharacterStream();
                        int i = 0;
                        while (i >= 0) {
                            buf.append((char)i);
                            i = r.read();
                        }
                        if (debug >= 2) {
                            this.dumpResponse(null, outRequest);
                        }
                        break block23;
                    }
                    throw new CIMException("XMLERROR", (Object)e);
                }
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().startsWith("stream invalid")) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    return this.call(request);
                }
                if (outRequest.getResponseCode() == 401) {
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                if (debug >= 2) {
                    this.dumpResponse(null, outRequest);
                }
                if (outRequest.getResponseCode() == 411 && this.conn.supportsChunking()) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    this.useChunking = false;
                    return this.call(request);
                }
                if (this.retryPost && this.useMPost) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    this.useMPost = false;
                    return this.call(request);
                }
                throw new CIMException("XMLERROR", (Object)e);
            }
        }
        if (debug >= 2) {
            this.dumpResponse(builder.getDocument(), outRequest);
        }
        return builder.getDocument();
    }

    private void setRequestHeaders(OutboundRequest outRequest, Map headers) throws CIMException {
        if (this.useMPost) {
            this.setPrefix();
            outRequest.addHeaderField("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        } else {
            this.prefix = "";
        }
        for (Map.Entry entry : headers.entrySet()) {
            outRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setPrefix() {
        Random generator = new Random();
        int rand = Math.abs(generator.nextInt() % 100);
        this.prefix = Integer.toString(rand);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }

    private void dumpRequest(XmlDocument request, OutboundRequest outRequest) throws IOException {
        System.out.println("****************************************");
        outRequest.dumpOutHeader();
        if (request != null) {
            request.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument response, OutboundRequest outRequest) throws IOException {
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        outRequest.dumpInHeader();
        System.out.println("\n");
        if (response != null) {
            response.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private Vector getResponse(XmlDocument request) throws MalformedURLException, CIMException, IOException {
        if (request == null) {
            throw new CIMException("XMLERROR", "getResponse");
        }
        if (this.sendDoctype) {
            request.setDoctype(PUBLICID, SYSTEMID, null);
        }
        XmlDocument response = this.call(request);
        return this.xmlImpl.getCIMResponse(response);
    }

    private Vector getFirstResponse(String method, XmlDocument request) throws MalformedURLException, CIMException, IOException {
        Vector multi = this.getResponse(request);
        Hashtable simple = (Hashtable)multi.firstElement();
        Vector v = (Vector)simple.get(method);
        if (v.size() > 0 && v.elementAt(0) instanceof CIMException) {
            throw (CIMException)v.elementAt(0);
        }
        Object cs = null;
        Object metakeys = null;
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            this.fixKeytype(iter.next());
        }
        return v;
    }

    private Vector getMultiResponse(XmlDocument request) throws MalformedURLException, CIMException, IOException {
        Vector v = new Vector();
        Vector multi = this.getResponse(request);
        Vector resp = null;
        for (int i = 0; i < multi.size(); ++i) {
            Hashtable simple = (Hashtable)multi.elementAt(i);
            String method = (String)simple.keySet().iterator().next();
            resp = (Vector)simple.get(method);
            if (method.startsWith("Enum") || method.startsWith("Asso") || method.startsWith("Refe") || method.startsWith("ExecQ")) {
                if (resp.size() > 0 && resp.firstElement() instanceof CIMException) {
                    v.addElement(resp.firstElement());
                    continue;
                }
                v.addElement(resp);
                continue;
            }
            try {
                v.addElement(resp.firstElement());
                continue;
            }
            catch (Exception e) {
                v.addElement(null);
            }
        }
        return v;
    }

    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace relNs) throws CIMException {
        try {
            CIMCreateNameSpaceOp cimop = new CIMCreateNameSpaceOp(relNs);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createNameSpace", e);
        }
    }

    public synchronized void close(String version) throws CIMException {
        if (this.conn != null) {
            this.conn.shutdown(true);
        }
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace ns) throws CIMException {
        try {
            CIMDeleteNameSpaceOp cimop = new CIMDeleteNameSpaceOp(ns);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteNameSpace", e);
        }
    }

    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteClassOp cimop = new CIMDeleteClassOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteClass", e);
        }
    }

    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteInstanceOp cimop = new CIMDeleteInstanceOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteInstance", e);
        }
    }

    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteQualifierTypeOp cimop = new CIMDeleteQualifierTypeOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteQualifierType", e);
        }
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        try {
            CIMEnumClassOp cimop = new CIMEnumClassOp(path, deep, localOnly, includeQualifiers, includeClassOrigin);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateClasses", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClasses", e);
        }
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            CIMEnumClassNamesOp cimop = new CIMEnumClassNamesOp(path, deep);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateClassNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClassNames", e);
        }
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            path.setObjectName("__Namespace");
            CIMEnumNameSpaceOp cimop = new CIMEnumNameSpaceOp(path, deep);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumNameSpace", e);
        }
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMEnumInstancesOp cimop = new CIMEnumInstancesOp(path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateInstances", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstances", e);
        }
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMEnumInstanceNamesOp cimop = new CIMEnumInstanceNamesOp(path);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstanceNames", e);
        }
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        Vector<CIMQualifierType> retval = new Vector<CIMQualifierType>();
        try {
            CIMEnumQualifierTypesOp cimop = new CIMEnumQualifierTypesOp(path);
            cimop.setNameSpace(currNs);
            Enumeration e = this.getFirstResponse("EnumerateQualifiers", this.xmlImpl.getXmlRequest(cimop)).elements();
            while (e.hasMoreElements()) {
                retval.addElement((CIMQualifierType)e.nextElement());
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumQualifierTypes", e);
        }
        return retval;
    }

    public synchronized CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMGetClassOp cimop = new CIMGetClassOp(name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetClass", this.xmlImpl.getXmlRequest(cimop));
            return (CIMClass)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getClass", e);
        }
    }

    public synchronized CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMGetInstanceOp cimop = new CIMGetInstanceOp(name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetInstance", this.xmlImpl.getXmlRequest(cimop));
            return (CIMInstance)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getInstance", e);
        }
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector inParams, Vector outParams) throws CIMException {
        try {
            CIMInvokeMethodOp cimop = new CIMInvokeMethodOp(name, methodName, inParams, null);
            cimop.setNameSpace(currNs);
            Vector v = (Vector)this.getFirstResponse(methodName, this.xmlImpl.getXmlRequest(cimop)).firstElement();
            for (int i = 1; i < v.size(); ++i) {
                outParams.addElement(v.elementAt(i));
            }
            return (CIMValue)v.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "invokeMethod", e);
        }
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        try {
            CIMInvokeArgsMethodOp cimop = new CIMInvokeArgsMethodOp(name, methodName, inArgs, null);
            cimop.setNameSpace(currNs);
            Vector v = (Vector)this.getFirstResponse(methodName, this.xmlImpl.getXmlRequest(cimop)).firstElement();
            for (int i = 1; i < v.size(); ++i) {
                outArgs[i - 1] = (CIMArgument)v.elementAt(i);
            }
            return (CIMValue)v.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "invokeMethod", e);
        }
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        try {
            CIMGetQualifierTypeOp cimop = new CIMGetQualifierTypeOp(name);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetQualifier", this.xmlImpl.getXmlRequest(cimop));
            return (CIMQualifierType)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getQualifierType", e);
        }
    }

    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        try {
            CIMCreateQualifierTypeOp cimop = new CIMCreateQualifierTypeOp(name, qt);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("CreateQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createQualifierType", e);
        }
    }

    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            CIMCreateClassOp cimop = new CIMCreateClassOp(name, cc);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("CreateClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createClass", e);
        }
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        try {
            CIMCreateInstanceOp cimop = new CIMCreateInstanceOp(name, ci);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cimop));
            return (CIMObjectPath)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createInstance", e);
        }
    }

    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        try {
            CIMSetQualifierTypeOp cimop = new CIMSetQualifierTypeOp(name, qt);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("SetQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setQualifierType", e);
        }
    }

    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            CIMSetClassOp cimop = new CIMSetClassOp(name, cc);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("ModifyClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setClass", e);
        }
    }

    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
        try {
            CIMSetInstanceOp cimop = new CIMSetInstanceOp(name, ci, includeQualifier, propertyList);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("ModifyInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setInstance", e);
        }
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        try {
            CIMGetPropertyOp cimop = new CIMGetPropertyOp(name, propertyName);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetProperty", this.xmlImpl.getXmlRequest(cimop));
            return (CIMValue)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getProperty", e);
        }
    }

    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        try {
            CIMSetPropertyOp cimop = new CIMSetPropertyOp(name, propertyName, cv);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("SetProperty", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setProperty", e);
        }
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, String ql) throws CIMException {
        try {
            CIMExecQueryOp cimop = new CIMExecQueryOp(relNS, query, ql);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("ExecQuery", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "execQuery", e);
        }
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMAssociatorsOp cimop = new CIMAssociatorsOp(objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("Associators", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associators", e);
        }
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        try {
            CIMAssociatorNamesOp cimop = new CIMAssociatorNamesOp(objectName, assocClass, resultClass, role, resultRole);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("AssociatorNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associatorNames", e);
        }
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMReferencesOp cimop = new CIMReferencesOp(objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("References", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "references", e);
        }
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        try {
            CIMReferenceNamesOp cimop = new CIMReferenceNamesOp(objectName, resultClass, role);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("ReferenceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "referenceNames", e);
        }
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        try {
            return this.getMultiResponse(this.xmlImpl.getXmlRequest(batchedOperations));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "performOperations", e);
        }
    }

    public void setListener(String version) throws CIMException {
        try {
            this.listener = new HttpEventListener(this.clientListener);
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setListener", e);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        int port;
        String host;
        if (cl != null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        try {
            host = this.listener.getHost();
            port = this.listener.getPort();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
        CIMClass cc = this.getClass(this.version, this.nameSpace, new CIMObjectPath(HANDLERCLASS), false, true, false, null);
        CIMInstance ci = cc.newInstance();
        ci.setProperty("Name", new CIMValue(new Date().toString()));
        ci.setProperty("SystemName", new CIMValue(""));
        ci.setProperty("SystemCreationClassName", new CIMValue("solaris_computersystem"));
        ci.setProperty("CreationClassName", new CIMValue(""));
        ci.setProperty("Destination", new CIMValue("http://" + host + ":" + port));
        ci.setProperty("Owner", new CIMValue(""));
        return ci;
    }

    private void fixKeytype(Object o) throws CIMException {
        if (o == null) {
            return;
        }
        if (o instanceof CIMObjectPath) {
            this.fixCIMOjbectPath((CIMObjectPath)o);
        } else if (o instanceof CIMInstance) {
            this.fixCIMInstance((CIMInstance)o);
        }
    }

    private void fixCIMInstance(CIMInstance inst) throws CIMException {
        Vector v = inst.getProperties();
        this.fixCIMProperties(v);
    }

    private void fixCIMClass(CIMClass cs) throws CIMException {
        Vector v = cs.getAllProperties();
        String className = cs.getName();
        this.cache.get(className);
        this.fixCIMProperties(v);
    }

    private void fixCIMProperties(Vector v) throws CIMException {
        if (v == null || v.size() == 0) {
            return;
        }
        for (CIMProperty cp : v) {
            CIMValue value;
            CIMDataType type;
            if (cp == null || (type = cp.getType()) == null || (value = cp.getValue()) == null || !type.isReferenceType()) continue;
            Object o = value.getValue();
            this.fixKeytype(o);
        }
    }

    private static boolean isFixNeeded(CIMObjectPath path) {
        Vector keys = path.getKeys();
        if (keys == null || keys.size() == 0) {
            return false;
        }
        for (CIMProperty cp : keys) {
            if (cp.getValue() == null) continue;
            return true;
        }
        return false;
    }

    private void fixCIMOjbectPath(CIMObjectPath path) throws CIMException {
        if (CIMClientXML.isFixNeeded(path)) {
            String className = path.getObjectName();
            CIMProperty[] metakeys = this.cache.get(className);
            CIMClientXML.fixInstanceName(path, metakeys);
        }
    }

    public static void fixInstanceName(CIMObjectPath path, CIMProperty[] metakeys) {
        Vector v = path.getKeys();
        if (v == null || v.size() == 0) {
            return;
        }
        CIMProperty[] keys = new CIMProperty[v.size()];
        v.toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            CIMClientXML.fixInstancekeyProperty(keys[i], metakeys);
        }
    }

    private static void fixInstancekeyProperty(CIMProperty p, CIMProperty[] metakeys) {
        String name = p.getName();
        for (int i = 0; i < metakeys.length; ++i) {
            if (!p.getName().equals(metakeys[i].getName())) continue;
            CIMClientXML.convertType(p, metakeys[i].getType());
        }
    }

    private static void convertType(CIMProperty p, CIMDataType type) {
        Object value;
        if (p == null) {
            return;
        }
        String cimtype = type.toString();
        if (p != null && p.getValue() != null && (value = p.getValue().getValue()) instanceof String) {
            String strVal = (String)value;
            Object o = CIMClientXML.valueObject(strVal, cimtype);
            p.setValue(new CIMValue(o));
            p.setType(type);
        }
    }

    private static Object valueObject(String value, String type) {
        Object o = null;
        type = type.length() > 0 ? type : "string";
        int radix = 10;
        if (type.startsWith("sint") && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || type.startsWith("uint") && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            String string = value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        if (type.equals("boolean")) {
            o = Boolean.valueOf(value);
        } else if (type.equals("char16")) {
            o = new Character(value.charAt(0));
        } else if (type.equals("datetime")) {
            o = new CIMDateTime(value);
        } else if (type.equals("real32")) {
            o = new Float(value);
        } else if (type.equals("real64")) {
            o = new Double(value);
        } else if (type.equals("sint16")) {
            o = Short.valueOf(value, radix);
        } else if (type.equals("sint32")) {
            o = Integer.valueOf(value, radix);
        } else if (type.equals("sint64")) {
            o = Long.valueOf(value, radix);
        } else if (type.equals("sint8")) {
            o = Byte.valueOf(value, radix);
        } else if (type.equals("string")) {
            o = value == null ? "" : new String(value);
        } else if (type.equals("uint16")) {
            o = new UnsignedInt16(Integer.valueOf(value, radix));
        } else if (type.equals("uint32")) {
            o = new UnsignedInt32(Long.valueOf(value, radix));
        } else if (type.equals("uint64")) {
            o = new UnsignedInt64(new BigInteger(value, radix));
        } else if (type.equals("uint8")) {
            o = new UnsignedInt8(Short.valueOf(value, radix));
        } else if (value.indexOf("e") > 0 || value.indexOf("E") > 0) {
            o = new Double(value);
        } else if (value.startsWith("+") || value.startsWith("-")) {
            o = new Long(value);
        }
        return o;
    }

    private class ClassCache {
        private HashMap classCache = new HashMap();
        private ArrayList classCacheNames = new ArrayList();
        private static final int CACHE_SIZE = 200;

        private ClassCache() {
        }

        public CIMProperty[] get(String className) throws CIMException {
            CIMProperty[] metakeys = (CIMProperty[])this.classCache.get(className);
            if (metakeys == null) {
                metakeys = this.add(className);
            }
            return metakeys;
        }

        private CIMProperty[] add(String className) throws CIMException {
            CIMClass cs = CIMClientXML.this.getClass("", CIMClientXML.this.nameSpace, new CIMObjectPath(className), false, true, false, null);
            Vector kv = cs.getKeys();
            if (kv == null) {
                kv = new Vector(0);
            }
            CIMProperty[] metakeys = new CIMProperty[kv.size()];
            kv.toArray(metakeys);
            if (this.classCacheNames.size() == 200) {
                String csName = (String)this.classCacheNames.remove(0);
                this.classCache.remove(csName);
            }
            this.classCache.put(className, metakeys);
            this.classCacheNames.add(className);
            return metakeys;
        }
    }

    private static class HttpAuthenticator
    extends Authenticator {
        private String username;
        private char[] password;

        HttpAuthenticator(String username, String password) {
            this.username = username;
            this.password = password.toCharArray();
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

