/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpParseException;

class Header {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    private HashMap fields = new HashMap(5);
    private String text;

    Header() {
    }

    Header(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        String line = din.readLine();
        this.text = "";
        while (line != null && line.length() > 0) {
            String next = din.readLine();
            while (next != null && next.length() > 0 && Header.isSpaceOrTab(next.charAt(0))) {
                line = line + next;
                next = din.readLine();
            }
            int sepidx = line.indexOf(58);
            if (sepidx < 0) {
                throw new HttpParseException("header line missing separator");
            }
            String name = line.substring(0, sepidx).trim();
            String value = line.substring(sepidx + 1).trim();
            if (name.length() == 0) {
                throw new HttpParseException("invalid header field name");
            }
            this.addField(name, value);
            this.text = this.text + name + " : " + value + "\n";
            line = next;
        }
        Debug.trace1(this.text);
    }

    String getField(String name) {
        return (String)this.fields.get(new FieldKey(name));
    }

    void setField(String name, String value) {
        FieldKey key = new FieldKey(name);
        if (value != null) {
            this.fields.put(key, value);
        } else {
            this.fields.remove(key);
        }
    }

    boolean containsValue(String name, String value, boolean ignoreCase) {
        String vlist = this.getField(name);
        if (vlist != null) {
            value = value.trim();
            StringTokenizer tok = new StringTokenizer(vlist, ",");
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken().trim();
                if (!(ignoreCase ? value.equalsIgnoreCase(v) : value.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    int size() {
        return this.fields.size();
    }

    void merge(Header header) {
        if (header != null) {
            for (Map.Entry e : header.fields.entrySet()) {
                this.addField(((FieldKey)e.getKey()).name, (String)e.getValue());
            }
        }
    }

    void write(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        for (Map.Entry e : this.fields.entrySet()) {
            dout.writeBytes(((FieldKey)e.getKey()).name + ": " + (String)e.getValue() + "\r\n");
        }
        dout.writeBytes("\r\n");
    }

    static String getDateString(long time) {
        return dateFormat.format(new Date(time));
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private void addField(String name, String value) {
        if (value != null) {
            FieldKey key = new FieldKey(name);
            String oldv = (String)this.fields.get(key);
            String newv = oldv != null ? oldv + ", " + value : value;
            this.fields.put(key, newv);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static final class FieldKey {
        final String name;
        private int hash;

        FieldKey(String name) {
            this.name = name;
            this.hash = name.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FieldKey) {
                return this.name.equalsIgnoreCase(((FieldKey)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

