/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.wbem.client.adapter.http.transport.ServerInfo;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public class HttpClientManager {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private Map rolodex = new HashMap(5);

    public void clearServerInfo() {
        this.rolodex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo getServerInfo(String host, int port) {
        ServerKey key = new ServerKey(host, port);
        Map map = this.rolodex;
        synchronized (map) {
            ServerInfo info = (ServerInfo)this.rolodex.get(key);
            return info != null ? (ServerInfo)info.clone() : new ServerInfo(host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheServerInfo(ServerInfo info) {
        if (info.timestamp == -1L) {
            return;
        }
        ServerKey key = new ServerKey(info.host, info.port);
        Map map = this.rolodex;
        synchronized (map) {
            ServerInfo oldInfo = (ServerInfo)this.rolodex.get(key);
            if (oldInfo == null || info.timestamp > oldInfo.timestamp) {
                this.rolodex.put(key, info.clone());
            }
        }
    }

    private static final class ServerKey {
        private String host;
        private int port;
        private int hash;

        ServerKey(String host, int port) {
            this.host = host;
            this.port = port;
            this.hash = host.hashCode() << 10 | port & 0x3FF;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServerKey) {
                ServerKey key = (ServerKey)obj;
                return this.host.equals(key.host) && this.port == key.port;
            }
            return false;
        }
    }
}

