/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.wbem.client.adapter.http.transport.ConnectionTimer;
import javax.wbem.client.adapter.http.transport.HttpServerConnection;
import javax.wbem.client.adapter.http.transport.HttpSettings;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.wbem.client.adapter.http.transport.ServerEndpointListener;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public final class HttpServerEndpoint {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final ConnectionTimer connTimer;
    private final String h;
    private int p;

    public HttpServerEndpoint(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        this.h = System.getProperty("remote.connections").equals("false") ? "127.0.0.1" : host;
        this.p = port;
    }

    public String getHost() {
        return this.h;
    }

    public int getPort() {
        return this.p;
    }

    public ServerEndpointListener listen(RequestHandler handler) throws IOException {
        ServerSocket ssock;
        if (handler == null) {
            throw new NullPointerException();
        }
        try {
            ssock = System.getProperty("remote.connections").equals("false") ? new ServerSocket(this.p, 10, InetAddress.getByName(null)) : new ServerSocket(this.p);
        }
        catch (Exception e) {
            e.printStackTrace();
            ssock = new ServerSocket(this.p);
        }
        Listener listener = new Listener(handler, ssock);
        systemThreadPool.execute((Runnable)listener, "HttpServerEndpoint Accept (port " + this.p + ")");
        return listener;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpServerEndpoint) {
            HttpServerEndpoint other = (HttpServerEndpoint)obj;
            return this.h.equals(other.h) && this.p == other.p;
        }
        return false;
    }

    public String toString() {
        return "HttpServerEndpoint[" + this.h + ":" + this.p + "]";
    }

    static {
        HttpSettings hs = HttpSettings.getHttpSettings();
        connTimer = new ConnectionTimer(hs.getConnectionTimeout(15000L));
    }

    private final class Connection
    extends HttpServerConnection {
        private Socket sock;
        Listener listener;

        Connection(Socket sock, RequestHandler handler, Listener listener) throws IOException {
            super(sock, handler);
            this.sock = sock;
            this.listener = listener;
            this.start();
        }

        protected void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                String host = this.sock.getInetAddress().getHostAddress();
                sm.checkAccept(host, this.sock.getPort());
            }
        }

        protected String getClientHost() {
            InetAddress addr = this.sock.getInetAddress();
            return addr != null ? addr.getHostAddress() : "0.0.0.0";
        }

        protected void idle() {
            connTimer.scheduleTimeout(this, false);
        }

        protected void busy() {
            connTimer.cancelTimeout(this);
        }

        public boolean shutdown(boolean force) {
            if (super.shutdown(force)) {
                connTimer.cancelTimeout(this);
                this.listener.connectionClosed(this);
            }
            return false;
        }
    }

    private final class Listener
    implements Runnable,
    ServerEndpointListener {
        private final RequestHandler handler;
        private final ServerSocket ssock;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private boolean closed = false;
        private final Set connections = new HashSet(5);

        private Listener(RequestHandler handler, ServerSocket ssock) {
            this.handler = handler;
            this.ssock = ssock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object[] conns;
            Set set = this.connections;
            synchronized (set) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                conns = this.connections.toArray();
            }
            try {
                this.ssock.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            for (int i = 0; i < conns.length; ++i) {
                ((Connection)conns[i]).shutdown(true);
            }
        }

        public void run() {
            this.executeAcceptLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAcceptLoop() {
            try {
                while (true) {
                    Socket sock = this.ssock.accept();
                    try {
                        sock.setTcpNoDelay(true);
                    }
                    catch (SocketException e) {
                        // empty catch block
                    }
                    try {
                        sock.setKeepAlive(true);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    Set set = this.connections;
                    synchronized (set) {
                        if (this.closed) {
                            try {
                                sock.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            this.connections.add(new Connection(sock, this.handler, this));
                        }
                    }
                }
            }
            catch (Throwable th) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectionClosed(Connection conn) {
            Set set = this.connections;
            synchronized (set) {
                this.connections.remove(conn);
            }
        }

        public int getLocalPort() {
            return this.ssock.getLocalPort();
        }
    }
}

