/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wbem.client.adapter.http.transport.HttpParseException;
import sun.misc.BASE64Encoder;

final class ServerInfo
implements Cloneable {
    static final long NO_TIMESTAMP = -1L;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    final String host;
    final int port;
    int major = 1;
    int minor = 0;
    String authScheme;
    String authRealm;
    String authAlgorithm;
    String authOpaque;
    String authNonce;
    String authUser;
    String authPassword;
    long timestamp = -1L;

    ServerInfo(String host, int port) {
        this.host = host;
        this.port = port;
    }

    void setAuthInfo(String str) throws HttpParseException {
        String realm;
        if (str == null || str.length() == 0) {
            this.authScheme = null;
            this.authRealm = null;
            this.authAlgorithm = null;
            this.authOpaque = null;
            this.authNonce = null;
            this.authUser = null;
            this.authPassword = null;
            return;
        }
        LineParser lp = new LineParser(str);
        HashMap entries = lp.getEntries("Digest");
        if (entries != null) {
            realm = (String)entries.get("realm");
            String nonce = (String)entries.get("nonce");
            if (realm != null && nonce != null) {
                this.authScheme = "Digest";
                this.authRealm = realm;
                this.authNonce = nonce;
                this.authAlgorithm = (String)entries.get("algorithm");
                this.authOpaque = (String)entries.get("opaque");
                if (!"true".equalsIgnoreCase((String)entries.get("stale"))) {
                    this.authUser = null;
                    this.authPassword = null;
                }
                return;
            }
        }
        if ((entries = lp.getEntries("Basic")) != null && (realm = (String)entries.get("realm")) != null) {
            this.authScheme = "Basic";
            this.authRealm = realm;
            this.authAlgorithm = null;
            this.authOpaque = null;
            this.authNonce = null;
            this.authUser = null;
            this.authPassword = null;
            return;
        }
    }

    void updateAuthInfo(String str) throws HttpParseException {
        LineParser lp;
        HashMap entries;
        String nextNonce;
        if (str == null || str.length() == 0) {
            return;
        }
        if ("Digest".equals(this.authScheme) && (nextNonce = (String)(entries = (lp = new LineParser(str)).getAllEntries()).get("nextnonce")) != null) {
            this.authNonce = nextNonce;
        }
    }

    String getAuthString(String protocol, String method, String uri) {
        if (this.authScheme == null) {
            return null;
        }
        if (this.authUser == null) {
            PasswordAuthentication pa = this.getPassword(protocol);
            if (pa == null) {
                return null;
            }
            String user = pa.getUserName();
            char[] password = pa.getPassword();
            if (user == null || password == null) {
                return null;
            }
            this.authUser = user;
            this.authPassword = new String(password);
        }
        if (this.authScheme.equals("Basic")) {
            BASE64Encoder enc = new BASE64Encoder();
            return "Basic " + enc.encode((this.authUser + ":" + this.authPassword).getBytes());
        }
        if (this.authScheme.equals("Digest")) {
            String digest;
            try {
                digest = this.computeDigest(method, uri);
            }
            catch (NoSuchAlgorithmException ex) {
                return null;
            }
            String response = "Digest username=\"" + this.authUser + "\", " + "realm=\"" + this.authRealm + "\", " + "nonce=\"" + this.authNonce + "\", " + "uri=\"" + uri + "\", " + "response=\"" + digest + "\"";
            if (this.authOpaque != null) {
                response = response + ", opaque=\"" + this.authOpaque + "\"";
            }
            if (this.authAlgorithm != null) {
                response = response + ", algorithm=" + this.authAlgorithm;
            }
            return response;
        }
        throw new InternalError();
    }

    private String computeDigest(String method, String uri) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(this.authAlgorithm != null ? this.authAlgorithm : "MD5");
        String hashA1 = this.encode(md, this.authUser + ":" + this.authRealm + ":" + this.authPassword);
        String hashA2 = this.encode(md, method + ":" + uri);
        return this.encode(md, hashA1 + ":" + this.authNonce + ":" + hashA2);
    }

    private String encode(MessageDigest md, String str) {
        md.reset();
        md.update(str.getBytes());
        byte[] digest = md.digest();
        StringBuffer sbuf = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            sbuf.append(hexChars[digest[i] >>> 4 & 0xF]);
            sbuf.append(hexChars[digest[i] & 0xF]);
        }
        return sbuf.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private PasswordAuthentication getPassword(final String protocol) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(ServerInfo.this.host);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                return Authenticator.requestPasswordAuthentication(addr, ServerInfo.this.port, protocol, ServerInfo.this.authRealm, ServerInfo.this.authScheme);
            }
        });
    }

    private static final class LineParser {
        private static final int EOL = -1;
        private static final int WORD = 0;
        private static final int QUOTE = 1;
        private static final int COMMA = 2;
        private static final int EQUALS = 3;
        private char[] ca;
        private int pos = 0;
        private String tokenString = null;
        ArrayList entries = new ArrayList();

        LineParser(String line) throws HttpParseException {
            this.ca = line.toCharArray();
            int tok = this.nextToken();
            while (tok != -1) {
                if (tok == 2) {
                    tok = this.nextToken();
                    continue;
                }
                if (tok != 0) {
                    throw new HttpParseException("illegal key");
                }
                String key = this.tokenString;
                tok = this.nextToken();
                if (tok == 2) {
                    this.entries.add(new String[]{key, null});
                    tok = this.nextToken();
                    continue;
                }
                if (tok != 3) {
                    this.entries.add(new String[]{key, null});
                    continue;
                }
                tok = this.nextToken();
                if (tok != 0 && tok != 1) {
                    throw new HttpParseException("illegal value");
                }
                this.entries.add(new String[]{key, this.tokenString});
                tok = this.nextToken();
                if (tok == 2) {
                    tok = this.nextToken();
                    continue;
                }
                if (tok == -1) continue;
                throw new HttpParseException("illegal separator");
            }
        }

        private int nextToken() throws HttpParseException {
            char c;
            while (this.pos < this.ca.length && Character.isWhitespace(this.ca[this.pos])) {
                ++this.pos;
            }
            if (this.pos >= this.ca.length) {
                return -1;
            }
            switch (this.ca[this.pos]) {
                case ',': {
                    ++this.pos;
                    return 2;
                }
                case '=': {
                    ++this.pos;
                    return 3;
                }
                case '\"': {
                    int mark = ++this.pos;
                    while (this.pos < this.ca.length && this.ca[this.pos] != '\"') {
                        ++this.pos;
                    }
                    if (this.pos >= this.ca.length) {
                        throw new HttpParseException("unterminated quote string");
                    }
                    this.tokenString = new String(this.ca, mark, this.pos++ - mark);
                    return 1;
                }
            }
            int mark = this.pos;
            while (this.pos < this.ca.length && (c = this.ca[this.pos]) != ',' && c != '=' && c != '\"' && !Character.isWhitespace(c)) {
                ++this.pos;
            }
            this.tokenString = new String(this.ca, mark, this.pos - mark);
            return 0;
        }

        HashMap getEntries(String scheme) {
            int i;
            HashMap<String, String> map = null;
            String[][] ea = (String[][])this.entries.toArray((T[])new String[this.entries.size()][]);
            for (i = 0; i < ea.length; ++i) {
                if (ea[i][1] != null || !scheme.equalsIgnoreCase(ea[i][0])) continue;
                map = new HashMap<String, String>();
                break;
            }
            if (map != null) {
                ++i;
                while (i < ea.length && ea[i][1] != null) {
                    map.put(ea[i][0].toLowerCase(), ea[i][1]);
                    ++i;
                }
            }
            return map;
        }

        HashMap getAllEntries() {
            HashMap<String, String> map = new HashMap<String, String>();
            String[][] ea = (String[][])this.entries.toArray((T[])new String[this.entries.size()][]);
            for (int i = 0; i < ea.length; ++i) {
                map.put(ea[i][0].toLowerCase(), ea[i][1]);
            }
            return map;
        }
    }
}

