/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.wbem.client.adapter.http.transport.HttpParseException;

final class StartLine {
    final int major;
    final int minor;
    final boolean isRequest;
    final String method;
    final String uri;
    final int status;
    final String reason;

    StartLine(int major, int minor, String method, String uri) {
        this.major = major;
        this.minor = minor;
        this.method = method;
        this.uri = uri;
        this.status = -1;
        this.reason = null;
        this.isRequest = true;
    }

    StartLine(int major, int minor, int status, String reason) {
        this.major = major;
        this.minor = minor;
        this.status = status;
        this.reason = reason;
        this.method = null;
        this.uri = null;
        this.isRequest = false;
    }

    StartLine(InputStream in) throws IOException {
        String line = new DataInputStream(in).readLine();
        if (line == null) {
            throw new HttpParseException("unexpected EOF in start line");
        }
        if (line.length() == 0) {
            throw new HttpParseException("empty start line");
        }
        try {
            StringTokenizer tok = new StringTokenizer(line, "", true);
            if (line.startsWith("HTTP")) {
                if (!tok.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                tok.nextToken();
                this.major = Integer.parseInt(tok.nextToken("."));
                tok.nextToken();
                this.minor = Integer.parseInt(tok.nextToken(" "));
                tok.nextToken();
                this.status = Integer.parseInt(tok.nextToken());
                tok.nextToken();
                this.reason = tok.nextToken("\n");
                this.method = null;
                this.uri = null;
                this.isRequest = false;
            } else {
                this.method = tok.nextToken(" ");
                tok.nextToken();
                this.uri = tok.nextToken();
                tok.nextToken();
                if (!tok.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                tok.nextToken();
                this.major = Integer.parseInt(tok.nextToken("."));
                tok.nextToken();
                this.minor = Integer.parseInt(tok.nextToken("\n"));
                this.status = -1;
                this.reason = null;
                this.isRequest = true;
            }
        }
        catch (Exception ex) {
            throw new HttpParseException("invalid start line");
        }
    }

    void write(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        String version = "HTTP/" + this.major + "." + this.minor;
        if (this.isRequest) {
            dout.writeBytes(this.method + " " + this.uri + " " + version + "\r\n");
        } else {
            dout.writeBytes(version + " " + this.status + " " + this.reason + "\r\n");
        }
    }

    static int compareVersions(int major1, int minor1, int major2, int minor2) {
        if (major1 != major2) {
            return major1 > major2 ? 1 : -1;
        }
        if (minor1 != minor2) {
            return minor1 > minor2 ? 1 : -1;
        }
        return 0;
    }
}

