/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.query;

import java.math.BigDecimal;
import java.text.StringCharacterIterator;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.QueryExp;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;

public class BinaryRelQueryExp
extends QueryExp {
    private int relOp;
    private ValueExp expOne;
    private ValueExp expTwo;

    public BinaryRelQueryExp(int op, ValueExp v1, ValueExp v2) {
        this.relOp = op;
        this.expOne = v1;
        this.expTwo = v2;
    }

    public BinaryRelQueryExp() {
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.expOne;
    }

    public ValueExp getRightValue() {
        return this.expTwo;
    }

    public boolean apply(CIMElement obj) throws CIMException {
        return this.doApply(this.expOne.apply(obj), this.expTwo.apply(obj));
    }

    private boolean doApply(Object val1, Object val2) throws CIMException {
        boolean numeric = val1 instanceof NumericValue;
        if (val1 == null || val2 == null) {
            return false;
        }
        if (numeric) {
            BigDecimal bdval1 = new BigDecimal(val1.toString());
            BigDecimal bdval2 = new BigDecimal(val2.toString());
            switch (this.relOp) {
                case 0: {
                    return bdval1.compareTo(bdval2) > 0;
                }
                case 1: {
                    return bdval1.compareTo(bdval2) < 0;
                }
                case 2: {
                    return bdval1.compareTo(bdval2) >= 0;
                }
                case 3: {
                    return bdval1.compareTo(bdval2) <= 0;
                }
                case 4: {
                    return bdval1.compareTo(bdval2) == 0;
                }
                case 5: {
                    return bdval1.compareTo(bdval2) != 0;
                }
            }
        }
        if (val1 instanceof DateTimeExp || val2 instanceof DateTimeExp) {
            if (!(val1 instanceof DateTimeExp)) {
                try {
                    val1 = new DateTimeExp(((StringValueExp)val1).getValue());
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", val1.toString());
                }
            }
            CIMDateTime dtval1 = ((DateTimeExp)val1).getValue();
            if (!(val2 instanceof DateTimeExp)) {
                try {
                    val2 = new DateTimeExp(((StringValueExp)val2).getValue());
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", val2.toString());
                }
            }
            CIMDateTime dtval2 = ((DateTimeExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return dtval1.after(dtval2);
                }
                case 1: {
                    return dtval1.before(dtval2);
                }
                case 2: {
                    return dtval1.after(dtval2) || dtval1.equals(dtval2);
                }
                case 3: {
                    return dtval1.before(dtval2) || dtval1.equals(dtval2);
                }
                case 4: {
                    return dtval1.equals(dtval2);
                }
                case 5: {
                    return !dtval1.equals(dtval2);
                }
            }
        } else {
            String sval1 = ((StringValueExp)val1).getValue();
            String sval2 = ((StringValueExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return sval1.compareTo(sval2) > 0;
                }
                case 1: {
                    return sval1.compareTo(sval2) < 0;
                }
                case 2: {
                    return sval1.compareTo(sval2) >= 0;
                }
                case 3: {
                    return sval1.compareTo(sval2) <= 0;
                }
                case 4: {
                    return sval1.compareTo(sval2) == 0;
                }
                case 5: {
                    return sval1.compareTo(sval2) != 0;
                }
                case 6: {
                    return this.like(sval1, sval2);
                }
                case 7: {
                    return !this.like(sval1, sval2);
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.expOne + " " + this.relOpString() + " " + this.expTwo;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "LIKE";
            }
            case 7: {
                return "NOT LIKE";
            }
            case 8: {
                return "ISA";
            }
            case 9: {
                return "NOT ISA";
            }
        }
        return "=";
    }

    private String trimPercent(String pattern) {
        StringCharacterIterator ci = new StringCharacterIterator(pattern);
        StringBuffer sb = new StringBuffer();
        int prevc = 65535;
        char c = ci.first();
        while (c != '\uffff') {
            if (c != '%' || prevc != 37) {
                sb.append(c);
            }
            prevc = c;
            c = ci.next();
        }
        return sb.toString();
    }

    private boolean like(String match, String pattern) {
        int prevState = -1;
        int currState = 0;
        int backtrack = -1;
        char backtrackChar = '\uffff';
        int length = match.length();
        pattern = this.trimPercent(pattern);
        int endIndex = pattern.length() - 1;
        for (int i = 0; i < length; ++i) {
            char a;
            if (currState > endIndex) {
                return false;
            }
            char pcs = pattern.charAt(currState);
            if (pcs == '%') {
                prevState = currState;
                if (currState == endIndex) {
                    return true;
                }
                a = match.charAt(i);
                if (a != pattern.charAt(currState + 1)) continue;
                currState += 2;
                backtrackChar = a;
                backtrack = -1;
                continue;
            }
            a = match.charAt(i);
            if (backtrack == -1 && a == backtrackChar) {
                backtrack = i;
            }
            if (a != pcs) {
                if (prevState == -1) {
                    return false;
                }
                currState = prevState;
                if (backtrack == -1) continue;
                i = backtrack - 1;
                backtrack = -1;
                continue;
            }
            ++currState;
        }
        return currState > endIndex || currState == endIndex && pattern.charAt(endIndex) == '%';
    }
}

