/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.query;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.query.AndQueryExp;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.FromExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.NotQueryExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.OrQueryExp;
import javax.wbem.query.ParseException;
import javax.wbem.query.QualifiedAttributeExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.SimpleCharStream;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.Token;
import javax.wbem.query.ValueExp;
import javax.wbem.query.WQLExp;
import javax.wbem.query.WQLParserConstants;
import javax.wbem.query.WQLParserTokenManager;

public class WQLParser
implements WQLParserConstants {
    public WQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) {
        InputStream in = System.in;
        WQLParser parser = new WQLParser(System.in);
        System.out.println("Enter SQL one per line. End with <EOF>");
        try {
            int b;
            do {
                WQLExp q;
                System.out.print("\nInputSQL:  ");
                StringBuffer line = new StringBuffer();
                while ((b = in.read()) != -1 && b != 10) {
                    line.append((char)b);
                }
                line.append("\n");
                System.out.println("ReadSQL: " + line.toString());
                ByteArrayInputStream lineStream = new ByteArrayInputStream(line.toString().getBytes());
                parser.ReInit(lineStream);
                try {
                    q = parser.querySpecification();
                    System.out.println("toString: " + q);
                }
                catch (ParseException e) {
                    System.out.println(e);
                }
                lineStream = new ByteArrayInputStream(line.toString().getBytes());
                parser.ReInit(lineStream);
                try {
                    q = parser.querySpecification();
                    System.out.println("Repeated: " + q);
                }
                catch (ParseException e) {
                    System.out.println(e);
                }
            } while (b != -1);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public final boolean sign() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                return false;
            }
            case 15: {
                this.jj_consume_token(15);
                return true;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericValue unsignedNumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                NumericValue exact = this.exactNumericLiteral();
                return exact;
            }
            case 31: {
                Token approx = this.jj_consume_token(31);
                return new NumericValue(new Double(approx.image));
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericValue exactNumericLiteral() throws ParseException {
        Token uinteger = this.jj_consume_token(33);
        return new NumericValue(new UnsignedInt64(uinteger.image));
    }

    public final String columnName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                Token id = this.jj_consume_token(36);
                return id.image;
            }
            case 35: {
                Token id = this.jj_consume_token(35);
                return id.image;
            }
            case 16: {
                Token id = this.jj_consume_token(16);
                return id.image;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericValue signedNumericLiteral() throws ParseException {
        boolean signed = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                signed = this.sign();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        NumericValue literal = this.unsignedNumericLiteral();
        if (!signed) {
            return literal;
        }
        if (literal.isUint() || literal.isSint()) {
            return new NumericValue(new Long(-literal.longValue()));
        }
        return new NumericValue(new Double(-literal.doubleValue()));
    }

    public final StringValueExp generalLiteral() throws ParseException {
        int j;
        Token literal = this.jj_consume_token(34);
        String s = literal.image;
        StringBuffer t = new StringBuffer();
        s = s.substring(1, s.length() - 1);
        int i = 0;
        while (-1 != (j = s.indexOf("''", i))) {
            t.append(s.substring(i, j)).append("'");
            i = j + 2;
        }
        t.append(s.substring(i));
        return new StringValueExp(t.toString());
    }

    public final ValueExp anyLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 31: 
            case 33: {
                NumericValue exp = this.signedNumericLiteral();
                return exp;
            }
            case 34: {
                StringValueExp exp = this.generalLiteral();
                return exp;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String tableName() throws ParseException {
        Token id = this.jj_consume_token(35);
        return id.image;
    }

    public final QueryExp searchConditionOnly() throws ParseException {
        QueryExp condition = this.searchCondition();
        this.jj_consume_token(0);
        return condition;
    }

    public final QueryExp searchCondition() throws ParseException {
        QueryExp condition = this.booleanTerm();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            QueryExp term = this.booleanTerm();
            condition = new OrQueryExp(condition, term);
        }
        return condition;
    }

    public final QueryExp booleanTerm() throws ParseException {
        QueryExp term = this.booleanFactor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(23);
            QueryExp factor = this.booleanFactor();
            term = new AndQueryExp(term, factor);
        }
        return term;
    }

    public final QueryExp booleanFactor() throws ParseException {
        boolean isNot = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                isNot = true;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        QueryExp test = this.booleanTest();
        if (isNot) {
            return new NotQueryExp(test);
        }
        return test;
    }

    public final QueryExp booleanTest() throws ParseException {
        QueryExp primary = this.booleanPrimary();
        return primary;
    }

    public final QueryExp booleanPrimary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                QueryExp exp = this.searchCondition();
                this.jj_consume_token(19);
                return exp;
            }
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                BinaryRelQueryExp exp = this.relOperation();
                return exp;
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final BinaryRelQueryExp relOperation() throws ParseException {
        ValueExp lexp = null;
        ValueExp rexp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 35: 
            case 36: {
                lexp = this.columnReference();
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 33: 
            case 34: {
                lexp = this.anyLiteral();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        int op = this.compOp();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 35: 
            case 36: {
                rexp = this.columnReference();
                break;
            }
            case 14: 
            case 15: 
            case 31: 
            case 33: 
            case 34: {
                rexp = this.anyLiteral();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BinaryRelQueryExp(op, lexp, rexp);
    }

    public final AttributeExp columnReference() throws ParseException {
        String attr = null;
        attr = this.columnName();
        return new AttributeExp(attr);
    }

    public final WQLExp querySpecification() throws ParseException {
        this.jj_consume_token(25);
        SelectList list = this.selectList();
        Object[] fromWhere = this.tableExpression();
        return new SelectExp(list, (FromExp)fromWhere[0], (QueryExp)fromWhere[1]);
    }

    public final SelectList selectList() throws ParseException {
        SelectList list = null;
        AttributeExp exp = this.selectSublist();
        list = new SelectList(exp);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
            exp = this.selectSublist();
            list.addElement(exp);
        }
        return list;
    }

    public final AttributeExp selectSublist() throws ParseException {
        AttributeExp col = this.columnReference();
        return col;
    }

    public final Object[] tableExpression() throws ParseException {
        Object[] fromWhere = new Object[2];
        fromWhere[1] = null;
        fromWhere[0] = this.fromClause();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                fromWhere[1] = this.whereClause();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        return fromWhere;
    }

    public final QualifiedAttributeExp tableReference() throws ParseException {
        String alias = null;
        String classname = this.tableName();
        return new QualifiedAttributeExp(classname, alias, null);
    }

    public final FromExp fromClause() throws ParseException {
        this.jj_consume_token(26);
        QualifiedAttributeExp ref = this.tableReference();
        return new NonJoinExp(ref);
    }

    public final QueryExp whereClause() throws ParseException {
        this.jj_consume_token(27);
        QueryExp cond = this.searchCondition();
        return cond;
    }

    public final int compOp() throws ParseException {
        boolean isNot = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 28: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        isNot = true;
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        if (isNot) {
                            return 7;
                        }
                        return 6;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        if (isNot) {
                            return 9;
                        }
                        return 8;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 11: {
                this.jj_consume_token(11);
                return 4;
            }
            case 8: {
                this.jj_consume_token(8);
                return 5;
            }
            case 10: {
                this.jj_consume_token(10);
                return 1;
            }
            case 13: {
                this.jj_consume_token(13);
                return 0;
            }
            case 9: {
                this.jj_consume_token(9);
                return 3;
            }
            case 12: {
                this.jj_consume_token(12);
                return 2;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{49152, Integer.MIN_VALUE, 65536, 49152, -2147434496, 0x400000, 0x800000, 0x1000000, -2147106816, -2147368960, -2147368960, 0x200000, 0x8000000, 0x1000000, 0x50000000, 1358970624};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 2, 24, 0, 6, 0, 0, 0, 30, 30, 30, 0, 0, 0, 0, 0};
    }

    public WQLParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new WQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public WQLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new WQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public WQLParser(WQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(WQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[39];
        for (i = 0; i < 39; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 16; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 39; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        WQLParser.jj_la1_0();
        WQLParser.jj_la1_1();
    }
}

