/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import com.sun.trustedsolaris.TsolAttrs;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Hashtable;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.Debug;
import javax.wbem.client.LocalUserPrincipal;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.ClientSecurityFactory;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import javax.wbem.security.UserPasswordEncryptionProvider;

public class SunDigestClientSecurity
implements ClientSecurityContext {
    private static boolean ssl_enabled = true;
    private static final String mechanism = "sundigest";
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static final String BAD_HASH = ".B.A.D.H.A.S.H.";
    private static final String FAKE_HASH = ".F.A.K.E.H.A.S.H.";
    private static boolean initialized = false;
    private static MessageDigest md = null;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey cprivkey;
    private static PublicKey cpubkey;
    private static UserPasswordEncryptionProvider pep;
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private byte[] secret;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private boolean bLocalMode = false;
    private PublicKey spubkey;
    private String initialKey = "InitialKey";
    private byte[] cchallenge1;
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] encryptKey = null;
    private TsolAttrs clientTsolAttrs = null;
    protected static Hashtable insecureHosts;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    private static synchronized void initialize() throws NoSuchAlgorithmException {
        if (!initialized) {
            md = MessageDigest.getInstance("MD5");
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            cprivkey = keypair.getPrivate();
            cpubkey = keypair.getPublic();
            try {
                String cname = ClientSecurityFactory.getProperty("security.password.provider.class");
                Class<?> c = Class.forName(cname);
                pep = (UserPasswordEncryptionProvider)c.newInstance();
            }
            catch (Exception ex) {
                Debug.trace1("Error getting password encryption provider: " + ex.getMessage());
                throw new NoSuchAlgorithmException("NO_PASSWORD_PROVIDER");
            }
            String is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes");
            if (!is_ssl.equals("yes")) {
                ssl_enabled = false;
            }
            initialized = true;
        }
    }

    public SunDigestClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
        this.clientTsolAttrs = new TsolAttrs();
        SunDigestClientSecurity.initialize();
    }

    public SunDigestClientSecurity(CIMNameSpace ns, Principal prin, Object cred) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(ns);
        this.setPrincipal(prin);
        this.setCredential(cred);
        this.clientTsolAttrs = new TsolAttrs();
        SunDigestClientSecurity.initialize();
    }

    public String getMechanism() {
        return mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace namespace) throws CIMException {
        if (namespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = namespace;
        this.nsHost = namespace.getHost();
        this.nsPath = namespace.getNameSpace();
    }

    public void setPrincipal(Principal prin) throws CIMException {
        if (prin == null || !(prin instanceof UserPrincipal)) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = prin;
        this.userName = prin.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (prin instanceof LocalUserPrincipal) {
            this.bLocalMode = true;
        }
    }

    public void setCredential(Object cred) throws CIMException {
        String tPswd = null;
        if (cred != null) {
            if (cred instanceof PasswordCredential) {
                tPswd = new String(((PasswordCredential)cred).getUserPassword());
            } else if (cred instanceof String) {
                tPswd = new String((String)cred);
            }
        }
        if (tPswd == null) {
            Debug.trace1("Invalid credential for user " + this.userName);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (this.clientTsolAttrs != null && this.clientTsolAttrs.isSystemLabeled() && !this.clientTsolAttrs.getAuditId().equals(this.clientTsolAttrs.getUserId())) {
            tPswd = "__fake__pass_tsol1";
        }
        int len = tPswd.length();
        this.userPswd = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = tPswd.charAt(i);
            this.userPswd[i] = (byte)c;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getRoleName() {
        return null;
    }

    public String getRolePassword() {
        return null;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        String tPswd = "";
        if (this.userPswd.length > 0) {
            char[] ca = new char[this.userPswd.length];
            for (int i = 0; i < this.userPswd.length; ++i) {
                ca[i] = (char)(0 | this.userPswd[i] & 0xFF);
            }
            tPswd = new String(ca);
        }
        return tPswd;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return cpubkey;
    }

    public PublicKey getServerPublicKey() {
        return this.spubkey;
    }

    public PrivateKey getPrivateKey() {
        return cprivkey;
    }

    public MessageDigest getMD() {
        return md;
    }

    public Signature getSigner() {
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateHello() {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            byte[] roleWSLogin;
            byte[] labeledSys;
            this.cchallenge1 = new byte[16];
            SecurityUtil.secrand.nextBytes(this.cchallenge1);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            byte[] digest = md.digest();
            String tName = this.userName;
            if (this.bLocalMode) {
                tName = tName + ":" + WBEM_LOCAL_TYPE;
            }
            byte[] unb = tName.getBytes();
            byte[] nsb = this.nsPath.getBytes();
            if (this.clientTsolAttrs != null) {
                String tmp = Boolean.toString(this.clientTsolAttrs.isSystemLabeled());
                labeledSys = tmp.getBytes();
                tmp = this.clientTsolAttrs.getAuditId().equals(this.clientTsolAttrs.getUserId()) ? Boolean.toString(false) : Boolean.toString(true);
                roleWSLogin = tmp.getBytes();
            } else {
                String false_str = "false";
                labeledSys = false_str.getBytes();
                roleWSLogin = false_str.getBytes();
            }
            byte[] hashedUser = SecurityUtil.hashData(unb, digest);
            byte[] hashednsb = SecurityUtil.hashData(nsb, digest);
            byte[] hashedLabeledSys = SecurityUtil.hashData(labeledSys, digest);
            byte[] hashedRoleWSLogin = SecurityUtil.hashData(roleWSLogin, digest);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            md.update(hashedUser);
            md.update(hashednsb);
            md.update(hashedLabeledSys);
            md.update(hashedRoleWSLogin);
            return SecurityMessage.hello(this.cchallenge1, hashedUser, hashednsb, hashedLabeledSys, hashedRoleWSLogin, md.digest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateResponse(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isChallenge()) {
                throw new IllegalArgumentException("not a challenge message");
            }
            this.schallenge1 = sm.getChallenge();
            md.reset();
            md.update(sm.getChallenge());
            byte[] digest = md.digest(this.initialKey.getBytes());
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(sm.getSalt());
            if (!MessageDigest.isEqual(md.digest(sm.getSessionId()), sm.getChecksum())) {
                throw new IllegalArgumentException("Checksum error");
            }
            byte[] salt = SecurityUtil.extractHashedData(sm.getSalt(), digest);
            this.sessionId = sm.getSessionId();
            if (salt == null || this.sessionId == null) {
                throw new IllegalArgumentException("Null salt/session");
            }
            String sSalt = new String(salt);
            this.secret = null;
            if (sSalt.startsWith("$__LOCAL$")) {
                Debug.trace2("Local authentication for " + this.userName);
                this.bLocalMode = true;
                String filename = null;
                FileInputStream fis = null;
                int i = WBEM_LOCAL_TYPE.length() + 2;
                try {
                    filename = "/var/sadm/wbem/security/" + sSalt.substring(i);
                    Debug.trace3("Authentication file name: " + filename);
                    fis = new FileInputStream(filename);
                    byte[] bb = new byte[96];
                    int len = fis.read(bb);
                    if (len > 0) {
                        byte[] tb = new byte[len];
                        System.arraycopy(bb, 0, tb, 0, len);
                        String nonceHash = new String(tb, "UTF-8");
                        byte[] sb = this.fromHex(nonceHash);
                        this.secret = SecurityUtil.extractHashedData(sb, this.cchallenge1);
                        Debug.trace3("Authentication shared secret: " + this.toHex(this.secret));
                    }
                }
                catch (Exception ex) {
                    Debug.trace1("Error reading local auth file: " + ex.getMessage());
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {}
            } else if (!SunDigestClientSecurity.isServerSecure(this.nsHost)) {
                Debug.trace2("Password based authentication for " + this.userName);
                this.bLocalMode = false;
                String body = null;
                String pwEncr = null;
                try {
                    pwEncr = pep.encryptPassword(this.userName, sSalt, new String(this.userPswd));
                }
                catch (Exception ex) {
                    pwEncr = BAD_HASH;
                }
                if (pwEncr != null && pwEncr.length() > 0) {
                    if (pwEncr.charAt(0) == '$') {
                        try {
                            int i = pwEncr.lastIndexOf(36);
                            body = pwEncr.substring(i + 1);
                        }
                        catch (Exception ex) {}
                    } else {
                        body = pwEncr;
                    }
                }
                if (body != null) {
                    try {
                        this.secret = body.getBytes("UTF-8");
                        Debug.trace3("Authentication shared secret: " + new String(this.secret));
                    }
                    catch (Exception ex) {}
                }
            } else {
                try {
                    this.secret = ssl_enabled ? FAKE_HASH.getBytes("UTF-8") : BAD_HASH.getBytes("UTF-8");
                }
                catch (Exception ex) {
                    Debug.trace1("SunDigestClient: Error using UTF-8 converter " + ex.getMessage());
                }
            }
            if (this.secret == null) {
                try {
                    this.secret = BAD_HASH.getBytes("UTF-8");
                    Debug.trace3("Authentication shared secret is bad ");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            digest = md.digest();
            byte[] pwHash = null;
            pwHash = this.bLocalMode ? SecurityUtil.hashData(this.secret, digest) : SecurityUtil.hashData(this.userPswd, digest);
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            md.update(pwHash);
            md.update(cpubkey.getEncoded());
            return SecurityMessage.response(pwHash, cpubkey, this.sessionId, md.digest(this.sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkResult(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isResult()) {
                throw new IllegalArgumentException("not a result message");
            }
            byte[] bPswd = this.bLocalMode ? this.secret : this.userPswd;
            md.reset();
            md.update(this.getChallenge());
            md.update(bPswd);
            byte[] digest = md.digest();
            md.reset();
            md.update(this.getChallenge());
            md.update(bPswd);
            md.update(sm.getSessionId());
            this.spubkey = sm.getPublicKey();
            md.update(this.spubkey.getEncoded());
            md.update(sm.getResponse());
            if (!MessageDigest.isEqual(md.digest(), sm.getChecksum())) {
                Debug.trace1("Authentication checksum failure for " + this.userName);
                throw new IllegalArgumentException("mutual authentication failed");
            }
            this.sessionKey = SecurityUtil.extractHashedData(sm.getResponse(), digest);
            if (this.sessionKey == null) {
                throw new IllegalArgumentException("Null response");
            }
            this.encryptKey = new byte[this.sessionKey.length];
            System.arraycopy(this.sessionKey, 0, this.encryptKey, 0, this.sessionKey.length);
            return this.sessionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityToken getSecurityToken(String[] sarray) throws CIMException {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            SecurityToken st = new SecurityToken();
            String s = "";
            for (int i = 0; i < sarray.length; ++i) {
                s = s + sarray[i];
            }
            byte[] ser = s.getBytes();
            MessageDigest digester = this.getMD();
            digester.reset();
            digester.update(this.getSessionKey());
            digester.update(ser);
            byte[] digest = digester.digest();
            st.setChecksum(digest);
            st.setSessionId(this.getSessionId());
            return st;
        }
    }

    public synchronized void incSessionKey() {
        SecurityUtil.incByteArray(this.sessionKey);
    }

    public String trans51Format(String inData) throws CIMException {
        int i;
        if (inData.length() > 15 || this.encryptKey == null) {
            Debug.trace1("Cannot encrypt data; invalid data or session key");
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] pwb = inData.getBytes();
        int len = this.encryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.encryptKey, 0, rb, 0, len);
        byte[] pad = new byte[len];
        SecurityUtil.secrand.nextBytes(pad);
        for (i = 0; i < pwb.length; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
        }
        int n = i++;
        rb[n] = (byte)(rb[n] ^ 0);
        while (i < rb.length) {
            int n2 = i;
            rb[n2] = (byte)(rb[n2] ^ pad[i]);
            ++i;
        }
        String val = this.toHex(rb);
        return val;
    }

    private String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private byte[] fromHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] ba = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int k;
            ba[j] = 0;
            boolean ok = false;
            char c = str.charAt(i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(k << 4 & 0xF0);
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ok = false;
            c = str.charAt(++i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(ba[j] | (byte)(k & 0xF));
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ++j;
        }
        return ba;
    }

    public static void setInsecureHost(String hostname) {
        String addrtxt = "unknown";
        try {
            InetAddress[] addr = InetAddress.getAllByName(hostname);
            addrtxt = addr[0].getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!insecureHosts.containsKey(addrtxt)) {
            insecureHosts.put(addrtxt, hostname);
        }
    }

    public static boolean isServerSecure(String hostname) {
        return !insecureHosts.containsKey(hostname) && !insecureHosts.containsValue(hostname);
    }

    static {
        pep = null;
        insecureHosts = new Hashtable();
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

