/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deg.sunvts.agent;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class LogReader {
    private static final String UNIX_MSGS_LOG = "messages";

    private static String getFilePath(String logName) {
        String filepath = "";
        if (UNIX_MSGS_LOG.equals(logName)) {
            filepath = "/var/adm/" + logName;
            String result = System.getProperty("islinux");
            if (result != null && result.equalsIgnoreCase("1")) {
                filepath = "/var/log/" + logName;
            }
        } else {
            filepath = "/var/sunvts/logs/" + logName;
        }
        return filepath;
    }

    static String getLogContents(String logName, int noOfLines) throws Exception {
        String line = null;
        String logFilePath = null;
        String logString = null;
        BufferedReader reader = null;
        FileReader fReader = null;
        if (logName == null) {
            throw new Exception("Invalid log name: null");
        }
        logFilePath = LogReader.getFilePath(logName);
        if (logFilePath == null) {
            throw new Exception("Invalid log name: " + logName);
        }
        if (noOfLines > 0) {
            try {
                fReader = new FileReader(logFilePath);
            }
            catch (IOException e) {
                throw new Exception("Unable to open log name: " + logName);
            }
        } else {
            return "0 lines requested";
        }
        reader = new BufferedReader(fReader);
        StringBuffer logBuffer = new StringBuffer(0x500000);
        int[] bufferLength = new int[noOfLines];
        int lineCount = 0;
        try {
            line = reader.readLine();
            while (line != null) {
                bufferLength[lineCount++] = logBuffer.length();
                if (lineCount == noOfLines) {
                    lineCount = 0;
                }
                logBuffer.append(line);
                logBuffer.append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            reader.close();
            fReader.close();
            throw new Exception("Unable to read from file: " + logName);
        }
        if (logBuffer.length() > 0) {
            logBuffer.deleteCharAt(logBuffer.length() - 1);
        }
        if ((logString = logBuffer.toString()) == null) {
            logString = "";
        }
        logString = logString.substring(bufferLength[lineCount]);
        reader.close();
        fReader.close();
        return logString;
    }
}

