/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.util.Enumeration;
import java.util.Vector;

public class CIMProperty
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private String originClass = "";
    private CIMDataType type = null;
    private int size = 0;
    private Vector qualifiers = new Vector();
    private String op = null;
    private CIMValue value = null;

    public CIMProperty() {
        this("");
    }

    public CIMProperty(String name) {
        super(name);
    }

    public CIMProperty(String n, CIMValue v) {
        this(n);
        this.value = v;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Vector q) {
        this.qualifiers = q;
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public void setOriginClass(String originClass) {
        this.originClass = originClass == null ? "" : originClass;
    }

    public void setValue(CIMValue aValue) {
        this.value = aValue;
    }

    public CIMValue getValue() {
        return this.value;
    }

    public void setType(CIMDataType aType) {
        this.type = aType;
    }

    public CIMDataType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value != null) {
            return this.value.getType();
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int aSize) {
        this.size = aSize;
    }

    public void setOverridingProperty(String name) {
        this.op = name;
    }

    public String getOverridingProperty() {
        return this.op;
    }

    public boolean isReference() {
        if (this.type == null) {
            return false;
        }
        return this.type.getType() == 28;
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            return null;
        }
        int tempIndex = this.qualifiers.indexOf(new CIMQualifier(name));
        CIMQualifier qe = tempIndex >= 0 ? (CIMQualifier)this.qualifiers.elementAt(tempIndex) : null;
        return qe;
    }

    public CIMQualifier setQualifier(CIMQualifier cq) throws CIMException {
        CIMQualifier qe = this.getQualifier(cq.getName());
        if (qe == null) {
            throw new CIMException("Property " + this.getName() + " does not have qualifier " + cq.getName());
        }
        qe.setValue(cq.getValue());
        return qe;
    }

    public void addQualifier(CIMQualifier cq) throws CIMException {
        CIMQualifier qe = this.getQualifier(cq.getName());
        if (qe != null) {
            throw new CIMException("Property " + this.getName() + " already has qualifier " + cq.getName());
        }
        this.qualifiers.addElement(cq);
    }

    public boolean removeQualifier(String name) {
        return this.qualifiers.removeElement(new CIMQualifier(name));
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public synchronized Object clone() {
        return this.clone(true, true);
    }

    public synchronized Object clone(boolean includeQualifier, boolean includeClassOrigin) {
        CIMProperty pe = new CIMProperty();
        pe.name = this.name;
        pe.identifier = this.identifier;
        pe.type = this.type;
        if (includeClassOrigin) {
            pe.originClass = this.originClass;
        }
        pe.size = this.size;
        pe.value = this.value;
        pe.op = this.op;
        if (this.qualifiers == null || !includeQualifier) {
            pe.qualifiers = new Vector();
        } else {
            Vector<Object> ov = new Vector<Object>();
            Enumeration e = this.qualifiers.elements();
            while (e.hasMoreElements()) {
                CIMQualifier qe = (CIMQualifier)e.nextElement();
                ov.addElement(qe.clone());
            }
            pe.qualifiers = ov;
        }
        return pe;
    }

    public boolean isKey() {
        if (this.getOverridingProperty() != null) {
            return false;
        }
        if (this.isReference()) {
            return true;
        }
        CIMQualifier qe = this.getQualifier("key");
        if (qe == null) {
            return false;
        }
        return qe.getValue() == null || qe.getValue().equals(CIMValue.TRUE);
    }

    public String toXml() {
        XmlInstance xi = new XmlInstance();
        return xi.toXml(this);
    }
}

