/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlElement;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlInstance
extends XmlElement {
    private CIMObjectPath cop = new CIMObjectPath();
    private static String host = "";
    private boolean validate = false;
    private static boolean SHOW_HOST = true;
    private static boolean SHOW_NAMESPACE = true;
    private boolean IncludeQualifiers = true;
    private boolean IncludeClassOrigin = false;
    private boolean IncludeOverridenProperties = false;
    private String[] PropertyList = null;
    static final String CIMVERSION = "2.0";
    static final String DTDVERSION = "2.0";

    public XmlInstance() {
    }

    public XmlInstance(String host) {
        XmlInstance.host = host;
    }

    public boolean getIncludeQualifiers() {
        return this.IncludeQualifiers;
    }

    public boolean getIncludeClassOrigin() {
        return this.IncludeClassOrigin;
    }

    public boolean getIncludeOverridenProperties() {
        return this.IncludeOverridenProperties;
    }

    public void setIncludeQualifiers(boolean include) {
        this.IncludeQualifiers = include;
    }

    public void setIncludeClassOrigin(boolean include) {
        this.IncludeClassOrigin = include;
    }

    public void setIncludeOverridenProperties(boolean include) {
        this.IncludeOverridenProperties = include;
    }

    public String[] getPropertyList() {
        return this.PropertyList;
    }

    public void setPropertyList(String[] list) {
        this.PropertyList = list;
    }

    boolean getShowHost() {
        return SHOW_HOST;
    }

    void setShowHost(boolean assume) {
        SHOW_HOST = assume;
    }

    boolean getShowNamespace() {
        return SHOW_NAMESPACE;
    }

    void setShowNamespace(boolean assume) {
        SHOW_NAMESPACE = assume;
    }

    public String toXml(Object obj) {
        return this.toXml(obj, this.cop, host);
    }

    public String toXml(Object obj, CIMObjectPath cop) {
        this.cop = cop;
        return this.toXml(obj, this.cop, host);
    }

    public String toXml(Object obj, CIMObjectPath cop, String host) {
        String Xml = "";
        this.cop = cop;
        XmlInstance.host = host;
        String type = obj.getClass().getName().toString();
        if (obj instanceof CIMClass) {
            Xml = this.cimClass((CIMClass)obj);
        } else if (obj instanceof CIMInstance) {
            Xml = this.instance((CIMInstance)obj);
        } else if (obj instanceof CIMObjectPath) {
            Xml = this.objectPath((CIMObjectPath)obj);
        } else if (obj instanceof CIMNameSpace) {
            Xml = this.localNameSpacePath((CIMNameSpace)obj);
        } else if (obj instanceof CIMProperty) {
            Xml = this.property((CIMProperty)obj, this.cop.getObjectName());
        } else if (obj instanceof CIMQualifier) {
            Xml = this.qualifier((CIMQualifier)obj);
        } else if (obj instanceof CIMFlavor) {
            CIMQualifier cq = new CIMQualifier();
            cq.addFlavor((CIMFlavor)obj);
            Xml = this.qualifier(cq);
        } else if (obj instanceof CIMMethod) {
            Xml = this.method((CIMMethod)obj, this.cop.getObjectName());
        } else if (obj instanceof CIMParameter) {
            Xml = this.parameter((CIMParameter)obj);
        } else if (obj instanceof CIMValue) {
            Xml = this.value((CIMValue)obj);
        }
        return Xml;
    }

    String cloak(String frag) {
        return this.stag(TOXML) + frag + this.etag();
    }

    public XmlDocument pcdata2Xml(String pcdata) throws SAXException, IOException {
        InputSource input = new InputSource(new StringReader(pcdata));
        return XmlDocument.createXmlDocument((InputSource)input, (boolean)this.validate);
    }

    public String xml2Pcdata(XmlDocument doc) throws IOException {
        StringWriter sw = new StringWriter();
        doc.write((Writer)sw);
        return sw.toString();
    }

    public void setCIMName(String name) {
        this.setAttr("NAME", name);
    }

    void setCIMName(CIMElement ce) {
        this.setCIMName(ce.getName());
    }

    void setCIMType(CIMDataType cdt) {
        String type = "";
        if (cdt == null) {
            this.setAttr("TYPE", this.getCIMType(cdt));
        } else if (!cdt.isReferenceType()) {
            this.setAttr("TYPE", this.getCIMType(cdt));
        }
    }

    public String getCIMType(CIMDataType cdt) {
        String type = null;
        if (cdt == null) {
            return type;
        }
        if (!cdt.isReferenceType()) {
            type = cdt.toString().toLowerCase();
            if (type.indexOf("_") > 0) {
                type = type.substring(0, type.indexOf("_"));
            } else if (type.indexOf("[") > 0) {
                type = type.substring(0, type.indexOf("["));
            }
        } else {
            type = "reference";
        }
        return type;
    }

    void setQualifierFlavor(CIMQualifier cq) {
        if (cq.hasFlavor(new CIMFlavor(1))) {
            this.setAttr("OVERRIDABLE", "false");
        } else if (this.getShowDefault()) {
            this.setAttr("OVERRIDABLE", "true");
        }
        if (cq.hasFlavor(new CIMFlavor(2))) {
            this.setAttr("TOSUBCLASS", "false");
        } else if (this.getShowDefault()) {
            this.setAttr("TOSUBCLASS", "true");
        }
        if (cq.hasFlavor(new CIMFlavor(4))) {
            this.setAttr("TRANSLATABLE", "true");
        } else if (this.getShowDefault()) {
            this.setAttr("TRANSLATABLE", "false");
        }
    }

    void setClassOrigin(String origin) {
        if (origin != null && this.IncludeClassOrigin) {
            this.setAttr("CLASSORIGIN", origin);
        }
    }

    void setClassOrigin(CIMProperty cp) {
        if (this.IncludeClassOrigin) {
            this.setClassOrigin(cp.getOriginClass());
        }
    }

    void setClassOrigin(CIMMethod cm) {
        if (this.IncludeClassOrigin) {
            this.setClassOrigin(cm.getOriginClass());
        }
    }

    void setPropagated(boolean propagated) {
        String s;
        String string = s = propagated ? "true" : "false";
        if (this.getShowDefault() || propagated) {
            this.setAttr("PROPAGATED", s);
        }
    }

    void setPropagated(CIMProperty cp, String name) {
        if (name.equals(cp.getOriginClass())) {
            this.setPropagated(false);
        } else {
            this.setPropagated(true);
        }
    }

    void setPropagated(CIMQualifier cq) {
        this.setPropagated(false);
    }

    void setPropagated(CIMMethod cm, String name) {
        if (name.equals(cm.getOriginClass())) {
            this.setPropagated(false);
        } else {
            this.setPropagated(true);
        }
    }

    void setArraySize(int size) {
        if (this.getShowImplied()) {
            this.setAttr("ARRAYSIZE", String.valueOf(size));
        }
    }

    void setSuperClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr("SUPERCLASS", name);
        }
    }

    void setSuperClass(CIMClass cc) {
        String name;
        if (this.getShowImplied() && (name = cc.getSuperClass()).length() != 0) {
            this.setSuperClass(name);
        }
    }

    void setSuperClass(CIMInstance ci) {
        String name;
        if (this.getShowImplied() && (name = ci.getClassName()).length() != 0) {
            this.setSuperClass(name);
        }
    }

    void setClassName(String name) {
        this.setAttr("CLASSNAME", name);
    }

    void setClassName(CIMObjectPath cop) {
        String name = cop.getObjectName();
        if (name.length() != 0) {
            this.setClassName(name);
        }
    }

    void setClassName(CIMInstance ci) {
        String name = ci.getClassName();
        if (name.length() != 0) {
            this.setClassName(name);
        }
    }

    void setReferenceClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr("REFERENCECLASS", name);
        }
    }

    void setReferenceClass(CIMProperty cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    void setReferenceClass(CIMParameter cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    public String root(String body) {
        this.setAttr("CIMVERSION", "2.0");
        this.setAttr("DTDVERSION", "2.0");
        return this.stag(CIM) + body + this.etag();
    }

    public String value(String pcdata) {
        return this.stag(VALUE) + this.pcdata(pcdata) + this.etag();
    }

    public String value(String[] pcdata) {
        StringBuffer Xml = new StringBuffer();
        Xml.append(this.stag(VALUE_ARRAY));
        for (int i = 0; i < pcdata.length; ++i) {
            Xml.append(this.value(pcdata[i]));
        }
        return Xml.toString() + this.etag();
    }

    public String value(boolean value) {
        return this.stag(VALUE) + (value ? "TRUE" : "FALSE") + this.etag();
    }

    public String value(CIMValue cv) {
        if (cv == null) {
            return this.stag(VALUE) + this.etag();
        }
        if (cv.isArrayValue()) {
            return this.valueArray(cv);
        }
        return this.stag(VALUE) + this.pcdata(cv) + this.etag();
    }

    String value(Vector values) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            CIMValue cv = new CIMValue(values.elementAt(i));
            Xml.append(this.value(cv));
        }
        return Xml.toString();
    }

    public String value(CIMProperty cp) {
        if (cp.isReference()) {
            return this.valueReference(cp);
        }
        if (cp.getValue() != null) {
            return this.value(cp.getValue());
        }
        return "";
    }

    String value(CIMQualifier cq) {
        String Xml = "";
        if (cq.getValue() != null) {
            Xml = this.value(cq.getValue());
        }
        return Xml;
    }

    String quoted(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            if (pcdata.charAt(i) == '\\' || pcdata.charAt(i) == '\"') {
                buf.append("\\");
            }
            buf.append(pcdata.charAt(i));
        }
        return "\"" + buf.toString() + "\"";
    }

    boolean hasMarkup(String pcdata) {
        return pcdata.indexOf("<") + pcdata.indexOf("&") > 0;
    }

    String cdata(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        block4: for (int i = 0; i < pcdata.length(); ++i) {
            switch (pcdata.charAt(i)) {
                case '<': {
                    buf.append("&lt;");
                    continue block4;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block4;
                }
                default: {
                    buf.append(pcdata.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    String pcdata(String pcdata) {
        String Xml = pcdata;
        if (this.hasMarkup(pcdata)) {
            Xml = this.cdata(pcdata);
        }
        return Xml;
    }

    String pcdata(CIMValue cv) {
        if (cv == null) {
            return "";
        }
        if (cv.getType() != null && cv.getType().isArrayType()) {
            throw new IllegalArgumentException();
        }
        return cv.isNullValue() ? "" : this.pcdata(cv.getValue().toString());
    }

    boolean hasMse(String pcdata) {
        return pcdata.indexOf("]]>") > 0;
    }

    String valueArray(CIMValue cv) {
        return this.stag(VALUE_ARRAY) + this.value((Vector)cv.getValue()) + this.etag();
    }

    String valueReference(CIMObjectPath cop) {
        return this.stag(VALUE_REFERENCE) + this.pickObjectName(cop) + this.etag();
    }

    String valueReference(CIMProperty cp) {
        StringBuffer Xml = new StringBuffer();
        CIMValue cv = cp.getValue();
        CIMObjectPath cop = new CIMObjectPath();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        Xml.append(this.valueReference(cop));
        return Xml.toString();
    }

    String valueRefArray(CIMObjectPath cop) {
        return this.stag(VALUE_REFARRAY) + this.valueReference(cop) + this.etag();
    }

    String valueObject(Object obj) {
        return this.stag(VALUE_OBJECT) + this.object(obj) + this.etag();
    }

    public String valueNamedInstance(CIMInstance ci) {
        return this.stag(VALUE_NAMEDINSTANCE) + this.instanceName(ci) + this.instance(ci) + this.etag();
    }

    public String valueNamedInstance(CIMObjectPath name, CIMInstance ci) {
        return this.stag(VALUE_NAMEDINSTANCE) + this.instanceName(name) + this.instance(ci) + this.etag();
    }

    public String valueNamedObject(Object obj) {
        return this.stag(VALUE_NAMEDOBJECT) + this.namedObject(obj) + this.etag();
    }

    String valueObjectWithLocalPath(Object obj) {
        return this.stag(VALUE_OBJECTWITHLOCALPATH) + this.objectWithLocalPath(obj) + this.etag();
    }

    public String valueObjectWithPath(Object obj) {
        return this.stag(VALUE_OBJECTWITHPATH) + this.objectWithPath(obj) + this.etag();
    }

    String pickObjectName(CIMObjectPath cop) {
        if (SHOW_HOST) {
            return this.objectPath(cop, false);
        }
        if (SHOW_NAMESPACE) {
            return this.localObjectPath(cop);
        }
        return this.objectName(cop);
    }

    public String localObjectPath(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.localInstancePath(cop);
        }
        return this.localClassPath(cop);
    }

    public String objectName(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.instanceName(cop);
        }
        return this.className(cop);
    }

    String nameSpacePath(CIMObjectPath cop) {
        return this.stag(NAMESPACEPATH) + this.host("localhost") + this.localNameSpacePath(cop) + this.etag();
    }

    String nameSpacePath(CIMNameSpace cns) {
        return this.stag(NAMESPACEPATH) + this.host(cns.getHost()) + this.localNameSpacePath(cns) + this.etag();
    }

    public String localNameSpacePath(String ns) {
        StringBuffer Xml = new StringBuffer(this.stag(LOCALNAMESPACEPATH));
        int i = ns.indexOf("\\");
        while (i >= 0) {
            if (i != 0) {
                Xml.append(this.nameSpace(ns.substring(0, i)));
            }
            ns = ns.substring(i + 1);
            i = ns.indexOf("\\");
        }
        return Xml.toString() + this.nameSpace(ns) + this.etag();
    }

    public String localNameSpacePath(CIMNameSpace cns) {
        return this.localNameSpacePath(cns.getNameSpace());
    }

    public String localNameSpacePath(CIMObjectPath cop) {
        return this.localNameSpacePath(cop.getNameSpace());
    }

    String host(String name) {
        return this.stag(HOST) + this.pcdata(name) + this.etag();
    }

    String nameSpace(String name) {
        this.setCIMName(name);
        return this.otag(NAMESPACE);
    }

    String classPath(CIMObjectPath cop) {
        return this.stag(CLASSPATH) + this.nameSpacePath(cop) + this.className(cop.getObjectName()) + this.etag();
    }

    String localClassPath(CIMObjectPath cop) {
        return this.stag(LOCALCLASSPATH) + this.localNameSpacePath(cop) + this.className(cop) + this.etag();
    }

    public String className(String name) {
        this.setCIMName(name);
        return this.otag(CLASSNAME);
    }

    String className(CIMClass cc) {
        return this.className(cc.getName());
    }

    String className(CIMObjectPath cop) {
        return this.className(cop.getObjectName());
    }

    String instancePath(CIMObjectPath cop) {
        return this.stag(INSTANCEPATH) + this.nameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    String localInstancePath(CIMObjectPath cop) {
        return this.stag(LOCALINSTANCEPATH) + this.localNameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    String instanceName(Vector cp, String name) {
        String keybinding = this.keyBinding(cp);
        this.setClassName(name);
        return this.stag(INSTANCENAME) + keybinding + this.etag();
    }

    public String instanceName(CIMObjectPath cop) {
        return this.instanceName(cop.getKeys(), cop.getObjectName());
    }

    public String instanceName(CIMInstance ci) {
        return this.instanceName(ci.getKeyValuePairs(), ci.getClassName());
    }

    public String objectPath(CIMObjectPath cop) {
        return this.objectPath(cop, true);
    }

    String objectPath(CIMObjectPath cop, boolean includetype) {
        StringBuffer Xml = new StringBuffer();
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            Xml.append(this.instancePath(cop));
        } else {
            Xml.append(this.classPath(cop));
        }
        if (includetype) {
            Xml = new StringBuffer(this.stag(OBJECTPATH) + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String keyBinding(CIMProperty cp) {
        this.setCIMName(cp);
        StringBuffer Xml = new StringBuffer(this.stag(KEYBINDING));
        if (cp.isReference()) {
            Xml.append(this.valueReference(cp));
        } else {
            Xml.append(this.keyValue(cp));
        }
        return Xml.toString() + this.etag();
    }

    String keyBinding(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            if (!(cp.elementAt(i) instanceof CIMProperty)) continue;
            CIMProperty p = (CIMProperty)cp.elementAt(i);
            Xml.append(this.keyBinding(p));
        }
        return Xml.toString();
    }

    void setValueType(CIMDataType cdt) {
        String type = this.getCIMType(cdt);
        type = type == null ? "null" : (type.equals("string") || type.equals("datetime") ? "string" : (type.equals("boolean") ? "boolean" : "numeric"));
        this.setAttr("VALUETYPE", type);
    }

    String keyValue(CIMProperty cp) {
        this.setValueType(cp.getType());
        return this.stag(KEYVALUE) + (cp.getValue() == null ? "" : this.pcdata(cp.getValue())) + this.etag();
    }

    public String object(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instance((CIMInstance)obj);
        }
        return "";
    }

    String namedObject(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instanceName((CIMInstance)obj) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String objectWithPath(Object obj) {
        if (obj instanceof CIMClass) {
            return this.classPath(this.cop) + this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instancePath(this.cop) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String objectWithLocalPath(Object obj) {
        if (obj instanceof CIMClass) {
            return this.localClassPath(this.cop) + this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.localInstancePath(this.cop) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    public String cimClass(CIMClass cc) {
        this.setCIMName(cc);
        this.setSuperClass(cc);
        return this.stag(CLASS) + this.qualifier(cc) + this.property(cc) + this.method(cc) + this.etag(CLASS);
    }

    public String instance(CIMInstance ci) {
        this.setClassName(ci);
        return this.stag(INSTANCE) + this.qualifier(ci) + this.property(ci) + this.etag();
    }

    String qualifier(CIMQualifier q) {
        StringBuffer Xml = new StringBuffer();
        if (this.IncludeQualifiers) {
            this.setCIMName(q);
            if (q.getValue() != null) {
                this.setCIMType(q.getValue().getType());
            } else {
                CIMDataType cdt = null;
                this.setCIMType(cdt);
            }
            this.setPropagated(q);
            this.setQualifierFlavor(q);
            Xml = new StringBuffer(this.stag(QUALIFIER));
            if (q.getValue() != null) {
                if (q.getValue().isArrayValue()) {
                    Xml.append(this.valueArray(q.getValue()));
                } else {
                    Xml.append(this.value(q.getValue()));
                }
            }
            Xml.append(this.etag(QUALIFIER));
        }
        return Xml.toString();
    }

    String qualifier(Vector qualifiers) {
        StringBuffer Xml = new StringBuffer();
        if (this.IncludeQualifiers) {
            for (int i = 0; i < qualifiers.size(); ++i) {
                Xml.append(this.qualifier((CIMQualifier)qualifiers.elementAt(i)));
            }
        }
        return Xml.toString();
    }

    String qualifier(CIMClass cc) {
        return this.IncludeQualifiers ? this.qualifier(cc.getQualifiers()) : "";
    }

    String qualifier(CIMInstance ci) {
        return this.IncludeQualifiers ? this.qualifier(ci.getQualifiers()) : "";
    }

    String qualifier(CIMProperty cp) {
        return this.IncludeQualifiers ? this.qualifier(cp.getQualifiers()) : "";
    }

    String qualifier(CIMMethod cm) {
        return this.IncludeQualifiers ? this.qualifier(cm.getQualifiers()) : "";
    }

    String qualifier(CIMParameter cp) {
        return this.IncludeQualifiers ? this.qualifier(cp.getQualifiers()) : "";
    }

    public String qualifierDeclaration(CIMQualifierType qt) {
        this.setCIMName(qt.getName());
        this.setCIMType(qt.getType());
        if (this.getShowImplied()) {
            this.setAttr("ISARRAY", qt.isArrayValue() ? "true" : "false");
        }
        this.setQualifierFlavor(new CIMQualifier("", qt));
        return this.stag(QUALIFIER_DECLARATION) + this.scope(qt) + (qt.hasDefaultValue() && qt.getDefaultValue().getValue() != null ? this.value(qt.getDefaultValue()) : "") + this.etag();
    }

    String scope(CIMQualifierType qt) {
        boolean showscope = false;
        if (qt.hasScope(new CIMScope(1))) {
            this.setAttr("CLASS", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("CLASS", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(2))) {
            this.setAttr("ASSOCIATION", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("ASSOCIATION", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(3))) {
            this.setAttr("INDICATION", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("INDICATION", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(4))) {
            this.setAttr("PROPERTY", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("PROPERTY", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(5))) {
            this.setAttr("REFERENCE", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("REFERENCE", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(6))) {
            this.setAttr("METHOD", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("METHOD", "false");
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(7))) {
            this.setAttr("PARAMETER", "true");
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("PARAMETER", "false");
            showscope = true;
        }
        return showscope ? this.otag(SCOPE) : "";
    }

    boolean includeProperty(String property) {
        if (this.PropertyList == null) {
            return true;
        }
        if (this.PropertyList.length == 0) {
            return false;
        }
        for (int i = 0; i < this.PropertyList.length; ++i) {
            if (!property.equalsIgnoreCase(this.PropertyList[i])) continue;
            return true;
        }
        return false;
    }

    String property(CIMProperty cp, String name) {
        if (cp.getOverridingProperty() != null && !this.getIncludeOverridenProperties()) {
            return "";
        }
        if (!this.includeProperty(cp.getName())) {
            return "";
        }
        if (cp.getType().isArrayType()) {
            return this.propertyArray(cp, name);
        }
        if (cp.isReference()) {
            return this.propertyReference(cp, name);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        return this.stag(PROPERTY) + this.qualifier(cp.getQualifiers()) + this.value(cp) + this.etag();
    }

    String property(Vector p, String name) {
        String refs = "";
        String notrefs = "";
        for (int i = 0; i < p.size(); ++i) {
            CIMProperty cp = (CIMProperty)p.elementAt(i);
            if (cp == null || !this.includeProperty(cp.getName()) || cp.getType() == null) continue;
            if (cp.getType().isReferenceType()) {
                refs = refs + this.propertyReference(cp, name);
                continue;
            }
            notrefs = notrefs + this.property(cp, name);
        }
        return refs + notrefs;
    }

    String property(CIMClass cc) {
        return this.property(cc.getAllProperties(), cc.getName());
    }

    String property(CIMInstance ci) {
        return this.property(ci.getProperties(), ci.getClassName());
    }

    String propertyArray(CIMProperty cp, String name) {
        StringBuffer Xml = new StringBuffer();
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        Xml.append(this.stag(PROPERTY_ARRAY) + this.qualifier(cp.getQualifiers()));
        if (cp.getValue() != null) {
            Xml.append(this.valueArray(cp.getValue()));
        }
        return Xml.toString() + this.etag();
    }

    String propertyReference(CIMProperty cp, String name) {
        CIMObjectPath cop = new CIMObjectPath(cp.getType().getRefClassName());
        CIMValue cv = cp.getValue();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        return this.stag(PROPERTY_REFERENCE) + this.qualifier(cp) + this.valueReference(cop) + this.etag();
    }

    String method(CIMMethod cm, String name) {
        this.setCIMName(cm);
        this.setCIMType(cm.getType());
        this.setClassOrigin(cm);
        this.setPropagated(cm, name);
        return this.stag(METHOD) + this.qualifier(cm) + this.parameter(cm.getParameters()) + this.etag();
    }

    String method(Vector cms, String name) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cms.size(); ++i) {
            Xml.append(this.method((CIMMethod)cms.elementAt(i), name));
        }
        return Xml.toString();
    }

    String method(CIMClass cc) {
        return this.method(cc.getMethods(), cc.getName());
    }

    String parameter(CIMParameter cp) {
        if (cp.getType().isArrayType()) {
            if (cp.getType().isReferenceType()) {
                return this.parameterRefArray(cp);
            }
            return this.parameterArray(cp);
        }
        if (cp.getType().isReferenceType()) {
            return this.parameterReference(cp);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag(PARAMETER) + this.qualifier(cp) + this.etag();
    }

    String parameter(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            Xml.append(this.parameter((CIMParameter)cp.elementAt(i)));
        }
        return Xml.toString();
    }

    String parameterReference(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag(PARAMETER_REFERENCE) + this.qualifier(cp) + this.etag();
    }

    String parameterArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag(PARAMETER_ARRAY) + this.qualifier(cp) + this.etag();
    }

    String parameterRefArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag(PARAMETER_REFARRAY) + this.qualifier(cp) + this.etag();
    }
}

