/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMVersion;
import com.sun.wbem.client.BatchCIMClient;
import com.sun.wbem.client.BatchHandle;
import com.sun.wbem.client.BatchResult;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMClientFactory;
import com.sun.wbem.client.CIMClientRMI;
import com.sun.wbem.client.CIMEvent;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.CIMOperation;
import com.sun.wbem.client.CheckSumGen;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.ClientSecurityFactory;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.RmiClientSecurity;
import com.sun.wbem.security.UserPrincipal;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class CIMClient
implements CIMOMHandle {
    private String version;
    private CIMClientAPI api;
    private CIMNameSpace nameSpace;
    protected Hashtable subIdListenerMap;
    private InetAddress host;
    private ClientSecurityContext csc = null;
    private static int protocol;
    private CheckSumGen csg = new CheckSumGen();
    private ThreadLocal tl = new ThreadLocal();
    private static final int DEBUG_OFF = 0;
    private boolean listenerset = false;
    public static final int RMI = 1;
    public static final int XML = 0;
    public static final int HTTP = 0;
    public static final boolean DEEP = true;
    public static final boolean SHALLOW = false;
    public static final int WQL = 0;
    private boolean AUTHENTICATE = true;
    private ClientListener clientListener = new ClientListener();

    public CIMClient() throws CIMException {
        this(new CIMNameSpace(), new UserPrincipal("guest"), new PasswordCredential("guest"), 1, 0);
    }

    public CIMClient(CIMNameSpace name) throws CIMException {
        this(name, new UserPrincipal("guest"), new PasswordCredential("guest"), 1, 0);
    }

    public CIMClient(CIMNameSpace name, String userName, String passwd) throws CIMException {
        this(name, new UserPrincipal(userName == null ? "guest" : userName), new PasswordCredential(passwd == null ? "guest" : passwd), 1, 0);
    }

    public CIMClient(CIMNameSpace name, String userName, String passwd, int protocol) throws CIMException {
        this(name, new UserPrincipal(userName == null ? "guest" : userName), new PasswordCredential(passwd == null ? "guest" : passwd), protocol, 0);
    }

    public CIMClient(CIMNameSpace name, Principal principal, Object credential) throws CIMException {
        this(name, principal, credential, 1, 0);
    }

    public CIMClient(CIMNameSpace name, Principal principal, Object credential, int protocol) throws CIMException {
        this(name, principal, credential, protocol, 0);
    }

    CIMClient(CIMNameSpace name, Principal principal, Object credential, int protocol, int debug) throws CIMException {
        String str;
        this.setProtocol(protocol);
        this.version = CIMVersion.major + "";
        if (name == null) {
            name = new CIMNameSpace();
        }
        if (principal == null) {
            principal = new UserPrincipal("guest");
        }
        if ((str = principal.getName()) == null || str.trim().length() == 0) {
            principal = new UserPrincipal("guest");
        }
        if (credential == null) {
            credential = new PasswordCredential("guest");
        }
        name.setNameSpace("\\" + name.getNameSpace());
        this.nameSpace = name;
        this.api = CIMClientFactory.getClientAPI(this.version, this.nameSpace, protocol, debug, this.clientListener);
        this.csc = ClientSecurityFactory.createClientSecurity(this.nameSpace, principal, credential, null, protocol);
        this.api.initSecurityContext(this.version, this.csc);
    }

    public synchronized void createNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.createNameSpace(this.version, this.nameSpace, ns);
    }

    public synchronized void close() throws CIMException {
        String[] oarray = new String[]{this.version, "close"};
        this.api.close(this.version);
    }

    public synchronized void deleteNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.deleteNameSpace(this.version, this.nameSpace, ns);
    }

    public synchronized void deleteClass(CIMObjectPath path) throws CIMException {
        this.api.deleteClass(this.version, this.nameSpace, path);
    }

    public synchronized void deleteInstance(CIMObjectPath path) throws CIMException {
        this.api.deleteInstance(this.version, this.nameSpace, path);
    }

    public synchronized void deleteQualifierType(CIMObjectPath path) throws CIMException {
        this.api.deleteQualifierType(this.version, this.nameSpace, path);
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumNameSpace(this.version, this.nameSpace, path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Vector v = this.api.enumerateClasses(this.version, this.nameSpace, path, deep, localOnly, includeQualifiers, includeClassOrigin);
        return v.elements();
    }

    public synchronized Enumeration enumClass(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        Vector v = this.api.enumClass(this.version, this.nameSpace, path, deep, localOnly);
        return v.elements();
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumerateClassNames(this.version, this.nameSpace, path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumClass(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumClass(this.version, this.nameSpace, path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath path) throws CIMException {
        Vector v = this.api.enumerateInstanceNames(this.version, this.nameSpace, path);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.enumerateInstances(this.version, this.nameSpace, path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumInstances(this.version, this.nameSpace, path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        Vector v = this.api.enumInstances(this.version, this.nameSpace, path, deep, localOnly);
        return v.elements();
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath path) throws CIMException {
        Vector v = this.api.enumQualifierTypes(this.version, this.nameSpace, path);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getClass(this.version, this.nameSpace, name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getInstance(this.version, this.nameSpace, name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public synchronized CIMClass getClass(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.api.getClass(this.version, this.nameSpace, name, localOnly);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.api.getInstance(this.version, this.nameSpace, name, localOnly);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath name, String methodName, Vector inParams, Vector outParams) throws CIMException {
        return this.api.invokeMethod(this.version, this.nameSpace, name, methodName, inParams, outParams);
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath name) throws CIMException {
        return this.api.getQualifierType(this.version, this.nameSpace, name);
    }

    public synchronized void createQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.api.createQualifierType(this.version, this.nameSpace, name, qt);
    }

    public synchronized void setQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.api.setQualifierType(this.version, this.nameSpace, name, qt);
    }

    public synchronized void createClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        this.api.createClass(this.version, this.nameSpace, name, cc);
    }

    public synchronized void setClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        this.api.setClass(this.version, this.nameSpace, name, cc);
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        return this.api.createInstance(this.version, this.nameSpace, name, ci);
    }

    public synchronized void setInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        this.api.setInstance(this.version, this.nameSpace, name, ci);
    }

    public synchronized CIMValue getProperty(CIMObjectPath name, String propertyName) throws CIMException {
        return this.api.getProperty(this.version, this.nameSpace, name, propertyName);
    }

    public synchronized void setProperty(CIMObjectPath name, String propertyName, CIMValue newValue) throws CIMException {
        this.api.setProperty(this.version, this.nameSpace, name, propertyName, newValue);
    }

    public String encryptData(String clearData) throws CIMException {
        if (clearData == null) {
            return null;
        }
        RmiClientSecurity rcs = null;
        try {
            rcs = (RmiClientSecurity)this.csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String sval = rcs.trans51Format(clearData);
        return "<" + sval + ">";
    }

    public synchronized Enumeration execQuery(CIMObjectPath name, String query, int ql) throws CIMException {
        Vector v = this.api.execQuery(this.version, this.nameSpace, name, query, ql);
        return v.elements();
    }

    public Enumeration associators(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.associators(this.version, this.nameSpace, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration associatorNames(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        Vector v = this.api.associatorNames(this.version, this.nameSpace, objectName, assocClass, resultClass, role, resultRole);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public Enumeration references(CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.references(this.version, this.nameSpace, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration referenceNames(CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        Vector v = this.api.referenceNames(this.version, this.nameSpace, objectName, resultClass, role);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMListener(CIMListener l) throws CIMException {
        if (protocol == 1 && !this.listenerset) {
            CIMClient cIMClient = this;
            synchronized (cIMClient) {
                if (!this.listenerset) {
                    ((CIMClientRMI)this.api).setListener(this.version);
                    this.listenerset = true;
                }
            }
        }
        this.clientListener.addCIMListener(l);
    }

    public void removeCIMListener(CIMListener l) throws CIMException {
        this.clientListener.removeCIMListener(l);
    }

    protected void finalize() {
    }

    private int getProtocol() {
        return protocol;
    }

    private void setProtocol(int protocol) {
        CIMClient.protocol = protocol;
    }

    static String stripNS(String ns1, String ns2) {
        if ((ns1 = ns1.toLowerCase()).startsWith(ns2 = ns2.toLowerCase())) {
            String relNS = ns1.substring(ns2.length());
            if (relNS.startsWith("\\")) {
                return relNS.substring(1);
            }
            return relNS;
        }
        return ns1;
    }

    public BatchResult performBatchOperations(BatchHandle bc) throws CIMException {
        CIMOperation[] oplist = null;
        try {
            oplist = ((BatchCIMClient)bc).getOperationList();
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ex);
        }
        if (oplist != null && oplist.length > 0) {
            for (int i = 0; i < oplist.length; ++i) {
                oplist[i].setNameSpace(this.getNameSpace());
            }
            Vector v = this.api.performOperations(this.version, oplist);
            Object[] arr = new Object[v.size()];
            arr = v.toArray();
            BatchResult br = new BatchResult(arr);
            return br;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    protected CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    private class ClientListener
    implements CIMListener {
        private List listenerList = new ArrayList();

        private ClientListener() {
        }

        public void addCIMListener(CIMListener l) {
            if (l == null) {
                return;
            }
            if (!this.listenerList.contains(l)) {
                this.listenerList.add(l);
            }
        }

        public void removeCIMListener(CIMListener l) {
            this.listenerList.remove(l);
        }

        public void indicationOccured(CIMEvent e) {
            new IndicationDeliverer(e).start();
        }

        private class IndicationDeliverer
        extends Thread {
            CIMEvent e;

            IndicationDeliverer(CIMEvent e) {
                this.e = e;
            }

            public void run() {
                ArrayList l = new ArrayList(ClientListener.this.listenerList);
                for (CIMListener listener : l) {
                    listener.indicationOccured(this.e);
                }
            }
        }
    }
}

