/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.client.CIMDefaultProperties;
import com.sun.wbem.client.CIMStaticProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public final class ClientProps {
    private static Properties props = null;
    private static final String PROP_DEFAULT_FILE = "com.sun.wbem.client.WbemDefaults";

    public static String getProperty(String name) {
        if (props == null) {
            ClientProps.initProps();
        }
        return props.getProperty(name);
    }

    public static String[] getPropertyList(String name) {
        if (props == null) {
            ClientProps.initProps();
        }
        int i = 0;
        boolean sw = true;
        Vector<String> vec = new Vector<String>();
        String prefix = name.concat(".");
        while (sw) {
            String key = prefix + i;
            try {
                String val = props.getProperty(key);
                if (val == null) {
                    sw = false;
                } else {
                    vec.addElement(val);
                }
            }
            catch (Exception ex) {
                sw = false;
            }
            ++i;
        }
        Object[] values = null;
        if (vec.size() > 0) {
            values = new String[vec.size()];
            vec.copyInto(values);
        }
        return values;
    }

    public static Enumeration getPropertyNames() {
        if (props == null) {
            ClientProps.initProps();
        }
        return props.propertyNames();
    }

    static void dumpClientProps() {
        if (props != null) {
            System.out.println("Client configuration properties:");
            Enumeration en = ClientProps.getPropertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = ClientProps.getProperty(key);
                System.out.println("    " + key + " \t" + val);
            }
        }
    }

    private static void initProps() {
        String val;
        String key;
        int i;
        props = new Properties();
        Hashtable<String, String> staticList = new Hashtable<String, String>();
        CIMStaticProperties sp = new CIMStaticProperties();
        CIMDefaultProperties dp = new CIMDefaultProperties();
        Object[][] data = sp.getContents();
        if (data != null) {
            for (i = 0; i < data.length; ++i) {
                key = (String)data[i][0];
                val = (String)data[i][1];
                props.setProperty(key, val);
                staticList.put(key, val);
            }
        }
        if ((data = dp.getContents()) != null) {
            for (i = 0; i < data.length; ++i) {
                key = (String)data[i][0];
                val = (String)data[i][1];
                if (ClientProps.propExists(key, staticList)) continue;
                props.setProperty(key, val);
            }
        }
        ClientProps.loadProps(PROP_DEFAULT_FILE, staticList);
    }

    private static void loadProps(String file, Hashtable revokeList) {
        Locale lc = new Locale("", "");
        PropertyResourceBundle prb = null;
        try {
            prb = (PropertyResourceBundle)ResourceBundle.getBundle(file, lc);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String value = null;
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                try {
                    value = prb.getString(key);
                }
                catch (Exception ex) {
                    key = null;
                }
                if (key == null || ClientProps.propExists(key, revokeList)) continue;
                props.setProperty(key, value);
            }
        }
    }

    private static boolean propExists(String key, Hashtable list) {
        String str;
        int i;
        if (list.get(key) != null) {
            return true;
        }
        try {
            i = key.lastIndexOf(46);
            if (i > 0) {
                str = key.substring(i + 1);
                Integer n = new Integer(str);
            }
        }
        catch (Exception ex) {
            return false;
        }
        str = key.substring(0, i) + ".0";
        return list.get(str) != null;
    }
}

