/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.AuthenticationInfo;
import com.sun.wbem.client.http.BasicAuthentication;
import com.sun.wbem.client.http.DigestAuthentication;
import com.sun.wbem.client.http.EmptyInputStream;
import com.sun.wbem.client.http.GetPropertyAction;
import com.sun.wbem.client.http.Handler;
import com.sun.wbem.client.http.HeaderParser;
import com.sun.wbem.client.http.HttpAuthenticator;
import com.sun.wbem.client.http.HttpClient;
import com.sun.wbem.client.http.HttpURLConnection;
import com.sun.wbem.client.http.MessageHeader;
import com.sun.wbem.client.http.ProgressData;
import com.sun.wbem.client.http.ProgressEntry;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Date;

public class HttpExURLConnection
extends URLConnection {
    protected String method = "GET";
    protected int responseCode = -1;
    protected String responseMessage = null;
    private static boolean followRedirects = true;
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "M-POST"};
    static final String version = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    public static final String userAgent = (String)AccessController.doPrivileged(new GetPropertyAction("http.agent", "Java" + version));
    static final String httpVersion = "HTTP/1.0";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    static final int maxRedirects = 5;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests;
    protected ProgressEntry pe;
    private MessageHeader responses;
    private InputStream inputStream = null;
    private ByteArrayOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private boolean shouldFollowRedirects = true;
    private String request_headers = null;
    private boolean debug = false;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    protected HttpExURLConnection(URL u) {
        super(u);
    }

    public static void setFollowRedirects(boolean set) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkSetFactory();
        }
        followRedirects = set;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equals(method)) continue;
            this.method = method;
            return;
        }
        throw new ProtocolException("Invalid HTTP method: " + method);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        this.getInputStream();
        String resp = this.getHeaderField(0);
        try {
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            this.responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
            this.responseMessage = resp.substring(ind + 4).trim();
            return this.responseCode;
        }
        catch (Exception e) {
            return this.responseCode;
        }
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.responseMessage;
    }

    public Permission getPermission() throws IOException {
        int port = this.url.getPort();
        port = port < 0 ? 80 : port;
        String host = this.url.getHost() + ":" + port;
        SocketPermission permission = new SocketPermission(host, "connect");
        return permission;
    }

    public InputStream getErrorStream() {
        return null;
    }

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final InetAddress addr, final int port, final String protocol, final String prompt, final String scheme) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(addr, port, protocol, prompt, scheme);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            AuthenticationInfo sauth;
            long modTime;
            AuthenticationInfo pauth;
            this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.requests.setIfNotSet("User-Agent", userAgent);
            int port = this.url.getPort();
            String host = this.url.getHost();
            if (port != -1 && port != 80) {
                host = host + ":" + String.valueOf(port);
            }
            this.requests.setIfNotSet("Host", host);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.requests.set("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.requests.set("Connection", "keep-alive");
                }
            }
            if (this.http.usingProxy && (pauth = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && pauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(pauth.getHeaderName(), pauth.getHeaderValue());
            }
            if ((modTime = this.getIfModifiedSince()) != 0L) {
                Date date = new Date(modTime);
                this.requests.setIfNotSet("If-Modified-Since", date.toGMTString());
            }
            if ((sauth = AuthenticationInfo.getServerAuth(this.url)) != null && sauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(sauth.getHeaderName(), sauth.getHeaderValue());
            }
            if (this.poster != null) {
                ByteArrayOutputStream byteArrayOutputStream = this.poster;
                synchronized (byteArrayOutputStream) {
                    if (!this.method.equals("PUT")) {
                        String type = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-type", type);
                    }
                    this.requests.set("Content-length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        if (this.debug) {
            String key = null;
            this.request_headers = this.getRequestPropertyKey(0);
            int i = 1;
            while ((key = this.getRequestPropertyKey(i)) != null) {
                this.request_headers = this.request_headers + "\n" + key + ": " + this.getRequestProperty(key);
                ++i;
            }
            this.request_headers = this.request_headers + "\n";
        }
        this.http.writeRequests(this.requests);
        if (this.poster != null) {
            this.poster.writeTo(this.ps);
            this.ps.flush();
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.requests = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected HttpClient getNewClient(URL url) throws IOException {
        return new HttpClient(url, null, -1);
    }

    protected HttpClient getProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        return new HttpClient(url, proxyHost, proxyPort);
    }

    protected HttpExURLConnection(URL u, Handler handler) throws IOException {
        super(u);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.handler = handler;
    }

    public HttpExURLConnection(URL u, String host, int port) throws IOException {
        this(u, new Handler(host, port));
    }

    public static void setDefaultAuthenticator(HttpAuthenticator a) {
        defaultAuth = a;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 305 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || base.getPort() != target.getPort() || !HttpExURLConnection.hostsEqual(base, target) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private static boolean hostsEqual(URL u1, URL u2) {
        final String h1 = u1.getHost();
        final String h2 = u2.getHost();
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        final boolean[] result = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress a1 = InetAddress.getByName(h1);
                    InetAddress a2 = InetAddress.getByName(h2);
                    result[0] = a1.equals(a2);
                }
                catch (UnknownHostException e) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return result[0];
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"M-POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new ByteArrayOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int redirects = 0;
        AuthenticationInfo serverAuthentication = null;
        AuthenticationInfo proxyAuthentication = null;
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = this.http.getInputStream();
                int respCode = this.getResponseCode();
                if (respCode == 407) {
                    if (proxyAuthentication != null) {
                        proxyAuthentication.removeFromCache();
                    }
                    if ((proxyAuthentication = this.getHttpProxyAuthentication()) != null) {
                        this.disconnect();
                        ++redirects;
                        continue;
                    }
                }
                if (respCode == 401) {
                    if (serverAuthentication != null) {
                        serverAuthentication.removeFromCache();
                    }
                    if ((serverAuthentication = this.getServerAuthentication()) != null) {
                        this.disconnect();
                        ++redirects;
                        continue;
                    }
                }
                if (respCode == 200 || respCode >= 300 && respCode <= 305) {
                    if (proxyAuthentication != null) {
                        proxyAuthentication.addToCache();
                    }
                    if (serverAuthentication != null) {
                        serverAuthentication.addToCache();
                    }
                }
                if (this.followRedirect()) {
                    ++redirects;
                    continue;
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.inputStream = new EmptyInputStream();
                    return this.inputStream;
                }
                String fname = this.url.getFile();
                if (!(respCode < 400 || fname == null || fname.endsWith(".html") || fname.endsWith(".htm") || fname.endsWith("/") || fname.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString());
                }
                return this.inputStream;
            } while (redirects < 5);
            throw new ProtocolException("Server redirected too many times (" + redirects + ")");
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo ret = null;
        String raw = this.getHeaderField("Proxy-authenticate");
        String host = this.http.getProxyHostUsed();
        int port = this.http.getProxyPortUsed();
        if (host != null && raw != null) {
            Object a;
            HeaderParser p = new HeaderParser(raw);
            String realm = p.findValue("realm");
            String scheme = p.findKey(0);
            ret = AuthenticationInfo.getProxyAuth(host, port, realm);
            if (ret == null && "basic".equalsIgnoreCase(scheme)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(host);
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
                a = HttpExURLConnection.privilegedRequestPasswordAuthentication(addr, port, "http", realm, scheme);
                if (a != null) {
                    ret = new BasicAuthentication(true, host, port, realm, (PasswordAuthentication)a);
                }
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme)) {
                try {
                    URL u = new URL("http", host, port, "/");
                    a = defaultAuth.authString(u, scheme, realm);
                    if (a != null) {
                        ret = new BasicAuthentication(true, host, port, realm, (String)a);
                    }
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
            if (ret != null && !ret.setHeaders(this, p)) {
                ret = null;
            }
        }
        return ret;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo ret = null;
        String raw = this.getHeaderField("WWW-Authenticate");
        if (raw != null) {
            Object a;
            HeaderParser p = new HeaderParser(raw);
            String realm = p.findValue("realm");
            String scheme = p.findKey(0);
            ret = AuthenticationInfo.getServerAuth(this.url, realm);
            InetAddress addr = null;
            if (ret == null) {
                try {
                    addr = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
            }
            if (ret == null && "basic".equalsIgnoreCase(scheme) && (a = HttpExURLConnection.privilegedRequestPasswordAuthentication(addr, this.url.getPort(), this.url.getProtocol(), realm, scheme)) != null) {
                ret = new BasicAuthentication(false, this.url, realm, (PasswordAuthentication)a);
            }
            if (ret == null && "digest".equalsIgnoreCase(scheme) && (a = HttpExURLConnection.privilegedRequestPasswordAuthentication(addr, this.url.getPort(), this.url.getProtocol(), realm, scheme)) != null) {
                ret = new DigestAuthentication(this.url, realm, scheme, (PasswordAuthentication)a);
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme) && (a = defaultAuth.authString(this.url, scheme, realm)) != null) {
                ret = new BasicAuthentication(false, this.url, realm, (String)a);
            }
            if (ret != null && !ret.setHeaders(this, p)) {
                ret = null;
            }
        }
        return ret;
    }

    private boolean followRedirect() throws IOException {
        if (!this.shouldFollowRedirects) {
            return false;
        }
        if (!HttpExURLConnection.getFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 305 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (stat == 305) {
            URL urlp = new URL(loc);
            this.http = this.getProxiedClient(this.url, urlp.getHost(), urlp.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, loc);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getRequestHeaders() {
        return this.request_headers;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.findValue(name);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if ("set-cookie".equalsIgnoreCase(key)) {
            this.requests.add(key, value);
        } else {
            this.requests.set(key, value);
        }
    }

    void setAuthenticationProperty(String key, String value) {
        this.requests.set(key, value);
    }

    String getRequestPropertyKey(int n) {
        return this.requests.getKey(n);
    }

    String getRequestProperty(int n) {
        return this.requests.getValue(n);
    }

    public String getRequestProperty(String key) {
        return this.requests.findValue(key);
    }

    public void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    public void setInstanceFollowRedirects(boolean shouldFollow) {
        this.shouldFollowRedirects = shouldFollow;
    }
}

