/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class I18N {
    private static String resourceBundleName = "";
    public static Locale locale = Locale.getDefault();

    public static void setResourceName(String fileName) {
        resourceBundleName = fileName;
    }

    public static String getResourceName() {
        return resourceBundleName;
    }

    public static String loadString(String ID) {
        return I18N.loadString(ID, resourceBundleName);
    }

    public static boolean isStringAvailable(String ID) {
        return I18N.isStringAvailable(ID, resourceBundleName);
    }

    public static boolean isStringAvailable(String ID, String b) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(b, locale);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(b, Locale.ENGLISH);
            }
            catch (MissingResourceException ee) {
                return false;
            }
        }
        if (bundle == null) {
            return false;
        }
        try {
            bundle.getString(ID);
        }
        catch (MissingResourceException e) {
            return false;
        }
        return true;
    }

    public static String loadString(String ID, String b) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(b, locale);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(b, Locale.ENGLISH);
            }
            catch (MissingResourceException ee) {
                System.out.println("CRITICAL ERROR: Could not load resource bundle " + b);
                System.exit(-1);
            }
        }
        if (bundle == null) {
            System.out.println("CRITICAL ERROR: Could not load resource bundle " + b);
            System.exit(-1);
            return null;
        }
        try {
            return bundle.getString(ID);
        }
        catch (MissingResourceException e) {
            System.out.println("CRITICAL ERROR: Could not load ID " + ID + " resource bundle " + b);
            System.exit(-1);
            return null;
        }
    }

    public static String loadStringFormat(String ID, Vector values, String b) {
        String msgString = I18N.loadString(ID, b);
        int numItems = values.size();
        if (msgString != null) {
            Object[] arguments = new Object[numItems];
            for (int i = 0; i < numItems; ++i) {
                arguments[i] = values.elementAt(i);
            }
            return MessageFormat.format(msgString, arguments);
        }
        return null;
    }

    public static String loadStringFormat(String ID, Vector values) {
        return I18N.loadStringFormat(ID, values, resourceBundleName);
    }

    public static String loadStringFormat(String ID, Object[] values, String b) {
        String msgString = I18N.loadString(ID, b);
        if (msgString != null) {
            return MessageFormat.format(msgString, values);
        }
        return null;
    }

    public static String loadStringFormat(String ID, Object[] values) {
        return I18N.loadStringFormat(ID, values, resourceBundleName);
    }

    public static String loadStringFormat(String ID, Object arg1) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(arg1);
        return I18N.loadStringFormat(ID, v);
    }

    public static String loadStringFormat(String ID, Object arg1, Object arg2) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(arg1);
        v.addElement(arg2);
        return I18N.loadStringFormat(ID, v);
    }
}

