/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import com.sun.web.util.WebappImport;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntImport
extends Task {
    private static final String TASK_NAME = "jwc_import";
    private static final String TASK_TYPE = "console";
    private static final String JATO_LIST = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "jato.imports";
    private static final String FACES_LIST = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "faces.imports";
    private String consoledir = null;
    private String basedir = null;
    private String importdir = null;
    private String jatoListPath = null;
    private String facesListPath = null;
    private boolean bJato = false;
    private boolean bFaces = true;
    private Target target = null;
    private Project project = null;
    private WebUtilLogger logger = null;

    public void init() throws BuildException {
        this.project = super.getProject();
        if (this.project != null) {
            File file = this.project.getBaseDir();
            if (file != null) {
                this.basedir = file.getAbsolutePath();
            }
            this.consoledir = this.project.getProperty("com.sun.web.console.home");
            if (this.consoledir != null) {
                this.importdir = this.consoledir + WebUtilConstants.IMPORT_SUBDIR;
                this.jatoListPath = this.consoledir + JATO_LIST;
                this.facesListPath = this.consoledir + FACES_LIST;
            }
        }
        this.logger = new WebUtilLogger(this);
    }

    public void setBasedir(File file) {
        this.basedir = file.getAbsolutePath();
    }

    public void setConsoledir(File file) {
        this.consoledir = file.getAbsolutePath();
        if (this.consoledir != null) {
            this.importdir = this.consoledir + WebUtilConstants.IMPORT_SUBDIR;
            this.jatoListPath = this.consoledir + JATO_LIST;
            this.facesListPath = this.consoledir + FACES_LIST;
        }
    }

    public void setJato(boolean bl) {
        this.bJato = bl;
    }

    public void setFaces(boolean bl) {
        this.bFaces = bl;
    }

    public void execute() throws BuildException {
        WebUtilException webUtilException = new WebUtilException("ant_err_01");
        String string = webUtilException.getLocalizedMessage();
        if (this.basedir == null || this.basedir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_02");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.consoledir == null || this.consoledir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_03");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        File file = new File(this.jatoListPath);
        File file2 = new File(this.facesListPath);
        if (!file.exists() || !file2.exists()) {
            webUtilException = new WebUtilException("import_err_02");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        webUtilException = new WebUtilException("import_err_04");
        this.logger.log(webUtilException.getLocalizedMessage(), 2);
        int n = 0;
        try {
            WebappImport webappImport = new WebappImport(this.consoledir, this.logger);
            if (this.bJato) {
                webappImport.copyResources(this.importdir, this.basedir, this.jatoListPath);
            }
            if (this.bFaces) {
                webappImport.copyResources(this.importdir, this.basedir, this.facesListPath);
            }
        }
        catch (Exception exception) {
            webUtilException = new WebUtilException("import_err_05", exception.getLocalizedMessage());
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            n = 2;
        }
        if (n == 2) {
            throw new BuildException(string);
        }
    }

    public String getTaskname() {
        return TASK_NAME;
    }

    public String getTaskType() {
        return TASK_TYPE;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_102");
        return webUtilException.getLocalizedMessage();
    }
}

