/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.ProductImageUtility;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntProductImage
extends Task {
    private static final String TASK_NAME = "jwc_validate";
    private static final String TASK_TYPE = "console";
    private static final String WEB_INF_SUBDIR = "WEB-INF";
    private String type = "all";
    private String consoledir = null;
    private String basedir = null;
    private String name = null;
    private String outdir = null;
    private String resfile = null;
    private Target target = null;
    private Project project = null;
    private WebUtilLogger logger = null;

    public void init() throws BuildException {
        this.project = super.getProject();
        if (this.project != null) {
            File file = this.project.getBaseDir();
            if (file != null) {
                this.basedir = file.getAbsolutePath();
                this.outdir = this.basedir + File.separator + WebUtilConstants.IMAGE_SUBDIR;
            }
            this.consoledir = this.project.getProperty("com.sun.web.console.home");
        }
        this.logger = new WebUtilLogger(this);
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setBasedir(File file) {
        this.basedir = file.getAbsolutePath();
        File file2 = new File(this.basedir + File.separator + WEB_INF_SUBDIR);
        this.outdir = file2.exists() && file2.isDirectory() ? this.basedir + File.separator + WebUtilConstants.IMAGE_SUBDIR : this.basedir;
    }

    public void setConsoledir(File file) {
        this.consoledir = file.getAbsolutePath();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setResource(String string) {
        this.resfile = string;
    }

    public void execute() throws BuildException {
        WebUtilException webUtilException = new WebUtilException("ant_err_01");
        String string = webUtilException.getLocalizedMessage();
        if (this.type == null || this.type.trim().length() == 0) {
            webUtilException = new WebUtilException("image_err_01");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.basedir == null || this.basedir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_02");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.consoledir == null || this.consoledir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_03");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        String string2 = null;
        if (this.name == null || this.name.trim().length() == 0) {
            string2 = this.basedir + File.separator + WEB_INF_SUBDIR + File.separator + "app.xml";
            this.name = null;
        }
        webUtilException = new WebUtilException("image_err_21");
        this.logger.log(webUtilException.getLocalizedMessage(), 2);
        int n = 0;
        try {
            ProductImageUtility productImageUtility = new ProductImageUtility(this.consoledir, this.resfile);
            if (string2 != null) {
                productImageUtility.createImagesFromAppxml(this.type, string2, this.outdir);
            } else if (this.name != null) {
                productImageUtility.createImagesFromNames(this.type, this.name, this.outdir);
            }
        }
        catch (Exception exception) {
            webUtilException = new WebUtilException("image_err_20", exception.getLocalizedMessage());
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            n = 2;
        }
        if (n == 2) {
            throw new BuildException(string);
        }
    }

    public String getTaskname() {
        return TASK_NAME;
    }

    public String getTaskType() {
        return TASK_TYPE;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_101");
        return webUtilException.getLocalizedMessage();
    }
}

