/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.registration.RegistrationInfo;
import com.sun.web.util.AppXmlChecker;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import com.sun.web.util.WebXmlChecker;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntXmlChecker
extends Task {
    private static final String TASK_NAME = "jwc_validate";
    private static final String TASK_TYPE = "console";
    private static final String ALL_TYPE = "all";
    private static final String APP_TYPE = "app";
    private static final String WEB_TYPE = "web";
    private static final String WEB_INF_SUBDIR = "WEB-INF";
    private static final String CHECK_FILE_PATH = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "app_checkfile";
    private String type = "all";
    private String consoledir = null;
    private String basedir = null;
    private String checkfile = null;
    private boolean bJato = false;
    private boolean bFaces = true;
    private Target target = null;
    private Project project = null;
    private WebUtilLogger logger = null;

    public void init() throws BuildException {
        this.bJato = false;
        this.bFaces = true;
        this.project = super.getProject();
        if (this.project != null) {
            File file = this.project.getBaseDir();
            if (file != null) {
                this.basedir = file.getAbsolutePath();
            }
            this.consoledir = this.project.getProperty("com.sun.web.console.home");
            if (this.consoledir != null) {
                this.checkfile = this.consoledir + CHECK_FILE_PATH;
            }
        }
        this.logger = new WebUtilLogger(this);
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setBasedir(File file) {
        this.basedir = file.getAbsolutePath();
    }

    public void setConsoledir(File file) {
        this.consoledir = file.getAbsolutePath();
        if (this.checkfile == null) {
            this.checkfile = this.consoledir + CHECK_FILE_PATH;
        }
    }

    public void setCheckfile(File file) {
        this.checkfile = file.getAbsolutePath();
    }

    public void setJato(boolean bl) {
        this.bJato = bl;
    }

    public void setFaces(boolean bl) {
        this.bFaces = bl;
    }

    public void execute() throws BuildException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        WebUtilException webUtilException = new WebUtilException("ant_err_01");
        String string = webUtilException.getLocalizedMessage();
        if (this.type == null || this.type.trim().length() == 0) {
            webUtilException = new WebUtilException("check_err_01");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.type.equals(APP_TYPE)) {
            bl = true;
        } else if (this.type.equals(WEB_TYPE)) {
            bl2 = true;
        } else if (this.type.equals(ALL_TYPE)) {
            bl = true;
            bl2 = true;
        } else {
            webUtilException = new WebUtilException("check_err_26", this.type);
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.basedir == null || this.basedir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_02");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        if (this.consoledir == null || this.consoledir.length() == 0) {
            webUtilException = new WebUtilException("ant_err_03");
            this.logger.log(webUtilException.getLocalizedMessage(), 0);
            throw new BuildException(string, (Throwable)((Object)webUtilException));
        }
        String string2 = this.basedir + File.separator + WEB_INF_SUBDIR + File.separator + "app.xml";
        String string3 = this.basedir + File.separator + WEB_INF_SUBDIR + File.separator + "web.xml";
        int n = 0;
        if (bl) {
            webUtilException = new WebUtilException("check_err_27", "app.xml");
            this.logger.log(webUtilException.getLocalizedMessage(), 2);
            RegistrationInfo registrationInfo = null;
            object = null;
            try {
                object = new AppXmlChecker(this.consoledir, this.logger);
                registrationInfo = ((AppXmlChecker)object).parse(true, string2);
                if (n < 2) {
                    n = ((AppXmlChecker)object).check(registrationInfo);
                }
            }
            catch (Exception exception) {
                webUtilException = new WebUtilException("check_err_25", "app.xml", exception.getLocalizedMessage());
                this.logger.log(webUtilException.getLocalizedMessage(), 0);
                n = 2;
            }
        }
        int n2 = 0;
        if (bl2) {
            webUtilException = new WebUtilException("check_err_27", "web.xml");
            this.logger.log(webUtilException.getLocalizedMessage(), 2);
            object = null;
            try {
                object = new WebXmlChecker(this.checkfile, this.consoledir, this.logger);
                n2 = ((WebXmlChecker)object).parse(true, string3);
                if (n2 < 2) {
                    n2 = ((WebXmlChecker)object).check(this.bJato, this.bFaces);
                }
            }
            catch (Exception exception) {
                webUtilException = new WebUtilException("check_err_25", "web.xml", exception.getLocalizedMessage());
                this.logger.log(webUtilException.getLocalizedMessage(), 0);
                n2 = 2;
            }
        }
        if (n == 2 || n2 == 2) {
            throw new BuildException(string);
        }
    }

    public String getTaskname() {
        return TASK_NAME;
    }

    public String getTaskType() {
        return TASK_TYPE;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_100");
        return webUtilException.getLocalizedMessage();
    }
}

