/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.AttributedString;
import javax.imageio.ImageIO;

public class GenerateProductImage {
    private static final String TM_SEQ = "(tm)";
    private static final String CR_SEQ = "(cr)";
    private static final String tms = String.valueOf('\u2122');
    private Font fontPrimary;
    private Font fontPrimaryFirstLine;
    private Font fontPrimarySecondLine;
    private Font fontVersionFirstLine;
    private Font fontVersionSecondLine;
    private Font fontSecondary;
    private Font fontVersion;
    private String fontLocation = null;
    private String fontVersionLocation = null;
    private static final String FONT_SUPPORT_1 = "com/sun/web/util/resources/ProductNameSupport.bin";
    private static final String FONT_SUPPORT_2 = "com/sun/web/util/resources/ProductNameSupport2.bin";
    private float primaryFontSize = 21.0f;
    private float primaryFirstLineSize = 21.0f;
    private float primarySecondLineSize = 16.0f;
    private float versionFirstLineSize = this.primaryFirstLineSize;
    private float versionSecondLineSize = this.primarySecondLineSize;
    private float secondaryFontSize = this.primaryFontSize;
    private float versionFontSize = this.primaryFontSize;
    private int primaryLeading = 2;
    private int primary2LineLeading = 2;
    private int secondaryLeading = 7;
    private int versionLeading = this.primaryLeading;
    private Color primaryForegroundColor;
    private Color secondaryForegroundColor = this.primaryForegroundColor = Color.white;
    private Color versionForegroundColor = new Color(73, 119, 130);
    private Color primaryBackgroundColor;
    private Color secondaryBackgroundColor = this.primaryBackgroundColor = new Color(80, 98, 112, 0);
    private Color versionBackgroundColor = new Color(255, 255, 255);
    private Color stupidJavaGrayColor = new Color(130, 140, 153);
    private int primaryWidth = 245;
    private int primaryHeight = 40;
    private int secondaryWidth = 245;
    private int secondaryHeight = 40;
    private int versionWidth = 245;
    private int versionHeight = 40;
    private boolean bInit = false;
    private BufferedImage referenceBI = new BufferedImage(1, 1, 2);
    private Graphics2D reference2D = this.referenceBI.createGraphics();

    public void initialize() {
        if (!this.bInit) {
            this.InitializeFonts();
            this.Initialize2D();
            this.bInit = true;
        }
    }

    public static void main(String[] stringArray) {
        GenerateProductImage generateProductImage = new GenerateProductImage();
        generateProductImage.GenerateImages(stringArray[0], stringArray[1]);
    }

    public void GenerateImages(String string, String string2) {
        this.initialize();
        String string3 = string + "//";
        this.GeneratePrimaryImageDebug(string3 + "primary.png", string2);
        this.GenerateSecondaryImageDebug(string3 + "secondary.png", string2);
        this.GenerateVersionImageDebug(string3 + "version.png", string2);
    }

    public BufferedImage GenerateImage(String string, String string2, Font font, Font font2, Color color, Color color2, int n, int n2, int n3) {
        this.initialize();
        this.Initialize2D();
        BufferedImage bufferedImage = null;
        if (string2 == null) {
            AttributedString attributedString = new AttributedString(string);
            this.SetAttributedStrings(attributedString, font, color, color2);
            this.SetColorForSpecialStrings(string, attributedString, font);
            this.SetFontAndColors(font, color, color2);
            FontRenderContext fontRenderContext = this.reference2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            int n4 = (int)rectangle2D.getWidth();
            bufferedImage = new BufferedImage(n4, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHints(this.reference2D.getRenderingHints());
            textLayout.draw(graphics2D, 0.0f, (float)rectangle2D.getHeight() + 1.0f + (float)n3 - textLayout.getDescent());
        } else {
            AttributedString attributedString = new AttributedString(string);
            this.SetAttributedStrings(attributedString, font, color, color2);
            this.SetColorForSpecialStrings(string, attributedString, font);
            this.SetFontAndColors(font, color, color2);
            FontRenderContext fontRenderContext = this.reference2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            int n5 = (int)rectangle2D.getWidth();
            AttributedString attributedString2 = null;
            TextLayout textLayout2 = null;
            Rectangle2D rectangle2D2 = null;
            attributedString2 = new AttributedString(string2);
            this.SetAttributedStrings(attributedString2, font2, color, color2);
            this.SetFontAndColors(font2, color, color2);
            FontRenderContext fontRenderContext2 = this.reference2D.getFontRenderContext();
            textLayout2 = new TextLayout(attributedString2.getIterator(), fontRenderContext);
            rectangle2D2 = textLayout2.getBounds();
            int n6 = (int)rectangle2D2.getWidth();
            if (n5 < n6) {
                n5 = n6;
            }
            bufferedImage = new BufferedImage(n5, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHints(this.reference2D.getRenderingHints());
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n5, n2);
            graphics2D.setColor(color);
            textLayout.draw(graphics2D, 0.0f, (float)rectangle2D.getHeight() - textLayout.getDescent());
            textLayout2.draw(graphics2D, 0.0f, (float)n2 - textLayout2.getDescent());
        }
        return bufferedImage;
    }

    public BufferedImage GeneratePrimaryImage(String string) {
        BufferedImage bufferedImage = null;
        this.initialize();
        String[] stringArray = this.splitName(this.fixName(string));
        bufferedImage = stringArray.length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontPrimaryFirstLine, this.fontPrimarySecondLine, this.primaryForegroundColor, this.primaryBackgroundColor, this.primaryWidth, this.primaryHeight, this.primary2LineLeading) : this.GenerateImage(stringArray[0], null, this.fontPrimary, null, this.primaryForegroundColor, this.primaryBackgroundColor, this.primaryWidth, this.primaryHeight, this.primaryLeading);
        return bufferedImage;
    }

    public void GeneratePrimaryImageDebug(String string, String string2) {
        this.initialize();
        this.SaveImage(string, this.GeneratePrimaryImage(string2));
    }

    public BufferedImage GenerateSecondaryImage(String string) {
        this.initialize();
        String string2 = this.fixName(string);
        return this.GenerateImage(string2, null, this.fontSecondary, null, this.secondaryForegroundColor, this.secondaryBackgroundColor, this.secondaryWidth, this.secondaryHeight, this.secondaryLeading);
    }

    public void GenerateSecondaryImageDebug(String string, String string2) {
        this.initialize();
        this.SaveImage(string, this.GenerateSecondaryImage(string2));
    }

    public BufferedImage GenerateVersionImage(String string) {
        BufferedImage bufferedImage = null;
        this.initialize();
        String[] stringArray = this.splitName(this.fixName(string));
        bufferedImage = stringArray.length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontVersionFirstLine, this.fontVersionSecondLine, this.versionForegroundColor, this.versionBackgroundColor, this.versionWidth, this.versionHeight, this.primary2LineLeading) : this.GenerateImage(stringArray[0], null, this.fontVersion, null, this.versionForegroundColor, this.versionBackgroundColor, this.versionWidth, this.versionHeight, this.versionLeading);
        return bufferedImage;
    }

    public void GenerateVersionImageDebug(String string, String string2) {
        this.SaveImage(string, this.GenerateVersionImage(string2));
    }

    private void SaveImage(String string, BufferedImage bufferedImage) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (Exception exception) {
            System.out.println("Error writing image");
        }
    }

    private void InitializeFonts() {
        try {
            Serializable serializable;
            Object object;
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            if (this.fontLocation == null) {
                object = this.getClass().getClassLoader();
                inputStream = ((ClassLoader)object).getResourceAsStream(FONT_SUPPORT_1);
                inputStream2 = ((ClassLoader)object).getResourceAsStream(FONT_SUPPORT_2);
            } else {
                object = new File(this.fontLocation);
                inputStream = new FileInputStream((File)object);
                serializable = new File(this.fontVersionLocation);
                inputStream2 = new FileInputStream((File)serializable);
            }
            if (inputStream == null) {
                System.out.println("Font resource is null");
            }
            if (inputStream2 == null) {
                System.out.println("Font2 resource is null");
            }
            object = Font.createFont(0, inputStream);
            serializable = Font.createFont(0, inputStream2);
            this.fontPrimary = ((Font)object).deriveFont(this.primaryFontSize);
            this.fontPrimaryFirstLine = ((Font)object).deriveFont(this.primaryFirstLineSize);
            this.fontPrimarySecondLine = ((Font)object).deriveFont(this.primarySecondLineSize);
            this.fontVersionFirstLine = ((Font)serializable).deriveFont(this.primaryFirstLineSize);
            this.fontVersionSecondLine = ((Font)serializable).deriveFont(this.primarySecondLineSize);
            this.fontSecondary = ((Font)object).deriveFont(this.secondaryFontSize);
            this.fontVersion = ((Font)serializable).deriveFont(this.versionFontSize);
            inputStream.close();
            inputStream2.close();
        }
        catch (Exception exception) {
            System.out.println("Problem initializing Fonts");
            exception.printStackTrace();
        }
    }

    private void Initialize2D() {
        this.reference2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.reference2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.reference2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    private void SetFontAndColors(Font font, Color color, Color color2) {
        this.reference2D.setFont(font);
        this.reference2D.setColor(color);
        this.reference2D.setBackground(color2);
    }

    private void SetAttributedStrings(AttributedString attributedString, Font font, Color color, Color color2) {
        attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        attributedString.addAttribute(TextAttribute.BACKGROUND, color2);
        attributedString.addAttribute(TextAttribute.FONT, font);
    }

    private void SetColorForSpecialStrings(String string, AttributedString attributedString, Font font) {
        if ((font == this.fontVersion || font == this.fontVersionFirstLine) && string.startsWith("Java" + tms)) {
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.stupidJavaGrayColor, 0, 5);
        }
    }

    private String fixName(String string) {
        String string2 = string;
        int n = string.indexOf(TM_SEQ);
        if (n >= 0) {
            string2 = string.substring(0, n) + tms;
            int n2 = n + TM_SEQ.length();
            if (n2 < string.length()) {
                string2 = string2 + string.substring(n2);
            }
        }
        return string2;
    }

    private String[] splitName(String string) {
        String[] stringArray = new String[]{string, null};
        int n = string.indexOf(CR_SEQ);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n);
            int n2 = n + CR_SEQ.length();
            if (n2 < string.length()) {
                stringArray[1] = string.substring(n2);
            }
        }
        return stringArray;
    }

    public Font getFontPrimary() {
        return this.fontPrimary;
    }

    public void setFontPrimary(Font font) {
        this.fontPrimary = font;
    }

    public Font getFontSecondary() {
        return this.fontSecondary;
    }

    public void setFontSecondary(Font font) {
        this.fontSecondary = font;
    }

    public Font getFontVersion() {
        return this.fontVersion;
    }

    public void setFontVersion(Font font) {
        this.fontVersion = font;
    }

    public Color getPrimaryBackgroundColor() {
        return this.primaryBackgroundColor;
    }

    public void setPrimaryBackgroundColor(Color color) {
        this.primaryBackgroundColor = color;
    }

    public float getPrimaryFontSize() {
        return this.primaryFontSize;
    }

    public void setPrimaryFontSize(float f) {
        this.primaryFontSize = f;
    }

    public Color getPrimaryForegroundColor() {
        return this.primaryForegroundColor;
    }

    public void setPrimaryForegroundColor(Color color) {
        this.primaryForegroundColor = color;
    }

    public int getPrimaryHeight() {
        return this.primaryHeight;
    }

    public void setPrimaryHeight(int n) {
        this.primaryHeight = n;
    }

    public float getPrimarySecondLineSize() {
        return this.primarySecondLineSize;
    }

    public void setPrimarySecondLineSize(float f) {
        this.primarySecondLineSize = f;
    }

    public int getPrimaryWidth() {
        return this.primaryWidth;
    }

    public void setPrimaryWidth(int n) {
        this.primaryWidth = n;
    }

    public Color getSecondaryBackgroundColor() {
        return this.secondaryBackgroundColor;
    }

    public void setSecondaryBackgroundColor(Color color) {
        this.secondaryBackgroundColor = color;
    }

    public float getSecondaryFontSize() {
        return this.secondaryFontSize;
    }

    public void setSecondaryFontSize(float f) {
        this.secondaryFontSize = f;
    }

    public Color getSecondaryForegroundColor() {
        return this.secondaryForegroundColor;
    }

    public void setSecondaryForegroundColor(Color color) {
        this.secondaryForegroundColor = color;
    }

    public int getSecondaryHeight() {
        return this.secondaryHeight;
    }

    public void setSecondaryHeight(int n) {
        this.secondaryHeight = n;
    }

    public int getSecondaryWidth() {
        return this.secondaryWidth;
    }

    public void setSecondaryWidth(int n) {
        this.secondaryWidth = n;
    }

    public Color getVersionBackgroundColor() {
        return this.versionBackgroundColor;
    }

    public void setVersionBackgroundColor(Color color) {
        this.versionBackgroundColor = color;
    }

    public float getVersionFontSize() {
        return this.versionFontSize;
    }

    public void setVersionFontSize(float f) {
        this.versionFontSize = f;
    }

    public Color getVersionForegroundColor() {
        return this.versionForegroundColor;
    }

    public void setVersionForegroundColor(Color color) {
        this.versionForegroundColor = color;
    }

    public int getVersionHeight() {
        return this.versionHeight;
    }

    public void setVersionHeight(int n) {
        this.versionHeight = n;
    }

    public int getVersionWidth() {
        return this.versionWidth;
    }

    public void setVersionWidth(int n) {
        this.versionWidth = n;
    }

    public String getFontLocation() {
        return this.fontLocation;
    }

    public void setFontLocation(String string) {
        this.fontLocation = string;
    }
}

