/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.registration.WebXmlParser;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import com.sun.web.util.WebXmlParsedTag;
import com.sun.web.util.WebXmlParserHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlChecker {
    private static final String CHECK_ALL_COMPONENTS = "a";
    private static final String CHECK_JATO_COMPONENTS = "j";
    private static final String CHECK_FACES_COMPONENTS = "f";
    private static final String IGNORE_PATH_HTTP = "ignore-path-http";
    private static final String IGNORE_PATH_HTTPS = "ignore-path-https";
    WebXmlParserHandler handler = null;
    File xmlFile = null;
    File chkFile = null;
    String connpath = null;
    WebUtilLogger logger = null;
    CheckEntry[] checkEntries = null;

    public WebXmlChecker(String string, String string2, WebUtilLogger webUtilLogger) throws WebUtilException {
        this.connpath = string2;
        this.logger = webUtilLogger;
        if (string == null || string.trim().length() == 0) {
            throw new WebUtilException("check_err_05");
        }
        this.chkFile = new File(string);
        if (!this.chkFile.exists()) {
            throw new WebUtilException("check_err_06", string);
        }
        try {
            this.checkEntries = this.getCheckEntries(this.chkFile);
        }
        catch (Exception exception) {
            throw new WebUtilException("check_err_07", exception.getLocalizedMessage());
        }
    }

    public int parse(boolean bl, String string) throws WebUtilException {
        if (string == null || string.trim().length() == 0) {
            throw new WebUtilException("check_err_03");
        }
        this.xmlFile = new File(string);
        if (!this.xmlFile.exists()) {
            throw new WebUtilException("check_err_04", string);
        }
        int n = 0;
        if (bl && !this.canParserValidate(this.xmlFile)) {
            this.printError("check_err_28");
            bl = false;
        }
        String string2 = this.connpath.replace('\\', '/') + "/private/system/web-app_2_3.dtd";
        this.handler = new WebXmlParserHandler(string2);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(this.handler);
            sAXParser.parse(this.xmlFile, (DefaultHandler)this.handler);
        }
        catch (SAXParseException sAXParseException) {
            this.printError("check_err_08", new Integer(sAXParseException.getLineNumber()).toString(), sAXParseException.getSystemId());
            this.printError("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            this.printError("check_err_09", exception.getLocalizedMessage());
            n = 2;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            this.printError("check_err_10", exception.getLocalizedMessage());
            n = 2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.printError("check_err_11", parserConfigurationException.getLocalizedMessage());
            n = 2;
        }
        catch (IOException iOException) {
            this.printError("check_err_12", iOException.getLocalizedMessage());
            n = 2;
        }
        return n;
    }

    public int check(boolean bl, boolean bl2) {
        int n = 0;
        for (int i = 0; i < this.checkEntries.length; ++i) {
            CheckEntry checkEntry = this.checkEntries[i];
            String string = checkEntry.getComponentSet();
            boolean bl3 = string.equals(CHECK_ALL_COMPONENTS);
            if (!bl3) {
                if (string.equals(CHECK_FACES_COMPONENTS) && bl2) {
                    bl3 = true;
                } else if (string.equals(CHECK_JATO_COMPONENTS) && bl) {
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            String string2 = checkEntry.getType();
            int n2 = 0;
            n2 = string2.equals("filter") ? this.checkFilterTag(checkEntry) : (string2.equals("servlet") ? this.checkGenericTag(checkEntry) : (string2.equals("taglib") ? this.checkTaglibTag(checkEntry) : (string2.equals("listener") ? this.checkListenerTag(checkEntry) : (string2.equals("context-param") ? this.checkContextParamTag(checkEntry) : this.checkGenericTag(checkEntry)))));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean canParserValidate(File file) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = WebXmlParser.trimWebXml((InputStream)fileInputStream);
            if (string != null) {
                bl = string.indexOf("<!DOCTYPE") >= 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private CheckEntry[] getCheckEntries(File file) throws WebUtilException {
        CheckEntry[] checkEntryArray = null;
        ArrayList<CheckEntry> arrayList = new ArrayList<CheckEntry>(10);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        Object var6_6 = null;
        int n = 0;
        try {
            String string;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                int n2;
                ++n;
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#' || (n2 = (stringTokenizer = new StringTokenizer(string, "|")).countTokens()) == 0) continue;
                if (n2 < 6) {
                    throw new WebUtilException("check_err_14", new Integer(n++).toString());
                }
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                String string7 = stringTokenizer.nextToken().trim();
                CheckEntry checkEntry = new CheckEntry(string2, string3, string4, string5, string6, string7);
                arrayList.add(checkEntry);
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("check_err_15", new Integer(n++).toString(), exception.getLocalizedMessage());
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkEntryArray = new CheckEntry[arrayList.size()];
        checkEntryArray = arrayList.toArray(checkEntryArray);
        return checkEntryArray;
    }

    private int checkFilterTag(CheckEntry checkEntry) {
        int n = 0;
        String string = "filter";
        String string2 = checkEntry.getName();
        WebXmlParsedTag webXmlParsedTag = this.handler.getParsedTag(string, string2);
        if (webXmlParsedTag == null) {
            if (checkEntry.isRequired()) {
                this.printError("check_err_16", string, string2);
                n = 2;
            } else if (checkEntry.isWarn()) {
                this.printError("check_err_17", string, string2);
                n = 1;
            }
        } else {
            int n2;
            int n3;
            String string3 = webXmlParsedTag.getClassname();
            if (string3 == null || string3.length() == 0 || !string3.equals(checkEntry.getClassname())) {
                this.printError("check_err_18", string, string2, string3);
                n = 2;
            }
            if ((n3 = webXmlParsedTag.getOrder()) != 1) {
                this.printError("check_err_13", string, string2, new Integer(n3).toString());
                n = 2;
            }
            if ((string3 = webXmlParsedTag.getValue()).length() == 0) {
                this.printError("check_err_19", string, string2);
                n = 2;
            }
            if ((string3 = webXmlParsedTag.getParameter(IGNORE_PATH_HTTP)) != null && (n2 = this.checkIgnorePaths(IGNORE_PATH_HTTP, string3)) > n) {
                n = n2;
            }
            if ((string3 = webXmlParsedTag.getParameter(IGNORE_PATH_HTTPS)) != null && (n2 = this.checkIgnorePaths(IGNORE_PATH_HTTPS, string3)) > n) {
                n = n2;
            }
        }
        return n;
    }

    private int checkTaglibTag(CheckEntry checkEntry) {
        int n = 0;
        String string = "taglib";
        String string2 = checkEntry.getName();
        WebXmlParsedTag webXmlParsedTag = this.handler.getParsedTag(string, string2);
        if (webXmlParsedTag == null) {
            if (checkEntry.isRequired()) {
                this.printError("check_err_16", string, string2);
                n = 2;
            } else if (checkEntry.isWarn()) {
                this.printError("check_err_17", string, string2);
                n = 1;
            }
        } else {
            String string3 = webXmlParsedTag.getValue();
            if (string3 == null || !string3.equals(checkEntry.getUrlPattern())) {
                this.printError("check_err_20", string, string2, string3);
                n = 2;
            }
        }
        return n;
    }

    private int checkListenerTag(CheckEntry checkEntry) {
        int n = 0;
        String string = "listener";
        String string2 = checkEntry.getName();
        if (string2.equals("*")) {
            WebXmlParsedTag[] webXmlParsedTagArray = this.handler.getParsedTags(string);
            if (webXmlParsedTagArray == null || webXmlParsedTagArray.length == 0) {
                if (checkEntry.isRequired()) {
                    this.printError("check_err_23", string);
                    n = 2;
                } else if (checkEntry.isWarn()) {
                    this.printError("check_err_24", string);
                    n = 1;
                }
            }
            return n;
        }
        WebXmlParsedTag webXmlParsedTag = this.handler.getParsedTag(string, string2);
        if (webXmlParsedTag == null) {
            if (checkEntry.isRequired()) {
                this.printError("check_err_16", string, string2);
                n = 2;
            } else if (checkEntry.isWarn()) {
                this.printError("check_err_17", string, string2);
                n = 1;
            }
        } else {
            String string3 = webXmlParsedTag.getClassname();
            if (string3 == null || string3.length() == 0 || !string3.equals(checkEntry.getClassname())) {
                this.printError("check_err_18", string, string2, string3);
                n = 2;
            }
        }
        return n;
    }

    private int checkContextParamTag(CheckEntry checkEntry) {
        int n = 0;
        String string = checkEntry.getType();
        String string2 = checkEntry.getName();
        String string3 = checkEntry.getClassname();
        WebXmlParsedTag webXmlParsedTag = this.handler.getParsedTag(string, string2);
        if (webXmlParsedTag == null) {
            if (checkEntry.isRequired()) {
                this.printError("check_err_16", string, string2);
                n = 2;
            } else if (checkEntry.isWarn()) {
                this.printError("check_err_17", string, string2);
                n = 1;
            }
        } else if (string3.length() > 0) {
            String string4 = webXmlParsedTag.getValue();
            if (string4 == null || string4.length() == 0) {
                this.printError("check_err_30", string, string2);
                n = 2;
            } else if (!string3.equals("*")) {
                String[] stringArray = string3.split(",");
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string4.equalsIgnoreCase(stringArray[i])) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.printError("check_err_29", string, string2, string4);
                    n = 2;
                }
            }
        }
        return n;
    }

    private int checkGenericTag(CheckEntry checkEntry) {
        String string;
        int n = 0;
        String string2 = checkEntry.getType();
        WebXmlParsedTag webXmlParsedTag = this.handler.getParsedTag(string2, string = checkEntry.getName());
        if (webXmlParsedTag == null) {
            if (checkEntry.isRequired()) {
                this.printError("check_err_16", string2, string);
                n = 2;
            } else if (checkEntry.isWarn()) {
                this.printError("check_err_17", string2, string);
                n = 1;
            }
        } else {
            String string3;
            String string4;
            String string5 = checkEntry.getClassname();
            if (!(string5.length() <= 0 || (string4 = webXmlParsedTag.getClassname()) != null && string5.equals(string4))) {
                this.printError("check_err_18", string2, string, string5);
                n = 2;
            }
            if ((string3 = checkEntry.getUrlPattern()).length() > 0) {
                string4 = webXmlParsedTag.getValue();
                if (string4 == null || string4.length() == 0) {
                    this.printError("check_err_19", string2, string);
                    n = 2;
                } else if (!string3.equals("*") && !string3.equals(string4)) {
                    this.printError("check_err_21", string2, string, string4);
                    n = 2;
                }
            }
        }
        return n;
    }

    private int checkIgnorePaths(String string, String string2) {
        int n = 0;
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.startsWith("/")) continue;
                this.printError("check_err_22", string, string3);
                n = 1;
            }
        }
        return n;
    }

    private void printError(String string) {
        this.printError(string, null, null, null);
    }

    private void printError(String string, String string2) {
        this.printError(string, string2, null, null);
    }

    private void printError(String string, String string2, String string3) {
        this.printError(string, string2, string3, null);
    }

    private void printError(String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        String string5 = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string5, 0);
        } else {
            System.out.println(string5);
        }
    }

    private static class CheckEntry {
        private String compset;
        private String type;
        private String name;
        private String flag;
        private String classname;
        private String urlpattern;

        CheckEntry(String string, String string2, String string3, String string4, String string5, String string6) {
            this.compset = string;
            this.flag = string2.toLowerCase();
            this.type = string3;
            this.name = string4;
            this.classname = string5;
            this.urlpattern = string6;
        }

        String getComponentSet() {
            return this.compset;
        }

        String getType() {
            return this.type;
        }

        String getName() {
            return this.name;
        }

        String getClassname() {
            return this.classname;
        }

        String getUrlPattern() {
            return this.urlpattern;
        }

        boolean isRequired() {
            boolean bl = false;
            if (this.flag.startsWith("r")) {
                bl = true;
            }
            return bl;
        }

        boolean isWarn() {
            boolean bl = false;
            if (this.flag.startsWith("w")) {
                bl = true;
            }
            return bl;
        }

        boolean isOptional() {
            boolean bl = false;
            if (this.flag.length() == 0 || this.flag.startsWith("o")) {
                bl = true;
            }
            return bl;
        }
    }
}

