/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.TemplateCallback;
import com.sun.web.util.TemplateRewriter;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebappCreate
implements TemplateCallback {
    private static final String FS = File.separator;
    private static final String WEB_INF_SUBDIR = "WEB-INF";
    private static final String HTML_EN_SUBDIR = "html" + FS + "en";
    private static final String LIB_SUBDIR = "lib";
    private static final String IMAGES_SUBDIR = "images";
    private static final String JSP_SUBDIR = "jsp";
    private static final String JS_SUBDIR = "js";
    private static final String CLASSES_SUBDIR = "classes";
    private static final String RESOURCES_SUBDIR = "resources";
    private static final String REPLACE_NAME = "REPLACE_NAME";
    private static final String REPLACE_NAMEKEY = "REPLACE_NAMEKEY";
    private static final String REPLACE_PACKAGE = "REPLACE_PACKAGE";
    private static final String REPLACE_CONTEXT = "REPLACE_CONTEXT";
    private static final String REPLACE_VERSION = "REPLACE_VERSION";
    private static final String REPLACE_CATEGORY = "REPLACE_CATEGORY";
    private static final String PROP_CONSOLE_CONF = "console.conf";
    private static final String PROP_JATO_FLAG = "jato.flag";
    private static final String PROP_FACES_FLAG = "faces.flag";
    private static final String APP_XML_TEMPLATE = "app_xml.tpl";
    private static final String JATO_APP_XML_TEMPLATE = "jato_app_xml.tpl";
    private static final String ALL_WEB_XML_TEMPLATE = "all_web_xml.tpl";
    private static final String JATO_WEB_XML_TEMPLATE = "jato_web_xml.tpl";
    private static final String FACES_WEB_XML_TEMPLATE = "faces_web_xml.tpl";
    private static final String BUILD_XML_TEMPLATE = "build_xml.tpl";
    private static final String INDEX_JSP_TEMPLATE = "faces_index_jsp.tpl";
    private static final String RESOURCES_FILENAME = "Resources.properties";
    private static final String BUILD_FILENAME = "build.properties";
    private static final String INDEX_JSP_FILENAME = "index.jsp";
    private static final String DFLT_VERSION = "1.0";
    private static final String DFLT_CATEGORY = "Other";
    private static final String DFLT_UNIX_CONF = "/etc/opt/webconsole/console";
    private static final String DFLT_SOLARIS_CONF = "/etc/webconsole/console";
    private static final String DFLT_WINDOWS_CONF = "c:/sun/webconsole/console/etc";
    private String consoledir = null;
    private WebUtilLogger logger = null;
    private HashMap replace_map;

    public WebappCreate(String string, WebUtilLogger webUtilLogger) throws WebUtilException {
        this.consoledir = string;
        this.logger = webUtilLogger;
        this.replace_map = new HashMap(10);
    }

    public void create(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws WebUtilException {
        Object object;
        Object object2;
        File file = new File(string4);
        if (!file.exists() || !file.isDirectory()) {
            throw new WebUtilException("create_err_05", string4);
        }
        if (!file.canWrite()) {
            throw new WebUtilException("create_err_07", string4);
        }
        String string5 = string.replace(' ', '_');
        this.replace_map.put(REPLACE_NAME, string);
        this.replace_map.put(REPLACE_NAMEKEY, string5);
        this.replace_map.put(REPLACE_PACKAGE, string2);
        this.replace_map.put(REPLACE_CONTEXT, string3);
        this.replace_map.put(REPLACE_VERSION, DFLT_VERSION);
        this.replace_map.put(REPLACE_CATEGORY, DFLT_CATEGORY);
        String string6 = string4 + FS + string3;
        this.createDirectory(string6);
        String string7 = string6 + FS + WEB_INF_SUBDIR;
        this.createDirectory(string7);
        String string8 = string7 + FS + CLASSES_SUBDIR;
        this.createDirectory(string8);
        this.createDirectory(string6 + FS + HTML_EN_SUBDIR);
        this.createDirectory(string6 + FS + JSP_SUBDIR);
        this.createDirectory(string6 + FS + JS_SUBDIR);
        this.createDirectory(string7 + FS + LIB_SUBDIR);
        String string9 = string8 + FS + string2.replace('.', File.separatorChar);
        this.createDirectory(string9);
        this.createDirectory(string9 + FS + RESOURCES_SUBDIR);
        TemplateRewriter templateRewriter = new TemplateRewriter();
        String string10 = this.consoledir + WebUtilConstants.TEMPLATE_SUBDIR;
        String string11 = string10 + FS + BUILD_XML_TEMPLATE;
        String string12 = string6 + FS + "build.xml";
        try {
            object2 = new File(string12);
            if (!((File)object2).exists()) {
                templateRewriter.copyTemplate(string11, string12, this);
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("create_err_09", "build.xml", exception.getLocalizedMessage());
        }
        object2 = APP_XML_TEMPLATE;
        if (bl) {
            object2 = JATO_APP_XML_TEMPLATE;
        }
        string11 = string10 + FS + (String)object2;
        string12 = string7 + FS + "app.xml";
        try {
            object = new File(string12);
            if (!((File)object).exists()) {
                templateRewriter.copyTemplate(string11, string12, this);
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("create_err_09", "app.xml", exception.getLocalizedMessage());
        }
        object2 = bl && bl2 ? ALL_WEB_XML_TEMPLATE : (bl ? JATO_WEB_XML_TEMPLATE : FACES_WEB_XML_TEMPLATE);
        string11 = string10 + FS + (String)object2;
        string12 = string7 + FS + "web.xml";
        try {
            object = new File(string12);
            if (!((File)object).exists()) {
                templateRewriter.copyTemplate(string11, string12, this);
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("create_err_09", "web.xml", exception.getLocalizedMessage());
        }
        string12 = string9 + FS + RESOURCES_SUBDIR + FS + RESOURCES_FILENAME;
        object = "Resource properties for the " + string + " application";
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put(string5, string);
        this.createPropertiesFile(string12, (String)object, hashMap);
        if (bl2) {
            string11 = string10 + FS + INDEX_JSP_TEMPLATE;
            string12 = string6 + FS + JSP_SUBDIR + FS + INDEX_JSP_FILENAME;
            try {
                File file2 = new File(string12);
                if (!file2.exists()) {
                    templateRewriter.copyTemplate(string11, string12, this);
                }
            }
            catch (Exception exception) {
                throw new WebUtilException("create_err_09", INDEX_JSP_FILENAME, exception.getLocalizedMessage());
            }
        }
        string12 = string6 + FS + BUILD_FILENAME;
        object = "Resource properties for building the " + string + " application";
        hashMap = new HashMap(10);
        hashMap.put(PROP_CONSOLE_CONF, this.getDefaultConsoleConf());
        hashMap.put(PROP_JATO_FLAG, bl ? "true" : "false");
        hashMap.put(PROP_FACES_FLAG, bl2 ? "true" : "false");
        this.createPropertiesFile(string12, (String)object, hashMap);
    }

    public String substitute(String string) {
        String string2 = null;
        if (string != null) {
            string2 = (String)this.replace_map.get(string);
        }
        return string2;
    }

    private String getDefaultConsoleConf() {
        String string = System.getProperty("os.name");
        String string2 = DFLT_UNIX_CONF;
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf("sunos") >= 0) {
                string2 = DFLT_SOLARIS_CONF;
            } else if (string.indexOf("windows") >= 0) {
                string2 = DFLT_WINDOWS_CONF;
            }
        }
        return string2;
    }

    private void createDirectory(String string) throws WebUtilException {
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                throw new WebUtilException("create_err_08", string, exception.getLocalizedMessage());
            }
        }
    }

    private void createPropertiesFile(String string, String string2, Map map) throws WebUtilException {
        File file = new File(string);
        if (!file.exists()) {
            FileOutputStream fileOutputStream = null;
            PrintWriter printWriter = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("#");
                printWriter.println("# " + string2);
                printWriter.println("#");
                printWriter.println("");
                if (map != null && !map.isEmpty()) {
                    Set set = map.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        String string4 = (String)map.get(string3);
                        if (string4 == null) {
                            string4 = "";
                        }
                        printWriter.println(string3 + "=" + string4);
                    }
                }
            }
            catch (Exception exception) {
                throw new WebUtilException("create_err_10", string, exception.getLocalizedMessage());
            }
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

