/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class WebappImport {
    private static final String ACTION_MKDIR_STR = "mkdir";
    private static final String ACTION_COPY_STR = "copy";
    private static final String ACTION_RCOPY_STR = "rcopy";
    private static final String ACTION_REMOVE_STR = "rm";
    private static final int ACTION_MKDIR = 1;
    private static final int ACTION_COPY = 2;
    private static final int ACTION_REMOVE = 3;
    private static final int ACTION_RECURSIVE_COPY = 4;
    private static final String FS = File.separator;
    private String conspath = null;
    private WebUtilLogger logger = null;

    public WebappImport(String string, WebUtilLogger webUtilLogger) throws WebUtilException {
        this.conspath = string;
        this.logger = webUtilLogger;
    }

    public void copyResources(String string, String string2, String string3) throws WebUtilException {
        List list = this.readImportList(string3);
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ImportListItem importListItem = (ImportListItem)iterator.next();
            switch (importListItem.getAction()) {
                case 1: {
                    this.createDirectory(string2, importListItem.getSource());
                    break;
                }
                case 2: {
                    this.copyFile(string, string2, importListItem.getSource(), importListItem.getTarget());
                    break;
                }
                case 3: {
                    this.removeFile(string2, importListItem.getSource());
                    break;
                }
                case 4: {
                    this.copyFiles(string, string2, importListItem.getSource(), importListItem.getTarget());
                    break;
                }
            }
        }
    }

    private void createDirectory(String string, String string2) throws WebUtilException {
        File file;
        String string3 = string;
        if (string2 != null) {
            string3 = string + File.separator + string2.replace('/', File.separatorChar);
        }
        if (!(file = new File(string3)).exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                throw new WebUtilException("import_err_06", string3);
            }
        }
    }

    private void copyFiles(String string, String string2, String string3, String string4) throws WebUtilException {
        String string5 = string + File.separator + string3.replace('/', File.separatorChar);
        String string6 = string2 + File.separator + string4.replace('/', File.separatorChar);
        File file = new File(string5);
        if (file.exists() && file.isDirectory()) {
            this.createDirectory(string6, null);
            String[] stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.copyFiles(string5, string6, stringArray[i], stringArray[i]);
                }
            }
        } else if (file.exists() && file.isFile()) {
            this.doCopyFile(string5, string6);
        }
    }

    private void copyFile(String string, String string2, String string3, String string4) throws WebUtilException {
        String string5 = string + File.separator + string3.replace('/', File.separatorChar);
        String string6 = string2 + File.separator + string4.replace('/', File.separatorChar);
        this.doCopyFile(string5, string6);
    }

    private void doCopyFile(String string, String string2) throws WebUtilException {
        File file = new File(string);
        File file2 = new File(string2);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        WebUtilException webUtilException = null;
        if (file.exists() && !file2.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    if (n <= 0) continue;
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                webUtilException = new WebUtilException("import_err_07", string, string2);
            }
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (webUtilException != null) {
            throw webUtilException;
        }
    }

    private void removeFile(String string, String string2) throws WebUtilException {
        String string3 = string + File.separator + string2.replace('/', File.separatorChar);
        File file = new File(string3);
        if (file.exists() && file.isFile()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                throw new WebUtilException("import_err_08", string3);
            }
        }
    }

    private List readImportList(String string) throws WebUtilException {
        ArrayList<ImportListItem> arrayList = new ArrayList<ImportListItem>(10);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        WebUtilException webUtilException = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                ImportListItem importListItem;
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || (importListItem = this.parseImportLine(string2)) == null) continue;
                arrayList.add(importListItem);
            }
        }
        catch (Exception exception) {
            webUtilException = new WebUtilException("import_err_10", string);
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (webUtilException != null) {
            throw webUtilException;
        }
        return arrayList;
    }

    private ImportListItem parseImportLine(String string) throws WebUtilException {
        ImportListItem importListItem = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase(ACTION_MKDIR_STR)) {
                n = 1;
            } else if (string4.equalsIgnoreCase(ACTION_COPY_STR)) {
                n = 2;
            } else if (string4.equalsIgnoreCase(ACTION_REMOVE_STR)) {
                n = 3;
            } else if (string4.equalsIgnoreCase(ACTION_RCOPY_STR)) {
                n = 4;
            }
        }
        if (n2 > 1) {
            string2 = stringTokenizer.nextToken();
        }
        if (n2 > 2) {
            string3 = stringTokenizer.nextToken();
        }
        if (n == 0 || string2 == null) {
            throw new WebUtilException("import_err_09", string);
        }
        importListItem = new ImportListItem(n, string2, string3);
        return importListItem;
    }

    private static int getVersionNumber(String string) {
        int n = 0;
        try {
            String[] stringArray = string.trim().split("[^0123456789.]");
            string = "0" + stringArray[0];
        }
        catch (Exception exception) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n4 = stringTokenizer.countTokens();
            if (n4 > 0) {
                string2 = stringTokenizer.nextToken();
                n2 = new Integer(string2);
            }
            if (n4 > 1) {
                string2 = stringTokenizer.nextToken();
                n3 = new Integer(string2);
            }
            n = n2 * 100 + n3;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private void printError(String string) {
        this.printError(string, null, null, null);
    }

    private void printError(String string, String string2) {
        this.printError(string, string2, null, null);
    }

    private void printError(String string, String string2, String string3) {
        this.printError(string, string2, string3, null);
    }

    private void printError(String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        String string5 = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string5, 1);
        } else {
            System.out.println(string5);
        }
    }

    private class ImportListItem {
        private int act;
        private String src;
        private String tgt;

        public ImportListItem(int n, String string, String string2) {
            this.act = n;
            this.src = string;
            this.tgt = string2;
        }

        public int getAction() {
            return this.act;
        }

        public String getSource() {
            return this.src;
        }

        public String getTarget() {
            return this.tgt;
        }
    }
}

