/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.component.Masthead;
import com.sun.web.ui.component.util.Util;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MastheadRenderer
extends AbstractRenderer {
    private static final String SKIP_SECTION = "skipSection";
    private static final String SKIP_UTILITY = "skipUtility";

    protected void renderAlarmsInfo(FacesContext context, Masthead masthead, ResponseWriter writer, int[] alarms, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_ALARM_DIV"), null);
        UIComponent alarmsFacet = masthead.getFacet("currentAlarmsInfo");
        if (alarmsFacet != null) {
            RenderingUtilities.renderComponent(alarmsFacet, context);
        } else {
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TEXT"), null);
            writer.write(theme.getMessage("masthead.currentAlarms"));
            writer.endElement("span");
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_DOWN_MEDIUM", "Alarm.downImageAltText", masthead, "MASTHEAD_ALARM_DOWN_TEXT", alarms[0], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_CRITICAL_MEDIUM", "Alarm.criticalImageAltText", masthead, "MASTHEAD_ALARM_CRITICAL_TEXT", alarms[1], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_MAJOR_MEDIUM", "Alarm.majorImageAltText", masthead, "MASTHEAD_ALARM_MAJOR_TEXT", alarms[2], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_MINOR_MEDIUM", "Alarm.minorImageAltText", masthead, "MASTHEAD_ALARM_MINOR_TEXT", alarms[3], theme);
        }
        writer.endElement("div");
    }

    protected void renderApplicationInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TD_TITLE"), null);
        writer.writeAttribute("width", (Object)"99%", null);
        if (masthead.getUserInfo() != null || masthead.getServerInfo() != null || masthead.getFacet("userInfo") != null || masthead.getFacet("serverInfo") != null) {
            this.renderUserInfo(context, masthead, writer, theme);
        }
        this.renderProductInfo(context, masthead, writer, theme.getStyleClass("MASTHEAD_DIV_TITLE"));
        writer.endElement("td");
    }

    protected void renderBrandImage(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TD_LOGO"), null);
        writer.writeAttribute("width", (Object)"1%", null);
        Object brandFacet = masthead.getFacet("brandImage");
        if (brandFacet == null) {
            ImageComponent image = new ImageComponent();
            if (masthead.getBrandImageURL() != null) {
                image.setUrl(masthead.getBrandImageURL());
                if (masthead.getBrandImageDescription() != null) {
                    image.setAlt(masthead.getBrandImageDescription());
                }
                if (masthead.getBrandImageHeight() != 0) {
                    image.setHeight(masthead.getBrandImageHeight());
                }
                if (masthead.getBrandImageWidth() != 0) {
                    image.setWidth(masthead.getBrandImageWidth());
                }
            } else {
                try {
                    image = theme.getIcon("CORPLOGO");
                    image.setAlt(theme.getMessage("masthead.brandLogoAltText"));
                }
                catch (RuntimeException e) {
                    image = theme.getIcon("DOT");
                }
            }
            brandFacet = image;
        }
        RenderingUtilities.renderComponent(brandFacet, context);
        writer.endElement("td");
    }

    protected void renderCorporateImage(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_END"));
        writer.startElement("tr", (UIComponent)masthead);
        writer.startElement("td", (UIComponent)masthead);
        Object corporateFacet = masthead.getFacet("corporateImage");
        if (corporateFacet == null) {
            ImageComponent image = new ImageComponent();
            if (masthead.getCorporateImageURL() != null) {
                image.setUrl(masthead.getCorporateImageURL());
                if (masthead.getCorporateImageDescription() != null) {
                    image.setAlt(masthead.getCorporateImageDescription());
                }
                if (masthead.getCorporateImageHeight() != 0) {
                    image.setHeight(masthead.getCorporateImageHeight());
                }
                if (masthead.getCorporateImageWidth() != 0) {
                    image.setWidth(masthead.getCorporateImageWidth());
                }
            } else {
                image = theme.getIcon("MASTHEAD_CORPNAME");
                image.setAlt(theme.getMessage("masthead.endorserLogoAltText"));
            }
            corporateFacet = image;
        }
        RenderingUtilities.renderComponent(corporateFacet, context);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected void renderDateTimeInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TIME_DIV"), null);
        UIComponent timeStampFacet = masthead.getFacet("dateTimeInfo");
        if (timeStampFacet != null) {
            RenderingUtilities.renderComponent(timeStampFacet, context);
        } else {
            String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)textStyle, null);
            writer.write(theme.getMessage("masthead.lastUpdate"));
            writer.endElement("span");
            writer.write("&nbsp;");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)textStyle, null);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1, context.getViewRoot().getLocale());
            writer.write(dateFormat.format(new Date()));
            writer.endElement("span");
            writer.write("&nbsp;");
        }
        writer.endElement("div");
    }

    protected void renderJobsInfo(FacesContext context, Masthead masthead, ResponseWriter writer, boolean divIsOpen, Theme theme) throws IOException {
        UIComponent jobsFacet;
        if (!divIsOpen) {
            writer.startElement("div", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_STATUS_DIV"), null);
        }
        if ((jobsFacet = masthead.getFacet("jobsInfo")) != null) {
            RenderingUtilities.renderComponent(jobsFacet, context);
        } else {
            Icon icon = theme.getIcon("MASTHEAD_STATUS_ICON");
            icon.setAlt(theme.getMessage("masthead.tasksRunningAltText"));
            icon.setAlign("middle");
            icon.setBorder(0);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.write("&nbsp;");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TEXT"), null);
            writer.write(theme.getMessage("masthead.tasksRunning"));
            writer.write(" " + masthead.getJobCount());
            writer.endElement("span");
        }
        writer.endElement("div");
    }

    protected void renderNotificationInfo(FacesContext context, Masthead masthead, ResponseWriter writer, boolean leaveDivOpen, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_STATUS_DIV"), null);
        UIComponent notificationFacet = masthead.getFacet("notificationInfo");
        if (notificationFacet != null) {
            RenderingUtilities.renderComponent(notificationFacet, context);
        } else {
            ImageComponent image = (ImageComponent)Util.getChild((UIComponent)masthead, "notificationImage", "com.sun.web.ui.component.util.factories.ImageComponentFactory");
            image = theme.getIcon("ALERT_INFO_MEDIUM");
            image.setAlign("middle");
            image.setBorder(0);
            image.setAlt(theme.getMessage("Alert.infoImageAltText"));
            RenderingUtilities.renderComponent((UIComponent)image, context);
            writer.write("&nbsp;");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TEXT"), null);
            writer.write(masthead.getNotificationMsg());
            writer.endElement("span");
        }
        if (!leaveDivOpen) {
            writer.endElement("div");
        }
    }

    protected void renderProductInfo(FacesContext context, Masthead masthead, ResponseWriter writer, String styleName) throws IOException {
        Object productFacet = masthead.getFacet("productInfo");
        if (productFacet == null && masthead.getProductImageURL() == null) {
            return;
        }
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)styleName, null);
        if (productFacet == null) {
            ImageComponent image = (ImageComponent)Util.getChild((UIComponent)masthead, "productInfoImage", "com.sun.web.ui.component.util.factories.ImageComponentFactory");
            image.setUrl(masthead.getProductImageURL());
            image.setHeight(masthead.getProductImageHeight());
            image.setWidth(masthead.getProductImageWidth());
            image.setAlt(masthead.getProductImageDescription());
            productFacet = image;
        }
        RenderingUtilities.renderComponent(productFacet, context);
        writer.endElement("div");
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Masthead masthead = (Masthead)component;
        Theme theme = ThemeUtilities.getTheme(context);
        RenderingUtilities.renderSkipLink(SKIP_SECTION, theme.getStyleClass("SKIP_MEDIUM_GREY1"), null, theme.getMessage("masthead.skipTagAltText"), null, (UIComponent)masthead, context);
        RenderingUtilities.renderSkipLink(SKIP_UTILITY, theme.getStyleClass("SKIP_MEDIUM_GREY1"), null, theme.getMessage("masthead.statusSkipTagAltText"), null, (UIComponent)masthead, context);
        writer.startElement("div", (UIComponent)masthead);
        String styleClass = theme.getStyleClass("MASTHEAD_DIV");
        RenderingUtilities.renderStyleClass(context, writer, component, styleClass);
        String style = masthead.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (masthead.isSecondary()) {
            this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_SECONDARY_TABLE"));
            writer.startElement("tbody", (UIComponent)masthead);
            writer.startElement("tr", (UIComponent)masthead);
            writer.startElement("td", (UIComponent)masthead);
            this.renderProductInfo(context, masthead, writer, theme.getStyleClass("MASTHEAD_DIV_SECONDARY_TITLE"));
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_TOP"));
            this.renderUtilityBar(context, masthead, writer, theme);
            writer.endElement("table");
            this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_BOTTOM"));
            writer.startElement("tr", (UIComponent)masthead);
            RenderingUtilities.renderAnchor(SKIP_UTILITY, (UIComponent)masthead, context);
            this.renderApplicationInfo(context, masthead, writer, theme);
            if (masthead.getFacet("statusArea") != null || masthead.isDateTime() || masthead.getNotificationMsg() != null || masthead.getAlarmCounts() != null || masthead.getJobCount() != -1 || masthead.getFacet("notificationInfo") != null || masthead.getFacet("jobsInfo") != null || masthead.getFacet("dateTimeInfo") != null || masthead.getFacet("currentAlarmsInfo") != null) {
                this.renderStatusAreaSeparator(context, masthead, writer, theme);
                this.renderStatusArea(context, masthead, writer, theme);
                this.renderStatusAreaSeparator(context, masthead, writer, theme);
            }
            this.renderBrandImage(context, masthead, writer, theme);
            writer.endElement("tr");
            writer.endElement("table");
            if (this.isCorporateImage(masthead, theme)) {
                this.renderCorporateImage(context, masthead, writer, theme);
            }
        }
        writer.endElement("div");
        RenderingUtilities.renderAnchor(SKIP_SECTION, (UIComponent)masthead, context);
    }

    protected boolean isCorporateImage(Masthead masthead, Theme theme) {
        if (masthead.getFacet("corporateImage") != null || masthead.getCorporateImageURL() != null) {
            return true;
        }
        boolean showIt = true;
        try {
            theme.getIcon("MASTHEAD_CORPNAME");
        }
        catch (RuntimeException e) {
            showIt = false;
        }
        return showIt;
    }

    protected void renderStatusArea(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        String labelStyle = theme.getStyleClass("MASTHEAD_LABEL");
        String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TD_ALARM"), null);
        UIComponent statusFacet = masthead.getFacet("statusArea");
        if (statusFacet != null) {
            RenderingUtilities.renderComponent(statusFacet, context);
        } else {
            int[] alarms;
            boolean showBoth;
            boolean showNotification = masthead.getNotificationMsg() != null || masthead.getFacet("notificationInfo") != null;
            boolean showJobs = masthead.getJobCount() != -1 || masthead.getFacet("jobsInfo") != null;
            boolean bl = showBoth = showNotification && showJobs;
            if (showNotification) {
                this.renderNotificationInfo(context, masthead, writer, showBoth, theme);
            }
            if (showBoth) {
                writer.startElement("img", (UIComponent)masthead);
                writer.writeAttribute("src", (Object)theme.getIcon("DOT").getUrl(), null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.writeAttribute("border", (Object)"0", null);
                writer.writeAttribute("height", (Object)"1", null);
                writer.writeAttribute("width", (Object)"20", null);
                writer.endElement("img");
            }
            if (showJobs) {
                this.renderJobsInfo(context, masthead, writer, showBoth, theme);
            }
            if (masthead.isDateTime() || masthead.getFacet("dateTimeInfo") != null) {
                this.renderDateTimeInfo(context, masthead, writer, theme);
            }
            if ((alarms = masthead.getAlarmCounts()) != null && alarms.length == 4 || masthead.getFacet("currentAlarmsInfo") != null) {
                this.renderAlarmsInfo(context, masthead, writer, alarms, theme);
            }
        }
        writer.endElement("td");
    }

    protected void renderStatusAreaSeparator(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("align", (Object)"right", null);
        Object separatorFacet = masthead.getFacet("separatorImage");
        if (separatorFacet == null) {
            separatorFacet = theme.getIcon("MASTHEAD_STATUS_AREA_SEPARATOR");
        }
        RenderingUtilities.renderComponent(separatorFacet, context);
        writer.endElement("td");
    }

    protected void renderUserInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        String label = null;
        String labelStyle = theme.getStyleClass("MASTHEAD_LABEL");
        String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_DIV_USER"), null);
        UIComponent facet = masthead.getFacet("userInfoLabel");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            label = masthead.getUserInfoLabel();
            if (label == null) {
                label = theme.getMessage("masthead.userLabel");
            }
            this.writeSpan(writer, masthead, labelStyle, label);
        }
        writer.write("&nbsp;");
        facet = masthead.getFacet("userInfo");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.writeSpan(writer, masthead, textStyle, masthead.getUserInfo());
        }
        writer.write("&nbsp;&nbsp;&nbsp;");
        facet = masthead.getFacet("serverInfoLabel");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            label = masthead.getServerInfoLabel();
            if (label == null) {
                label = theme.getMessage("masthead.serverLabel");
            }
            this.writeSpan(writer, masthead, labelStyle, label);
        }
        writer.write("&nbsp;");
        facet = masthead.getFacet("serverInfo");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.writeSpan(writer, masthead, textStyle, masthead.getServerInfo());
        }
        writer.endElement("div");
    }

    protected void renderUtilityBar(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        String style;
        boolean areExtraLinks;
        boolean versionLinkDisplayed;
        UIComponent facet = masthead.getFacet("utilityBar");
        String styleName = null;
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
            return;
        }
        UIForm form = (UIForm)Util.getForm(context, (UIComponent)masthead);
        writer.startElement("tr", (UIComponent)masthead);
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeAttribute("valign", (Object)"middle", null);
        facet = masthead.getFacet("consoleLink");
        boolean consoleLinkDisplayed = facet != null;
        boolean bl = versionLinkDisplayed = masthead.getFacet("versionLink") != null;
        if (consoleLinkDisplayed) {
            styleName = versionLinkDisplayed ? "MASTHEAD_LINK_LEFT" : "MASTHEAD_LINK";
            this.setAttrs(facet, "MastheadConsoleLink", (UIComponent)form, theme.getMessage("masthead.consoleLabel"), theme.getStyleClass(styleName), theme.getMessage("masthead.consoleTooltip"), theme.getMessage("masthead.consoleStatus"));
            RenderingUtilities.renderComponent(facet, context);
        }
        if ((facet = masthead.getFacet("versionLink")) != null) {
            styleName = consoleLinkDisplayed ? "MASTHEAD_LINK_RIGHT" : "MASTHEAD_LINK";
            String styleClass = theme.getStyleClass(styleName);
            this.setAttrs(facet, "MastheadVersionLink", (UIComponent)form, theme.getMessage("masthead.versionLabel"), styleClass, theme.getMessage("masthead.versionTooltip"), theme.getMessage("masthead.versionStatus"));
            RenderingUtilities.renderComponent(facet, context);
        }
        writer.endElement("td");
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("align", (Object)"right", null);
        writer.writeAttribute("valign", (Object)"middle", null);
        String leftLinkStyle = theme.getStyleClass("MASTHEAD_LINK_LEFT");
        String centerLinkStyle = theme.getStyleClass("MASTHEAD_LINK_CENTER");
        String rightLinkStyle = theme.getStyleClass("MASTHEAD_LINK_RIGHT");
        String singleLinkStyle = theme.getStyleClass("MASTHEAD_LINK");
        UIComponent logoutFacet = masthead.getFacet("logoutLink");
        UIComponent helpFacet = masthead.getFacet("helpLink");
        UIComponent searchFacet = masthead.getFacet("search");
        Hyperlink[] extraLinks = masthead.getUtilities();
        boolean logoutLinkDisplayed = logoutFacet != null;
        boolean helpLinkDisplayed = helpFacet != null;
        boolean bl2 = areExtraLinks = extraLinks != null;
        if (searchFacet != null) {
            RenderingUtilities.renderComponent(searchFacet, context);
            if (logoutLinkDisplayed || helpLinkDisplayed || areExtraLinks) {
                ImageComponent separator = new ImageComponent();
                separator.setId("searchSeparator");
                separator.setIcon("MASTHEAD_SEPARATOR");
                RenderingUtilities.renderComponent((UIComponent)separator, context);
            }
        }
        if (areExtraLinks) {
            boolean extraLinksOnly = !logoutLinkDisplayed && !helpLinkDisplayed;
            for (int i = 0; i < extraLinks.length; ++i) {
                Hyperlink link = extraLinks[i];
                if (link.getParent() == null) {
                    form.getChildren().add(link);
                }
                if (i == 0) {
                    if (extraLinks.length == 1 && extraLinksOnly) {
                        link.setStyleClass(singleLinkStyle);
                    } else {
                        link.setStyleClass(leftLinkStyle);
                    }
                } else if (i < extraLinks.length - 1) {
                    link.setStyleClass(centerLinkStyle);
                } else if (extraLinksOnly) {
                    link.setStyleClass(rightLinkStyle);
                } else {
                    link.setStyleClass(centerLinkStyle);
                }
                RenderingUtilities.renderComponent((UIComponent)link, context);
            }
        }
        if (logoutLinkDisplayed) {
            style = "MASTHEAD_LINK";
            if (areExtraLinks && helpLinkDisplayed) {
                style = "MASTHEAD_LINK_CENTER";
            } else if (areExtraLinks && !helpLinkDisplayed) {
                style = "MASTHEAD_LINK_RIGHT";
            } else if (!areExtraLinks && helpLinkDisplayed) {
                style = "MASTHEAD_LINK_LEFT";
            }
            this.setAttrs(logoutFacet, "MastheadLogoutLink", (UIComponent)form, theme.getMessage("masthead.logoutLabel"), theme.getStyleClass(style), theme.getMessage("masthead.logoutTooltip"), theme.getMessage("masthead.logoutStatus"));
            RenderingUtilities.renderComponent(logoutFacet, context);
        }
        if (helpFacet != null) {
            style = "MASTHEAD_LINK";
            if (areExtraLinks || logoutLinkDisplayed) {
                style = "MASTHEAD_LINK_RIGHT";
            }
            this.setAttrs(helpFacet, "MastheadHelpLink", (UIComponent)form, theme.getMessage("masthead.helpLabel"), theme.getStyleClass(style), theme.getMessage("masthead.helpLabel"), theme.getMessage("masthead.helpLabel"));
            RenderingUtilities.renderComponent(helpFacet, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    private void setAttrs(UIComponent component, String id, UIComponent parent, String label, String styleClass, String toolTip, String focusText) {
        Map attrs = component.getAttributes();
        StringBuffer focusBuff = new StringBuffer(64);
        focusBuff.append("window.status='").append(focusText).append("'; return true; ");
        focusText = focusBuff.toString();
        if (component.getId() == null) {
            component.setId(id);
        }
        if (component.getParent() == null) {
            parent.getChildren().add(component);
        }
        if (attrs.get("text") == null) {
            attrs.put("text", label);
        }
        if (attrs.get("styleClass") == null) {
            attrs.put("styleClass", styleClass);
        }
        if (attrs.get("toolTip") == null) {
            attrs.put("toolTip", toolTip);
        }
        if (attrs.get("onFocus") == null) {
            attrs.put("onFocus", focusText);
        }
        if (attrs.get("onMouseOver") == null) {
            attrs.put("onMouseOver", focusText);
        }
        if (attrs.get("onMouseOut") == null) {
            attrs.put("onMouseOut", "window.status=''; return true;");
        }
        if (attrs.get("onBlur") == null) {
            attrs.put("onBlur", "window.status=''; return true;");
        }
    }

    private void startTable(ResponseWriter writer, Masthead masthead, String styleName) throws IOException {
        writer.startElement("table", (UIComponent)masthead);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("class", (Object)styleName, null);
        writer.writeAttribute("title", (Object)"", null);
    }

    private void writeAlarmCount(ResponseWriter writer, FacesContext context, String imageName, String imageAlt, Masthead masthead, String style, int count, Theme theme) throws IOException {
        Icon icon = theme.getIcon(imageName);
        icon.setAlt(theme.getMessage(imageAlt));
        RenderingUtilities.renderComponent((UIComponent)icon, context);
        style = theme.getStyleClass(style);
        writer.startElement("span", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)style, null);
        writer.write("&nbsp;" + count + "&nbsp;&nbsp;&nbsp;");
        writer.endElement("span");
    }

    private void writeSpan(ResponseWriter writer, Masthead masthead, String styleName, String text) throws IOException {
        writer.startElement("span", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)styleName, null);
        writer.write(text != null ? text : "");
        writer.endElement("span");
    }
}

